//	Program name..	Zinc Interface Library
//	Filename......	UI_MAP.HPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef UI_MAP_HPP
#define UI_MAP_HPP
#include <ui_evt.hpp>

/* ----- Definition of raw DOS scan-codes ----- */
const USHORT ESCAPE					= 0x011B;	// Miscellaneous keys
const USHORT ENTER					= 0x1C0D;
const USHORT BACKSPACE				= 0x0E08;
const USHORT CTRL_BACKSPACE			= 0x0E7F;
const USHORT TAB					= 0x0F09;
const USHORT BACKTAB				= 0x0F00;

const USHORT CTRL_BREAK				= 0x0000;
const USHORT CTRL_C					= 0x2E03;

const USHORT ALT_ESCAPE				= 0x0100;
const USHORT ALT_PERIOD				= 0x3400;
const USHORT ALT_SPACE				= 0x3920;
const USHORT ALT_WHITE_MINUS		= 0x8200;
const USHORT ALT_WHITE_PLUS			= 0x8300;

const USHORT ALT_Q					= 0x1000;
const USHORT ALT_W					= 0x1100;
const USHORT ALT_E					= 0x1200;
const USHORT ALT_R					= 0x1300;
const USHORT ALT_T					= 0x1400;
const USHORT ALT_Y					= 0x1500;
const USHORT ALT_U					= 0x1600;
const USHORT ALT_I					= 0x1700;
const USHORT ALT_O					= 0x1800;
const USHORT ALT_P					= 0x1900;

const USHORT ALT_A					= 0x1E00;
const USHORT ALT_S					= 0x1F00;
const USHORT ALT_D					= 0x2000;
const USHORT ALT_F					= 0x2100;
const USHORT ALT_G					= 0x2200;
const USHORT ALT_H					= 0x2300;
const USHORT ALT_J					= 0x2400;
const USHORT ALT_K					= 0x2500;
const USHORT ALT_L					= 0x2600;

const USHORT ALT_Z					= 0x2C00;
const USHORT ALT_X					= 0x2D00;
const USHORT ALT_C					= 0x2E00;
const USHORT ALT_V					= 0x2F00;
const USHORT ALT_B					= 0x3000;
const USHORT ALT_N					= 0x3100;
const USHORT ALT_M					= 0x3200;

const USHORT ALT_1					= 0x7800;
const USHORT ALT_2					= 0x7900;
const USHORT ALT_3					= 0x7A00;
const USHORT ALT_4					= 0x7B00;
const USHORT ALT_5					= 0x7C00;
const USHORT ALT_6					= 0x7D00;
const USHORT ALT_7					= 0x7E00;
const USHORT ALT_8					= 0x7F00;
const USHORT ALT_9					= 0x8000;
const USHORT ALT_0					= 0x8100;

const USHORT GRAY_ENTER				= 0xE00D;	// Grey keys
const USHORT GRAY_UP_ARROW			= 0x48E0;
const USHORT GRAY_DOWN_ARROW		= 0x50E0;
const USHORT GRAY_LEFT_ARROW		= 0x4BE0;
const USHORT GRAY_RIGHT_ARROW		= 0x4DE0;
const USHORT GRAY_INSERT			= 0x52E0;
const USHORT GRAY_DELETE			= 0x53E0;
const USHORT GRAY_HOME				= 0x47E0;
const USHORT GRAY_END				= 0x4FE0;
const USHORT GRAY_PGUP				= 0x49E0;
const USHORT GRAY_PGDN				= 0x51E0;
const USHORT GRAY_DIVIDE			= 0xE02F;
const USHORT GRAY_MULTIPLY			= 0x372A;
const USHORT GRAY_PLUS				= 0x4E2B;
const USHORT GRAY_MINUS				= 0x4A2D;

const USHORT CTRL_GRAY_UP_ARROW		= 0x8DE0;
const USHORT CTRL_GRAY_DOWN_ARROW	= 0x91E0;
const USHORT CTRL_GRAY_LEFT_ARROW	= 0x73E0;
const USHORT CTRL_GRAY_RIGHT_ARROW	= 0x74E0;
const USHORT CTRL_GRAY_INSERT		= 0x92E0;
const USHORT CTRL_GRAY_DELETE		= 0x93E0;
const USHORT CTRL_GRAY_HOME			= 0x77E0;
const USHORT CTRL_GRAY_END			= 0x75E0;
const USHORT CTRL_GRAY_PGUP			= 0x84E0;
const USHORT CTRL_GRAY_PGDN			= 0x76E0;
const USHORT CTRL_GRAY_DIVIDE		= 0x9500;
const USHORT CTRL_GRAY_MULTIPLY		= 0x9600;
const USHORT CTRL_GRAY_PLUS			= 0x9000;
const USHORT CTRL_GRAY_MINUS		= 0x8E00;

const USHORT ALT_GRAY_UP_ARROW		= 0x9800;
const USHORT ALT_GRAY_DOWN_ARROW	= 0xA000;
const USHORT ALT_GRAY_LEFT_ARROW	= 0x9B00;
const USHORT ALT_GRAY_RIGHT_ARROW	= 0x9D00;
const USHORT ALT_GRAY_INSERT		= 0xA200;
const USHORT ALT_GRAY_DELETE		= 0xA300;
const USHORT ALT_GRAY_HOME			= 0x9700;
const USHORT ALT_GRAY_END			= 0x9F00;
const USHORT ALT_GRAY_PGUP			= 0x9900;
const USHORT ALT_GRAY_PGDN			= 0xA100;
const USHORT ALT_GRAY_DIVIDE		= 0xA400;
const USHORT ALT_GRAY_MULTIPLY		= 0x3700;
const USHORT ALT_GRAY_PLUS			= 0x4E00;
const USHORT ALT_GRAY_MINUS			= 0x4A00;

const USHORT WHITE_UP_ARROW			= 0x4800;	// White keys
const USHORT WHITE_DOWN_ARROW		= 0x5000;
const USHORT WHITE_LEFT_ARROW		= 0x4B00;
const USHORT WHITE_RIGHT_ARROW		= 0x4D00;
const USHORT WHITE_INSERT			= 0x5200;
const USHORT WHITE_DELETE			= 0x5300;
const USHORT WHITE_HOME				= 0x4700;
const USHORT WHITE_END				= 0x4F00;
const USHORT WHITE_PGUP				= 0x4900;
const USHORT WHITE_PGDN				= 0x5100;
const USHORT WHITE_CENTER			= 0x4C00;

const USHORT CTRL_WHITE_UP_ARROW	= 0x8D00;
const USHORT CTRL_WHITE_DOWN_ARROW	= 0x9100;
const USHORT CTRL_WHITE_LEFT_ARROW	= 0x7300;
const USHORT CTRL_WHITE_RIGHT_ARROW	= 0x7400;
const USHORT CTRL_WHITE_INSERT		= 0x9200;
const USHORT CTRL_WHITE_DELETE		= 0x9300;
const USHORT CTRL_WHITE_HOME		= 0x7700;
const USHORT CTRL_WHITE_END			= 0x7500;
const USHORT CTRL_WHITE_PGUP		= 0x8400;
const USHORT CTRL_WHITE_PGDN		= 0x7600;
const USHORT CTRL_WHITE_CENTER		= 0x8F00;

const USHORT F1						= 0x3B00;	// Function keys
const USHORT F2						= 0x3C00;
const USHORT F3						= 0x3D00;
const USHORT F4						= 0x3E00;
const USHORT F5						= 0x3F00;
const USHORT F6						= 0x4000;
const USHORT F7						= 0x4100;
const USHORT F8						= 0x4200;
const USHORT F9						= 0x4300;
const USHORT F10					= 0x4400;
const USHORT F11					= 0x8500;
const USHORT F12					= 0x8600;

const USHORT SHIFT_F1				= 0x5400;
const USHORT SHIFT_F2				= 0x5500;
const USHORT SHIFT_F3				= 0x5600;
const USHORT SHIFT_F4				= 0x5700;
const USHORT SHIFT_F5				= 0x5800;
const USHORT SHIFT_F6				= 0x5900;
const USHORT SHIFT_F7				= 0x5A00;
const USHORT SHIFT_F8				= 0x5B00;
const USHORT SHIFT_F9				= 0x5C00;
const USHORT SHIFT_F10				= 0x5D00;
const USHORT SHIFT_F11				= 0x8700;
const USHORT SHIFT_F12				= 0x8800;

const USHORT CTRL_F1				= 0x5E00;
const USHORT CTRL_F2				= 0x5F00;
const USHORT CTRL_F3				= 0x6000;
const USHORT CTRL_F4				= 0x6100;
const USHORT CTRL_F5				= 0x6200;
const USHORT CTRL_F6				= 0x6300;
const USHORT CTRL_F7				= 0x6400;
const USHORT CTRL_F8				= 0x6500;
const USHORT CTRL_F9				= 0x6600;
const USHORT CTRL_F10				= 0x6700;
const USHORT CTRL_F11				= 0x8900;
const USHORT CTRL_F12				= 0x8A00;

const USHORT ALT_F1					= 0x6800;
const USHORT ALT_F2					= 0x6900;
const USHORT ALT_F3					= 0x6A00;
const USHORT ALT_F4					= 0x6B00;
const USHORT ALT_F5					= 0x6C00;
const USHORT ALT_F6					= 0x6D00;
const USHORT ALT_F7					= 0x6E00;
const USHORT ALT_F8					= 0x6F00;
const USHORT ALT_F9					= 0x7000;
const USHORT ALT_F10				= 0x7100;
const USHORT ALT_F11				= 0x8B00;
const USHORT ALT_F12				= 0x8C00;

/* ----- Definition of the logical events used by Zinc Interface Library. ----- */
const UCHAR HOT_KEY_MAXIMIZE		= 252;
const UCHAR HOT_KEY_MINIMIZE		= 253;
const UCHAR HOT_KEY_SYSTEM			= 254;
const UCHAR HOT_KEY_SUB_WINDOW		= 255;

const int L_EXIT					= 1000;
const int L_VIEW					= 1001;
const int L_SELECT					= 1002;
const int L_BEGIN_SELECT			= 1003;
const int L_CONTINUE_SELECT			= 1004;
const int L_END_SELECT				= 1005;
const int L_GENERAL_HELP			= 1006;
const int L_CONTEXT_HELP			= 1007;
const int L_PGUP					= 1028;
const int L_PGDN					= 1029;

const int L_WINDOW_NEXT				= 1010;		// Window manager
const int L_WINDOW_MOVE				= 1011;
const int L_WINDOW_SIZE				= 1012;
const int L_WINDOW_CASCADE			= 1013;

const int L_FIELD_UP				= 1020;		// Window object
const int L_FIELD_DOWN				= 1021;
const int L_FIELD_LEFT				= 1022;
const int L_FIELD_RIGHT				= 1023;
const int L_FIELD_PREVIOUS			= 1024;
const int L_FIELD_NEXT				= 1025;
const int L_FIELD_FIRST				= 1026;
const int L_FIELD_LAST				= 1027;
const int L_WINDOW_RESTORE			= 1028;

const int L_ITEM_UP					= 1030;		// pop-up/pull-down menus
const int L_ITEM_DOWN				= 1031;
const int L_ITEM_LEFT				= 1032;
const int L_ITEM_RIGHT				= 1033;
const int L_ITEM_PREVIOUS			= 1034;
const int L_ITEM_NEXT				= 1035;
const int L_ITEM_FIRST				= 1036;
const int L_ITEM_LAST				= 1037;

const int L_BEGIN_MARK				= 1101;	// String
const int L_CONTINUE_MARK			= 1102;
const int L_END_MARK				= 1103;
const int L_CUT						= 1104;
const int L_PASTE					= 1105;
const int L_UNDO					= 1106;
const int L_REDO					= 1107;
const int L_CUT_PASTE				= 1108;
const int L_MARK					= 1109;
const int L_DELETE_WORD				= 1110;
// const int (available)     		= 1111;
const int L_DELETE_EOL				= 1112;
const int L_DELETE					= 1113;
const int L_INSERT_TOGGLE			= 1114;
const int L_WORD_TAB_LEFT			= 1115;
const int L_WORD_TAB_RIGHT			= 1116;
const int L_MOVE_BOL				= 1117;
const int L_MOVE_EOL				= 1118;
const int L_MOVE_LEFT				= 1119;
const int L_MOVE_RIGHT				= 1120;
const int L_MOVE_TOP				= 1121;
const int L_MOVE_BOTTOM				= 1122;
const int L_MOVE_PAGE_UP			= 1123;
const int L_MOVE_PAGE_DOWN			= 1124;
const int L_MOVE_UP					= 1125;
const int L_MOVE_DOWN				= 1126;
const int L_COPY_MARK				= 1127;
const int L_MOVE					= 1131;

/* ----- Definition of object identifications ----- */
const int ID_END					= -1;	// Special value
//	  int ID_SCREEN					= 0;	// Defined in ui_dsp.hpp
const int ID_BORDER					= 1;
const int ID_BUTTON					= 2;
const int ID_DATE					= 3;
const int ID_FORMATTED_STRING		= 4;
const int ID_ICON					= 6;
const int ID_MATRIX					= 7;
const int ID_MAXIMIZE_BUTTON		= 8;
const int ID_MENU					= 9;
const int ID_MENU_ITEM				= 10;
const int ID_MINIMIZE_BUTTON		= 11;
const int ID_NUMBER					= 12;
const int ID_PROMPT					= 13;
const int ID_SCROLL_BAR				= 14;
const int ID_STRING					= 15;
const int ID_SYSTEM_BUTTON			= 16;
const int ID_TEXT					= 17;
const int ID_TEXT_ERROR				= 18;
const int ID_TIME					= 19;
const int ID_TITLE					= 20;
const int ID_TEXT_VIEW				= 21;
const int ID_WINDOW					= 22;
const int ID_WINDOW_OBJECT			= 23;
const int ID_WINDOW_MANAGER			= 24;

const int ID_OUTLINE				= 100;
const int ID_WHITE_SHADOW			= 101;
const int ID_LIGHT_SHADOW			= 102;
const int ID_DARK_SHADOW			= 103;
const int ID_BLACK_SHADOW			= 104;

/* ----- Definition of palette flags ----- */
const USHORT PM_ANY					= 0x0000;
const USHORT PM_ACTIVE				= 0x0001;
const USHORT PM_INACTIVE			= 0x0002;
const USHORT PM_SELECTED			= 0x0004;
const USHORT PM_CURRENT				= 0x0008;
const USHORT PM_INVALID				= 0x0010;
const USHORT PM_VIEW				= 0x0020;
const USHORT PM_HOT_KEY				= 0x0040;
const USHORT PM_NON_SELECTABLE		= 0x0080;

/* ----- Definition of the UI_EVENT_MAP information ----- */
struct UI_EVENT_MAP
{
	int windowID;
	int logicalValue;
	int eventType;
	USHORT rawCode;
};

extern UI_EVENT_MAP *_eventMapTable;
extern UI_EVENT_MAP *_hotKeyMapTable;

extern int MapEvent(UI_EVENT_MAP *mapTable, const UI_EVENT &event,
	int currentID, int id1 = ID_WINDOW_OBJECT, int id2 = ID_WINDOW_OBJECT,
	int id3 = ID_WINDOW_OBJECT, int id4 = ID_WINDOW_OBJECT);

/* ----- Definition of the UI_PALETTE_MAP information ----- */
typedef struct UI_PALETTE_MAP_STRUCT
{
	int windowID;
	int logicalValue;
	UI_PALETTE palette;
} UI_PALETTE_MAP;

extern UI_PALETTE_MAP *_normalPaletteMapTable;
extern UI_PALETTE_MAP *_helpPaletteMapTable;
extern UI_PALETTE_MAP *_errorPaletteMapTable;

extern UI_PALETTE *MapPalette(UI_PALETTE_MAP *mapTable, int logicalValue,
	int id1 = ID_WINDOW_OBJECT, int id2 = ID_WINDOW_OBJECT,
	int id3 = ID_WINDOW_OBJECT, int id4 = ID_WINDOW_OBJECT);

#endif /* UI_MAP_HPP */
