//	Program name..	Zinc Interface Library
//	Filename......	BORDER.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"

// ----- Static variables ---------------------------------------------------

int UIW_BORDER::size = 6;

// ----- Constructor & Destructor -------------------------------------------

UIW_BORDER::UIW_BORDER(void) :
	UI_WINDOW_OBJECT(0, 0, 0, 0, WOF_NON_FIELD_REGION,
		WOAF_OUTSIDE_REGION | WOAF_NON_CURRENT)
{
	// Initialize the border information.
	windowID[0] = ID_BORDER;
	depth = defaultDepth;
}

// ----- Member functions ---------------------------------------------------

int UIW_BORDER::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int tSize;
	UI_WINDOW_OBJECT::Information(GET_DEFAULT_HEIGHT, &tSize);
	tSize /= 2;
	UI_REGION region;
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_BORDER);
	switch (ccode)
	{
	case S_CREATE:
	case S_SIZE:
		UI_WINDOW_OBJECT::RegionMax(TRUE);
		if (!display->isText)
		{
			true.left += size;
			true.top += size;
			true.right -= size;
			true.bottom -= size;
		}
		break;

	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		// Draw the borders around the object.
		if (!display->isText && !UI_WINDOW_OBJECT::NeedsUpdate(event, ccode))
			break;
		UI_PALETTE *palette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
		lastPalette = palette;
		if (display->isText)
			display->Rectangle(screenID, true, palette, (ccode == S_DISPLAY_ACTIVE) ? 2 : 1);
		else
		{
			region = parent->true;
			eventManager->DevicesHide(parent->true);
			UI_PALETTE *outlinePalette = MapPalette(paletteMapTable,
				PM_ACTIVE, ID_BLACK_SHADOW);
			display->Rectangle(screenID, true, outlinePalette);
			display->Rectangle(screenID, region, outlinePalette);
			UI_WINDOW_OBJECT::Shadow(region, depth);

			// Display the top and bottom lines.
			int temp = region.bottom;
			region.bottom = true.top - 1;
			display->Fill(screenID, region, palette);
			region.bottom = temp;

			temp = region.top;
			region.top = true.bottom + 1;
			display->Fill(screenID, region, palette);
			region.top = temp;

			// Display the left and right columns.
			temp = region.right;
			region.right = true.left - 1;
			display->Fill(screenID, region, palette);
			region.right = temp;

			temp = region.left;
			region.left = true.right + 1;
			display->Fill(screenID, region, palette);

			// Draw the corner identifiers.
			if (FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE))
			{
				eventManager->DevicesShow(parent->true);
				break;
			}
			region = parent->true;
			region.left = true.left + tSize;
			region.right = true.right - tSize;
			if (region.left > region.right)
				region.left = region.right = (true.left + true.right) / 2;
			region.bottom = true.top;
			display->Rectangle(screenID, region, outlinePalette);
			region.top = true.bottom;
			region.bottom = parent->true.bottom;
			display->Rectangle(screenID, region, outlinePalette);

			region = parent->true;
			region.top = true.top + tSize;
			region.bottom = true.bottom - tSize;
			if (region.top > region.bottom)
				region.top = region.bottom = (true.top + true.bottom) / 2;
			region.right = true.left;
			display->Rectangle(screenID, region, outlinePalette);
			region.left = true.right;
			region.right = parent->true.right;
			display->Rectangle(screenID, region, outlinePalette);
			eventManager->DevicesShow(parent->true);
		}
		break;

	case L_VIEW:
	case L_BEGIN_SELECT:
		UI_EVENT tEvent = event;
		tEvent.rawCode = DM_VIEW;
		if (FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE))
		{
			eventManager->Event(tEvent);
			break;
		}
		region = true;
		region.left += tSize;
		region.right -= tSize;
		if (region.left > region.right)
			region.left = region.right = (true.left + true.right) / 2;
		region.top += tSize;
		region.bottom -= tSize;
		if (region.top > region.bottom)
			region.top = region.bottom = (true.top + true.bottom) / 2;

		int sizeFlags = 0;
		if (event.position.column <= region.left)
			sizeFlags |= M_LEFT_CHANGE;
		else if (event.position.column >= region.right)
			sizeFlags |= M_RIGHT_CHANGE;
		if (event.position.line <= region.top)
			sizeFlags |= M_TOP_CHANGE;
		else if (event.position.line >= region.bottom)
			sizeFlags |= M_BOTTOM_CHANGE;

 		if (FlagsSet(sizeFlags, M_LEFT_CHANGE | M_TOP_CHANGE) ||
			FlagsSet(sizeFlags, M_RIGHT_CHANGE | M_BOTTOM_CHANGE))
			tEvent.rawCode = DM_DIAGONAL_ULLR;
		else if (FlagsSet(sizeFlags, M_LEFT_CHANGE | M_BOTTOM_CHANGE) ||
			FlagsSet(sizeFlags, M_RIGHT_CHANGE | M_TOP_CHANGE))
			tEvent.rawCode = DM_DIAGONAL_LLUR;
		else if (FlagSet(sizeFlags, M_LEFT_CHANGE | M_RIGHT_CHANGE))
			tEvent.rawCode = DM_HORIZONTAL;
		else if (FlagSet(sizeFlags, M_TOP_CHANGE | M_BOTTOM_CHANGE))
			tEvent.rawCode = DM_VERTICAL;
		eventManager->Event(tEvent);

		if (ccode == L_BEGIN_SELECT && sizeFlags)
		{
			UI_EVENT tEvent = event;
			tEvent.type = S_SIZE;
			tEvent.rawCode = sizeFlags;
			eventManager->Put(tEvent, Q_BEGIN);
		}
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
 	return (ccode);
}
