//	Program name..	Zinc Interface Library
//	Filename......	BUTTON.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <string.h>
#include "ui_win.hpp"

// ----- Constructor & Destructor -------------------------------------------

UIW_BUTTON::UIW_BUTTON(int left, int top, int width, char *a_string,
	USHORT a_btFlags, USHORT a_woFlags,
	void (*a_userFunction)(void *object, UI_EVENT &event)) :
	UI_WINDOW_OBJECT(left, top, width, 1, a_woFlags | WOF_BORDER,
		WOAF_NO_FLAGS)
{
	// Initialize the button information.
	windowID[0] = ID_BUTTON;
	depth = defaultDepth;
	btFlags = a_btFlags;
	btStatus = 0;
	userFunction = a_userFunction;
	if (a_string)
	{
		string = (FlagSet(a_woFlags, WOF_NO_ALLOCATE_DATA)) ?
			a_string : ui_strdup(a_string);
		if (strchr(a_string, '~'))
		{
			true.right--;
			relative.right--;
		}
	}
	else
		string = 0;
}

UIW_BUTTON::~UIW_BUTTON(void)
{
	// Destroy the string information.
	if (string && !FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		delete string;
}

// ----- Member functions ---------------------------------------------------

void UIW_BUTTON::DataSet(char *newString)
{
	// Reset the button's string information.
	if (newString)
	{
		if (FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
			string = newString;
		else
		{
			if (string)
				delete string;
			string = (newString) ? ui_strdup(newString) : 0;
		}
	}

	// Do the redisplay by hand.  
	// The window class one doesn't work for buttons.
	UI_WINDOW_OBJECT *root = this;
	while (root->parent)
		root = root->parent;
	if (!root->display || !root->eventManager || !root->windowManager)
	{
		root->woAdvancedStatus |= WOAS_REDISPLAY;
		return;
	}

	// Redisplay the window by sending a create, then redisplay message.
	UI_EVENT event;
	event.type = (root == windowManager->First()) ?
		S_DISPLAY_ACTIVE : S_DISPLAY_INACTIVE;
	Event(event);
}

int UIW_BUTTON::Event(const UI_EVENT &event)
{
//	static USHORT time = 0;

	// Switch on the event type.
//	UI_EVENT tEvent;
	UI_REGION region = true;
	UI_PALETTE *palette;
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_BUTTON);
	int t_depth = (FlagSet(woFlags, WOF_NON_SELECTABLE)) ? 0 : depth;
	if (FlagSet(btFlags, BTF_CHECK_MARK))
		string[0] = (FlagSet(woStatus, WOS_SELECTED)) ? '' : ' ';
	switch (ccode)
	{
	case S_CREATE:
		{
		char *tHotKey = strchr(string, '~');
		if (tHotKey)
			hotKey = toupper(tHotKey[1]);
		}
		// Continue to S_SIZE.

	case S_SIZE:
		ccode = UI_WINDOW_OBJECT::Event(event);

		// Check for button too small in window and matrix.
		if (parent && !display->isText && depth > 0 &&
			parent->true.bottom <= true.bottom + 1)
			woAdvancedStatus |= WOAS_TOO_SMALL;
		break;

	case S_NON_CURRENT:
		woStatus &= ~WOS_CURRENT;
		btStatus &= ~BTS_DEPRESSED;
		palette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
		UI_WINDOW_OBJECT::Text(string, t_depth, ccode, palette);
		break;

	case S_CURRENT:
	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		// Display the button information.
		if (ccode == S_CURRENT || UI_WINDOW_OBJECT::NeedsUpdate(event, ccode)
			|| !FlagSet(woStatus, WOS_CURRENT))
		{
			lastPalette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
			UI_WINDOW_OBJECT::Text(string, t_depth, ccode, lastPalette);
		}
		break;

	case L_VIEW:
		// See if it is an event the button knows how to handle.
		if (event.rawCode == 0)
		{
			UI_WINDOW_OBJECT::Event(event);
			break;
		}
		// Continue to L_BEGIN_SELECT.

	case L_BEGIN_SELECT:
	case L_CONTINUE_SELECT:
	case L_END_SELECT:
		// Make sure the button can be selected.
		if (FlagSet(woFlags, WOF_NON_SELECTABLE))
			break;

		/* Make sure the button needs to be depressed */
		if (!FlagSet(btStatus, BTS_DEPRESSED) && 
			UI_WINDOW_OBJECT::Overlap(event.position))
		{
			if (display->isText)
			{
				palette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
				UI_WINDOW_OBJECT::Text(string, 0, ccode, palette);
			}
			else
				UI_WINDOW_OBJECT::Shadow(region, -t_depth);
			btStatus |= BTS_DEPRESSED;
		}
		else if (FlagSet(btStatus, BTS_DEPRESSED) &&
			!UI_WINDOW_OBJECT::Overlap(event.position))
		{
			if (display->isText)
			{
				palette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
				UI_WINDOW_OBJECT::Text(string, 0, ccode, palette);
			}
			else
				UI_WINDOW_OBJECT::Shadow(region, t_depth);
			btStatus &= ~BTS_DEPRESSED;
		}
		if (ccode == L_BEGIN_SELECT && FlagSet(btFlags, BTF_DOWN_CLICK))
			ccode = L_END_SELECT;
		else if (ccode != L_BEGIN_SELECT && FlagSet(btFlags, BTF_DOWN_CLICK))
			break;

		/* See if the button is to be selected */
		if (!UI_WINDOW_OBJECT::Overlap(event.position) || ccode != L_END_SELECT)
			break;
		// Continue to L_SELECT.

	case L_SELECT:
		if (!FlagSet(woStatus, WOS_SELECTED) && !FlagSet(btFlags, BTF_NO_TOGGLE))
			woStatus |= WOS_SELECTED;
		else if (!FlagSet(btFlags, BTF_NO_TOGGLE))
			woStatus &= ~WOS_SELECTED;
		btStatus &= ~BTS_DEPRESSED;
		UI_EVENT t_event = event;
		if (userFunction)
			(*userFunction)(this, t_event);
		woStatus &= ~WOS_UNANSWERED;
		if (FlagSet(btFlags, BTF_CHECK_MARK))
			string[0] = (FlagSet(woStatus, WOS_SELECTED)) ? '' : ' ';
 		palette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
 		UI_WINDOW_OBJECT::Text(string, t_depth, ccode, palette);
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
