//	Program name..	Zinc Interface Library
//	Filename......	DATE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include "ui_gen.hpp"

static int _daysInMonth[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

DATE_TEXT _monthNames[] =
{
	{ "Jan.",	"January"	},
  	{ "Feb.",	"February"	},
  	{ "Mar.",	"March"		},
  	{ "Apr.",	"April"		},
  	{ "May",	"May"		},
  	{ "June",	"June"		},
  	{ "July",	"July"		},
  	{ "Aug.",	"August"  	},
  	{ "Sept.",	"September"	},
	{ "Oct.",	"October"	},
  	{ "Nov.",	"November"	},
  	{ "Dec.",	"December"	}
};
DATE_TEXT _dayNames[] =
{
	{ "Sun.",	"Sunday"  	},
	{ "Mon.",	"Monday"  	},
	{ "Tues.",	"Tuesday"	},
	{ "Wed.",	"Wednesday"	},
	{ "Thurs.",	"Thursday"	},
	{ "Fri.",	"Friday"  	},
	{ "Sat.",	"Saturday"	}
};

DATE_TEXT *UI_DATE::monthTable = _monthNames;
DATE_TEXT *UI_DATE::dayTable = _dayNames;

static int TokenMatch(char *table, const char *token, int length)
{
	if (toupper(*table) != toupper(*token))
		return 0;			// No match.
	while (length)
	{
		while (*table && toupper(*table) != toupper(*token))
			table++;
		if (toupper(*table) == toupper(*token))
		{
			table++;
			token++;
		}
		else
			return 0;		// No match.
		length--;
	}
	return 1;				// Partial match.
}

// ----- Member functions ---------------------------------------------------

int UI_DATE::DayOfWeek(void)
{
	if (dYear > 0 && dMonth && dDay)
	{
		int totalDays = dDay + ( (dYear - 1) / 4) * 5 + ( (dYear - 1) % 4);
 		for (int i = 1; i < dMonth; i++)
			totalDays += _daysInMonth[i - 1];
		if (dMonth > 2)
			totalDays += LeapYear();
		/* Return the day of week */
		return ((totalDays - 1) % 7) + 1;
	}
	else
		return 0;
}

int UI_DATE::DaysInMonth(void)
{
	return(_daysInMonth[dMonth - 1] + LeapYear());
}

int UI_DATE::LeapYear(void)
{
	// Return TRUE if a leap year, else FALSE.
	return((dYear % 400 == 0) || ((dYear % 4 == 0) && (dYear % 100 != 0)));
}

void UI_DATE::NameTablesSet(DATE_TEXT *monthTablePtr, DATE_TEXT *dayTablePtr)
{
	monthTable = monthTablePtr ? monthTablePtr : _monthNames;
	dayTable = dayTablePtr ? dayTablePtr : _dayNames;
}

int UI_DATE::TableLookup(DATE_TEXT *table, int tableLength,
	const char *token)
{
	const char *ptr = token;
	int length = 0;
	int match = 0;

	while (isalpha(*ptr))
	{
		ptr++;
		length++;
	}
	for (int i = 0; i < tableLength; i++)
	{
		int result = TokenMatch(table[i].text, token, length);
		if (result == 2)
			return i + 1;					// Full match.
		else if (result)
		{
			if (match)
				return -1;					// Ambiguous.
			else
				match = i + 1;
		}
	}
	return match;
}
