//	Program name..	Zinc Interface Library
//	Filename......	DATEEXP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ui_gen.hpp"

// ----- Member functions ---------------------------------------------------

void UI_DATE::Export(void)
{
	struct date info;
	info.da_year = dYear,
		info.da_mon = dMonth,
		info.da_day = dDay;
	setdate(&info);
}

void UI_DATE::Export(int *packedDate)
{
	*packedDate = ((dYear - 1980) << 9) | (dMonth << 5) | dDay;
}

void UI_DATE::Export(int *year, int *month, int *day, int *dayOfWeek)
{
	if (year) *year = dYear;
	if (month) *month = dMonth;
	if (day) *day = dDay;
	if (dayOfWeek) *dayOfWeek = DayOfWeek();
}

void UI_DATE::Export(char *string, int maxLength, USHORT dtFlags)
{
	int dayOfWeek = DayOfWeek();
	/* Get the initial separators */
	GetCountryInfo();
	char dateFormat = _countryInfo.co_date;
	if (FlagSet(dtFlags, DTF_US_FORMAT))
		dateFormat = 0;
	else if (FlagSet(dtFlags, DTF_EUROPEAN_FORMAT | DTF_MILITARY_FORMAT))
		dateFormat = 1;
	else if (FlagSet(dtFlags, DTF_JAPANESE_FORMAT))
		dateFormat = 2;
	char separator = _countryInfo.co_dtsep[0];
	if (FlagSet(dtFlags, DTF_DASH))
		separator = '-';
	else if (FlagSet(dtFlags, DTF_SLASH))
		separator = '/';
	char yearSize = 1;
	char alphaMonth = FlagSet(dtFlags, DTF_ALPHA_MONTH) ? 2 : 0;
	char showDayOfWeek = FlagSet(dtFlags, DTF_DAY_OF_WEEK) ? 2 : 0;
	char autoShorten = TRUE;
	USHORT zeroFill = FlagSet(dtFlags, DTF_ZERO_FILL);
	if (FlagSet(dtFlags, DTF_SHORT_YEAR))
	{
		autoShorten = FALSE;
		yearSize = 0;
	}
	if (FlagSet(dtFlags, DTF_SHORT_MONTH))
	{
		autoShorten = FALSE;
		alphaMonth = 1;
	}
	if (FlagSet(dtFlags, DTF_SHORT_DAY))
	{
		autoShorten = FALSE;
		showDayOfWeek = 1;
	}
	for (;;)
	{
		char tempDate[64];
		char *ptr = tempDate;
		if (showDayOfWeek && dayOfWeek)
		{
			char *shortDay = dayTable[dayOfWeek - 1].shortText;
			if (showDayOfWeek == 1 && shortDay)
				strcpy(tempDate, shortDay);
			else
				strcpy(tempDate, dayTable[dayOfWeek - 1].text);
			strcat(tempDate, "  ");
			ptr = strchr(tempDate, '\0');
		}
		char s_year[10];
		sprintf(s_year, dYear ? "%d" : "", yearSize ? dYear : dYear % 100);
		char s_month[15];
		if (FlagSet(dtFlags, DTF_MILITARY_FORMAT) && dMonth)
		{
			memcpy(s_month, monthTable[dMonth - 1].text, 3);
			s_month[3] = '\0';
		}
		else if (alphaMonth && dMonth)
		{
			char *shortMonth = monthTable[dMonth - 1].shortText;
			if (alphaMonth == 1 && shortMonth)
				strcpy(s_month, shortMonth);
			else
				strcpy(s_month, monthTable[dMonth - 1].text);
		}
		else
			sprintf(s_month, dMonth ? (zeroFill ? "%02d" : "%d") : "", dMonth);
		char s_day[10];
		sprintf(s_day, dDay ? (zeroFill ? "%02d" : "%d") : "", dDay);
		char realSeparator = (FlagSet(dtFlags, DTF_MILITARY_FORMAT) || alphaMonth) ?
			' ' : separator;
		if (dateFormat == 1)				// European
			sprintf(ptr, "%s%c%s%c%s",
				s_day, realSeparator, s_month, realSeparator, s_year);
		else if (dateFormat == 2)			// Japan
			sprintf(ptr, "%s%c%s%c%s",
				s_year, realSeparator, s_month, realSeparator, s_day);
		else								// U.S.
		{
			if (dMonth && dDay && dYear && alphaMonth)
				sprintf(ptr, "%s %s, %s", s_month, s_day, s_year);
			else
				sprintf(ptr, "%s%c%s%c%s",
						s_month, realSeparator, s_day, realSeparator, s_year);
		}
		// Strip leading separators.
		while (*ptr == realSeparator)
			memmove(ptr, ptr + 1, strlen(ptr));
		// Strip trailing separators and double separators.
		while (*ptr)
		{
			if (*ptr == realSeparator &&
				 (*(ptr + 1) == realSeparator || *(ptr + 1) == '\0'))
				memmove(ptr, ptr + 1, strlen(ptr));
			else
				ptr++;
		}
		if (FlagSet(dtFlags, DTF_UPPER_CASE))
			strupr(tempDate);
		if (strlen(tempDate) <= maxLength)
		{
			strcpy(string, tempDate);
			break;
		}
		if (autoShorten)
		{
			if (showDayOfWeek == 2)
				showDayOfWeek--;
			else if (alphaMonth == 2)
				alphaMonth--;
			else if (yearSize)
				yearSize--;
			else if (showDayOfWeek)
				showDayOfWeek--;
			else if (alphaMonth)
				alphaMonth--;
			else
				autoShorten = FALSE;
		}
		else
		{
			strcpy(string, tempDate);
			break;
		}
	}
}

