//	Program name..	Zinc Interface Library
//	Filename......	DATEIMP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_gen.hpp"

// ----- Member functions ---------------------------------------------------

DTI_RESULT UI_DATE::Import(void)
{
	struct date info;
	getdate(&info);
	return(Import(info.da_year, info.da_mon, info.da_day));
}

DTI_RESULT UI_DATE::Import(int date)
{
	return(Import(1980 + ((date & 0xFE00) >> 9), (date & 0x01E0) >> 5, date & 0x001F));
}

DTI_RESULT UI_DATE::Import(int year, int month, int day)
{
	if (year <= 0 || month < 0 || month > 12 || day < 0 || day > 31)
		return (DTI_INVALID);
	dYear = year;
	dMonth = month;
	dDay = day;
	return (DTI_OK);
}

DTI_RESULT UI_DATE::Import(const char *string, USHORT dtFlags)
{
	int tYear = 0;
	int tMonth = 0;
	int tDay = 0;

	GetCountryInfo();

	//	NOTE:  For the purposes of the date string conversion algorithm, we
	//	are only concerned with the respective order of the month and day
	//	fields.  Therefore, the only significance to the dateFormat values is
	//	whether the value equals 1 or not.  We save a line of code by calling
	//	the JAPANESE_FORMAT a 0 even though it is really a 2.
	char dateFormat = _countryInfo.co_date;
	if (FlagSet(dtFlags, DTF_US_FORMAT | DTF_JAPANESE_FORMAT))
		dateFormat = 0;
	else if (FlagSet(dtFlags, DTF_EUROPEAN_FORMAT | DTF_MILITARY_FORMAT))
		dateFormat = 1;
	int alphaMonth = FALSE;
	int isBlank = TRUE;
	while (*string)
	{
		if (isalpha(*string))
		{
			int monthValue = TableLookup(monthTable, 12, string);
			if (!tMonth && monthValue < 0 ||
				(alphaMonth && monthValue > 0 && monthValue != tMonth))
				return DTI_AMBIGUOUS;	// Ambiguous.
			if (!tMonth && monthValue > 0)
				tMonth = monthValue;
			else if (tMonth && !tDay && !alphaMonth && monthValue > 0)
			{
				// The "month" we thought we had must have been the day.
				tDay = tMonth;
				tMonth = monthValue;
			}
			else if (TableLookup(dayTable, 7, string) == 0)
				return DTI_INVALID_NAME; 	// Invalid month or week day name.
			if (monthValue > 0)
				alphaMonth = TRUE;
			while (isalpha(*string))
				string++;
			isBlank = FALSE;
		}
		else if (isdigit(*string))
		{
			int value = atoi(string);
			if (value <= 0)
				return DTI_INVALID;	// Bad number.
			if (value > 31)					// Must be the year.
			{
				if (tYear)
					return DTI_INVALID;
				else
					tYear = value < 100 ? 1900 + value : value;
			}
			else if (value > 12 || tMonth ||
					 FlagSet(dtFlags, DTF_FORCE_ALPHA_MONTH))
			{							// Must be the day.
				if (tDay)
					return DTI_INVALID;
				else
					tDay = value;
			}
			else if (tDay)				// Must be the month.
			{
				if (tMonth || FlagSet(dtFlags, DTF_FORCE_ALPHA_MONTH))
					return DTI_INVALID;
				else
					tMonth = value;
			}
			else						// Could be month or day.
			{
				if (dateFormat == 1)
					tDay = value;
				else
					tMonth = value;
			}
			while (isdigit(*string))
				string++;
			isBlank = FALSE;
		}
		else
			string++;			// Ignore spaces and punctuation.
	}
	if (tMonth && !alphaMonth && !tDay)
	{
		tDay = tMonth;				// Single digit is a day.
		tMonth = 0;
	}
	UI_DATE today;
	if (isBlank)
	{
		if (FlagSet(dtFlags, DTF_SYSTEM))
		{
			tYear = today.dYear;
			tMonth = today.dMonth;
			tDay = today.dDay;
		}
		else
		{
			Import(0, 0, 0);				// Zero all fields.
			return DTI_VALUE_MISSING;
		}
	}
	return Import(tYear, tMonth, tDay);
}

