//	Program name..	Zinc Interface Library
//	Filename......	G_PNORM.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include "ui_map.hpp"

static UI_PALETTE_MAP normalPaletteMapTable[] =
{
	/* ID_WINDOW_OBJECT */
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE)} },
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		SOLID_FILL, attrib(BLACK, LIGHTGRAY), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_GRAY)} },
	{ ID_WINDOW_OBJECT, PM_VIEW,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		SOLID_FILL, attrib(LIGHTGRAY, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_GRAY, GS_WHITE)} },

	/* ID_WINDOW */
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },

	/* ID_SCROLL_BAR */
	{ ID_SCROLL_BAR, PM_ANY,
 		{ 0xb0, attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		INTERLEAVE_FILL, attrib(RED, RED), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },

	/* ID_BORDER */
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(LIGHTGRAY, LIGHTGRAY), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_WHITE, GS_GRAY) } },

	/* ID_TITLE */
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLUE, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(YELLOW, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(YELLOW, LIGHTBLUE), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_BLACK, GS_GRAY) } },

	/* ID_PROMPT */
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(YELLOW, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },

	/* ID_BUTTON */
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(DARKGRAY, LIGHTGRAY), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_GRAY) } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		SOLID_FILL, attrib(WHITE, DARKGRAY), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_GRAY) } },
	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(YELLOW, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(YELLOW, LIGHTGRAY), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_WHITE, GS_GRAY) } },

	/* ID_MENU_ITEM */
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(LIGHTGRAY, DARKGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		SOLID_FILL, attrib(BLACK, LIGHTGRAY), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_BLACK, GS_GRAY) } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_VIEW,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(LIGHTGRAY, WHITE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_GRAY, GS_WHITE) } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_WHITE, GS_BLACK) } },

	/* Special palettes */
	{ ID_OUTLINE, ~PM_VIEW,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_BLACK, GS_BLACK) } },
	{ ID_OUTLINE, PM_VIEW,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(LIGHTGRAY, LIGHTGRAY), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY) } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		SOLID_FILL, attrib(WHITE, WHITE), attrib(BW_WHITE, BW_WHITE),
		attrib(GS_WHITE, GS_WHITE) } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, DARKGRAY), attrib(MONO_DIM, MONO_DIM),
		SOLID_FILL, attrib(DARKGRAY, DARKGRAY), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_BLACK, GS_BLACK) } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_BLACK, GS_BLACK) } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_BLACK, GS_BLACK) } },

	/* End of array */
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
UI_PALETTE_MAP *_normalPaletteMapTable = normalPaletteMapTable;

