//	Program name..	Zinc Interface Library
//	Filename......	ICON.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"

// Static variable ----------------------------------------------------------

USHORT UIW_ICON::repeatRate = 12;

// Constructor & Destructor -------------------------------------------------

UIW_ICON::UIW_ICON(int left, int top, USHORT **a_bitmapArray,
	UI_PALETTE *a_paletteArray, USHORT a_icFlags, USHORT a_woFlags,
	void (*a_userFunction)(void *object, UI_EVENT &event)) :
	UI_WINDOW_OBJECT(left, top, 1, 1, a_woFlags, WOAF_NO_FLAGS)
{
	// Initialize the basic icon information.
	windowID[0] = ID_ICON;
	icFlags = a_icFlags;
	bitmapArray = a_bitmapArray;
	paletteArray = a_paletteArray;
	userFunction = a_userFunction;
	lastTime = 0;

	// Determine the icon height and width.
	int maxWidth = 0;
	int maxHeight = 0;
	USHORT *bitmap;
	for (int i = 0; a_bitmapArray[i]; i++)
	{
		bitmap = a_bitmapArray[i];
		if (bitmap[BITMAP_WIDTH] > maxWidth)
			maxWidth = bitmap[BITMAP_WIDTH];
		if (bitmap[BITMAP_HEIGHT] > maxHeight)
			maxHeight = bitmap[BITMAP_HEIGHT];
	}
	relative.left *= 8;
	relative.top *= 14;
	relative.right = relative.left + maxWidth - 1;
	relative.bottom = relative.top + maxHeight - 1;
	woStatus |= WOS_GRAPHICS;
	true = relative;
}

// ----- Member functions ---------------------------------------------------

void UIW_ICON::DataSet(USHORT **a_bitmapArray, UI_PALETTE *a_paletteArray)
{
	bitmapArray = a_bitmapArray;
	paletteArray = a_paletteArray;

	// Compute the new icon height and width.
	int maxWidth = 0;
	int maxHeight = 0;
	USHORT *bitmap;
	for (int i = 0; a_bitmapArray[i]; i++)
	{
		bitmap = a_bitmapArray[i];
		if (bitmap[BITMAP_WIDTH] > maxWidth)
			maxWidth = bitmap[BITMAP_WIDTH];
		if (bitmap[BITMAP_HEIGHT] > maxHeight)
			maxHeight = bitmap[BITMAP_HEIGHT];
	}
	relative.right = relative.left + maxWidth - 1;
	relative.bottom = relative.top + maxHeight - 1;
	UI_WINDOW_OBJECT::Redisplay(TRUE);
}

UIW_ICON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_ICON);
	if (display->isText)
		return (ccode);
	switch (ccode)
	{
	case S_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		if (!UI_WINDOW_OBJECT::Overlap(event.region))
			break;
		UI_PALETTE *palette = (paletteArray) ? &paletteArray[0] : lastPalette;
		if (!FlagSet(icFlags, ICF_TRANSPARENT))
		{
			display->Fill(screenID, true, palette);
			display->Bitmap(screenID, true, bitmapArray[0], &paletteArray[0],
				FALSE);
		}
		else
			display->Bitmap(screenID, true, bitmapArray[0], &paletteArray[0],
				TRUE);
		for (int i = 1; bitmapArray[i]; i++)
			display->Bitmap(screenID, true, bitmapArray[i], &paletteArray[i],
				FALSE);
		break;

	case L_BEGIN_SELECT:
		// Check for a double click.
		if (*((USHORT far *)0x46CL) - lastTime < repeatRate && userFunction)
		{
			UI_EVENT tEvent = event;
			(*userFunction)(this, tEvent);
			lastTime = 0;
		}
		else
			lastTime = *((USHORT far *)0x46CL);
		// Continue to L_VIEW.

	case L_VIEW:
		if (parent || FlagSet(woAdvancedFlags, WOAF_NO_MOVE))
			ccode = UI_WINDOW_OBJECT::Event(event);
		else if (UI_WINDOW_OBJECT::Overlap(event.position))
		{
			UI_EVENT tEvent = event;
			tEvent.rawCode = DM_MOVE;
			eventManager->Event(tEvent);
			if (ccode == L_BEGIN_SELECT)
			{
				tEvent.type = S_MOVE;
				eventManager->Put(tEvent, Q_BEGIN);
			}
		}
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
 	return (ccode);
}
