//	Program name..	Zinc Interface Library
//	Filename......	LISTBLK.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_gen.hpp"

// ----- Member functions ---------------------------------------------------

UI_LIST_BLOCK::~UI_LIST_BLOCK(void)
{
	// Establish null lists so it doesn't free up an unknown block.
	first = last = 0;
	freeList.first = freeList.last = 0;
}

UI_ELEMENT *UI_LIST_BLOCK::Add(UI_ELEMENT *element)
{
	UI_ELEMENT *newElement = freeList.first;

	// Add a new list element to the use list at specified location.
	if (newElement)
	{
		freeList.Subtract(newElement);
		UI_LIST::Add(element, newElement);
	}

	// Return a pointer to the new element.
	return (newElement);
}

UI_ELEMENT *UI_LIST_BLOCK::Add(void)
{
	UI_ELEMENT *newElement = freeList.first;

	// Add a new list element to the use list according to compareFunction.
	if (newElement)
	{
		freeList.Subtract(newElement);
		UI_LIST::Add(newElement);
	}

	// Return a pointer to the new element.
	return (newElement);
}

UI_ELEMENT *UI_LIST_BLOCK::Subtract(UI_ELEMENT *element)
{
	UI_ELEMENT *nextElement = element->next;

	// Delete the element from the use list.
	UI_LIST::Subtract(element);
	freeList.Add(0, element);

	// Return the next element.
	return (nextElement);
}
