//	Program name..	Zinc Interface Library
//	Filename......	MAP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_map.hpp"

int MapEvent(UI_EVENT_MAP *mapTable, const UI_EVENT &event, int currentID,
	int id1, int id2, int id3, int id4)
{
	int level = 3;
	int eventType = event.type;
	int logicalValue = eventType;
	USHORT eventRawCode = event.rawCode;
	int id[3] = { id2, id3, id4 };
	if (currentID == id1)
		currentID = 0;
	else if (currentID == id2)
		currentID = 1;
	else if (currentID == id3)
		currentID = 2;
	else
		currentID = 3;

	// Try to find a matching event.
	for (UI_EVENT_MAP *map = mapTable; map->windowID != ID_END; map++)
		if (map->rawCode == eventRawCode && map->eventType == eventType)
		{
			if (map->windowID == id1 && currentID == 0)
				return(map->logicalValue);
			int i = (currentID == 0) ? 0 : currentID - 1;
			for ( ; i < 3; i++)
				if (map->windowID == id[i] && level > i)
				{
					level = i;
					logicalValue = map->logicalValue;
					break;
				}
		}

	// Return the logical match value.
	return (logicalValue);
}
