//	Program name..	Zinc Interface Library
//	Filename......	MAP1.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_map.hpp"

UI_PALETTE *MapPalette(UI_PALETTE_MAP *mapTable, int logicalValue,
	int id1, int id2, int id3, int id4)
{
	int level = 8;
	UI_PALETTE *palette = &mapTable[0].palette;
	int id[4] = { id1, id2, id3, id4 };

	// Try to find a matching palette.
	for (UI_PALETTE_MAP *map = mapTable; map->windowID != ID_END; map++)
		if (map->windowID == id1 && FlagSet(map->logicalValue, logicalValue))
			return(&map->palette);
		else
		{
			for (int i = 0; i < 4; i++)
				if (map->windowID == id[i] &&
					map->logicalValue == PM_ANY && level > 2 * i + 1)
				{
					level = 2 * i + 1;
					palette = &map->palette;
					break;
				}
				else if (map->windowID == id[i] &&
					FlagSet(map->logicalValue, logicalValue) && level > 2 * i)
				{
					level = 2 * i;
					palette = &map->palette;
					break;
				}
		}

	// Return the logical match palette.
	return (palette);
}
