//	Program name..	Zinc Interface Library
//	Filename......	STRDUP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>

char *ui_strdup(const char *srcString)
{
	// strdup using new instead of malloc.
	char *destString = new char[strlen(srcString) + 1];
	strcpy(destString, srcString);
	return (destString);
}

int ui_strlen(const char *string)
{
	int index = 0;

	// strlen that checks for null.
	while (*string)
	{
		index++;
		string++;
	}
	return (index);
}

void ui_strrepc(char *str, int c, int repc)
{
	// Replace a character (c) in a string (str) to a new character (repc).
    while (*str)
	{
		if (*str == c)
			*str = repc;
		str++;
    }
}

