//	Program name..	Zinc Interface Library
//	Filename......	NUMFE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_win.hpp"

#define	NMF_PRECISION_FLAGS	0xF000

// Constructor & Destructor -------------------------------------------------

UIW_NUMBER::UIW_NUMBER(int left, int top, int width, float *a_value,
	char *a_range, USHORT flags, USHORT woFlags,
	int (*validate)(void *object, int ccode)) :
	UI_WINDOW_OBJECT(left, top, width, 1, woFlags, WOAF_NO_FLAGS)
{
	type = NUM_FLOAT;
	Constructor(a_value, width, flags, a_range,
		UIW_NUMBER::RealToAscii, UIW_NUMBER::AsciiToReal,
		UIW_NUMBER::ValidRealNumber, validate);
}

UIW_NUMBER::UIW_NUMBER(int left, int top, int width, double *a_value,
	char *a_range, USHORT flags, USHORT woFlags,
	int (*validate)(void *object, int ccode)) :
	UI_WINDOW_OBJECT(left, top, width, 1, woFlags, WOAF_NO_FLAGS)
{
	type = NUM_DOUBLE;
	Constructor(a_value, width, flags, a_range,
		UIW_NUMBER::RealToAscii, UIW_NUMBER::AsciiToReal,
		UIW_NUMBER::ValidRealNumber, validate);
}

void UIW_NUMBER::RealToAscii(void)
{
	int maxSigDigits = (type == NUM_FLOAT) ? 7 : 15;

	if (FlagSet(woStatus, WOS_UNANSWERED))
	{
		if (type == NUM_FLOAT)
			*((float *)value) = 0.0;
		else
			*((double *)value) = 0.0;
	}
	char tempBuff[256];
	sprintf(tempBuff, FlagSet(nmFlags, NMF_SCIENTIFIC) ? "%.*E" : "%.*G",
		FlagSet(nmFlags, NMF_SCIENTIFIC) ? maxSigDigits - 1 : maxSigDigits,
		type == NUM_FLOAT ? *((float *)value) : *((double *)value));
	char *exp = strchr(tempBuff, 'E');
	char *dec = strchr(tempBuff, '.');
	if (decimal == 0xFF)						// Floating decimal
	{
		// Strip trailing zeroes from exponent. (not necessary for %G format)
		while (*(exp - 1) == '0' && dec && exp - 2 > dec)
		{
			memmove(exp - 1, exp, strlen(exp) + 1);
			exp--;
		}
	}
	else										// Fixed point decimal.
	{
		if (decimal == 0)
		{
			if (dec)
			 	*dec = '\0';
		}
		else
		{
			sprintf(tempBuff, exp ? "%.*E" : "%.*f", decimal,
				type == NUM_FLOAT ? *((float *)value) : *((double *)value));
			exp = strpbrk(tempBuff, "Ee");
			*exp = '\0';							// Strip the exponent.
		}
	}
	exp = strpbrk(tempBuff, "Ee");
	char *ptr;
	if (exp)
	{
		*exp = 'E';
		ptr = exp + 1;
		while (*ptr == '+' || *ptr == '-' || *ptr == '0')
		{
			if (*ptr == '-')
				ptr++;
			else
				memmove(ptr, ptr + 1, strlen(ptr));
		}
		if (*ptr == '\0')
			*exp = '\0';		// Clip exponent of zero.
	}
	ptr = tempBuff[0] == '-' ? tempBuff + 1 : tempBuff;
	if (strcmp(ptr, "0.0") == 0)
		*(ptr + 1) = '\0';		// Convert "0.0" to "0".
	ui_strrepc(tempBuff, '.', _countryInfo.co_desep[0]);
	tempBuff[NUM_MAX_TEXT_LEN - 1] = '\0';		// Insure it fits.
	strcpy(state.text, tempBuff);
}

void UIW_NUMBER::AsciiToReal(void)
{
	if (type == NUM_FLOAT)
	{
		*((float *)value) = atof(state.text);
		if (state.isNegative)
			*((float *) value) = - *((float *) value);
	}
	else
	{
		*((double *)value) = atof(state.text);
		if (state.isNegative)
			*((double *) value) = - *((double *) value);
	}
}
