//	Program name..	Zinc Interface Library
//	Filename......	POPUP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <mem.h>
#include <ctype.h>
#include <string.h>
#include "ui_win.hpp"

static void Close(void *item, UI_EVENT &event)
{
 	event.type = S_DELETE;
 	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

static void Maximize(void *item, UI_EVENT &event)
{
 	event.type = S_MAXIMIZE;
 	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

static void Minimize(void *item, UI_EVENT &event)
{
 	event.type = S_MINIMIZE;
 	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

static void Move(void *item, UI_EVENT &event)
{
	UI_WINDOW_OBJECT *topWindow = ((UIW_POP_UP_ITEM *)item)->parent;
	while (topWindow->parent)
		topWindow = topWindow->parent;
 	event.type = S_MOVE;
	event.position.column = topWindow->true.left;
	event.position.line = topWindow->true.top;
 	topWindow->eventManager->Put(event, Q_BEGIN);
}

static void Restore(void *item, UI_EVENT &event)
{
	UI_WINDOW_OBJECT *topWindow = ((UIW_POP_UP_ITEM *)item)->parent;
	while (topWindow->parent)
		topWindow = topWindow->parent;
	event.type = (FlagSet(topWindow->woAdvancedStatus, WOAS_MINIMIZED)) ?
		S_MINIMIZE : S_MAXIMIZE;
 	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

static void Size(void *item, UI_EVENT &event)
{
	UI_WINDOW_OBJECT *topWindow = ((UIW_POP_UP_ITEM *)item)->parent;
	while (topWindow->parent)
		topWindow = topWindow->parent;
 	event.type = S_SIZE;
	event.rawCode = M_RIGHT_CHANGE | M_BOTTOM_CHANGE;
	event.position.column = topWindow->true.right;
	event.position.line = topWindow->true.bottom;
 	topWindow->eventManager->Put(event, Q_BEGIN);
 	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(char *a_string, USHORT a_mniFlags,
	USHORT a_btFlags, USHORT a_woFlags,
	void (*a_userFunction)(void *object, UI_EVENT &event)) :
	UIW_BUTTON(0, 0, strlen(a_string) + 2, 0, a_btFlags, a_woFlags,
		a_userFunction)
{
	/* Initialize the menu item information */
	windowID[0] = ID_MENU_ITEM;
	windowID[1] = ID_BUTTON;
	string = new char[strlen(a_string) + 3];
	strcpy(string, " ");
	strcat(string, a_string);
	strcat(string, " ");
	if (strchr(a_string, '~'))
	{
		true.right--;
		relative.right--;
	}
	mniFlags = a_mniFlags;
	woFlags &= ~WOF_BORDER;
	depth = 0;

	/* Set the user function */
	userFunction = a_userFunction;
	if (a_userFunction)
		return;
	if (FlagSet(a_mniFlags, MNIF_RESTORE))
		userFunction = Restore;
	else if (FlagSet(a_mniFlags, MNIF_MAXIMIZE))
		userFunction = Maximize;
	else if (FlagSet(a_mniFlags, MNIF_MINIMIZE))
		userFunction = Minimize;
	else if (FlagSet(a_mniFlags, MNIF_MOVE))
		userFunction = Move;
	else if (FlagSet(a_mniFlags, MNIF_SIZE))
		userFunction = Size;
	else if (FlagSet(a_mniFlags, MNIF_CLOSE))
		userFunction = Close;
}

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(int left, int top, int width, char *a_string,
	USHORT a_mniFlags, USHORT a_btFlags, USHORT a_woFlags,
	void (*a_userFunction)(void *object, UI_EVENT &event)) :
	UIW_BUTTON(left, top, width, 0, a_btFlags, a_woFlags, a_userFunction)
{
	/* Initialize the menu item information */
	windowID[0] = ID_MENU_ITEM;
	windowID[1] = ID_BUTTON;
	string = new char[strlen(a_string) + 3];
	strcpy(string, " ");
	strcat(string, a_string);
	strcat(string, " ");
	if (strchr(a_string, '~'))
	{
		true.right--;
		relative.right--;
	}
	mniFlags = a_mniFlags;
	woFlags &= ~WOF_BORDER;
	depth = 0;

	/* Set the user function */
	userFunction = a_userFunction;
	if (a_userFunction)
		return;
	if (FlagSet(a_mniFlags, MNIF_RESTORE))
		userFunction = Restore;
	else if (FlagSet(a_mniFlags, MNIF_MAXIMIZE))
		userFunction = Maximize;
	else if (FlagSet(a_mniFlags, MNIF_MINIMIZE))
		userFunction = Minimize;
	else if (FlagSet(a_mniFlags, MNIF_MOVE))
		userFunction = Move;
	else if (FlagSet(a_mniFlags, MNIF_SIZE))
		userFunction = Size;
	else if (FlagSet(a_mniFlags, MNIF_CLOSE))
		userFunction = Close;
}

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(void) :
	UIW_BUTTON(0, 0, 1, "", BTF_NO_FLAGS, WOF_NON_SELECTABLE, 0)
{
	/* This is the constructor for a menu item seperator */
	windowID[0] = ID_MENU_ITEM;
	windowID[1] = ID_BUTTON;
	mniFlags = MNIF_SEPARATOR;
	woFlags &= ~WOF_BORDER;
	woAdvancedFlags |= WOAF_NON_CURRENT;
	depth = 0;
}

UIW_POP_UP_ITEM::Event(const UI_EVENT &event)
{
	/* Switch on the event type */
	int ccode = event.type;
	switch (ccode)
	{
	case S_CURRENT:
	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		if (FlagSet(mniFlags, MNIF_SEPARATOR) && 
			UI_WINDOW_OBJECT::NeedsUpdate(event, ccode))
		{
			lastPalette = 0;
			ccode = UIW_BUTTON::Event(event);
			int line = (true.top + true.bottom) / 2;
			display->Line(screenID, true.left, line, true.right, line, 
				MapPalette(paletteMapTable, ccode, ID_OUTLINE));
			break;
		}	
		// Continue to default.

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	/* Return the event control code */
	return (ccode);
}

UIW_POP_UP_MENU::UIW_POP_UP_MENU(int left, int top, USHORT a_mnFlags,
	USHORT a_woFlags, USHORT a_woAdvancedFlags) :
	UIW_WINDOW(left, top, 0, 0, a_woFlags,
		a_woAdvancedFlags | WOAF_NORMAL_HOT_KEYS)
{
	/* Initialize the menu information */
	windowID[0] = ID_MENU;
	windowID[1] = ID_WINDOW;
	mnFlags = a_mnFlags;
	if (FlagSet(a_mnFlags, MNF_AUTO_SORT))
		windowList.compareFunction = UIW_POP_UP_MENU::CompareFunction;
}

int UIW_POP_UP_MENU::CompareFunction(void *element1, void *element2)
{
	return (strcmp(((UIW_POP_UP_ITEM *)element1)->DataGet(), ((UIW_POP_UP_ITEM *)element2)->DataGet()));
}

UIW_POP_UP_MENU::Event(const UI_EVENT &event)
{
	/* Switch on the event type */
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_MENU);
	int height, width;
	int t_width = 0;
	int t_height = 0;
	int seperatorCount = 0;
	UIW_POP_UP_ITEM *item;
	UIW_POP_UP_ITEM *tItem;
	UI_WINDOW_OBJECT *topWindow = parent;
	while (topWindow->parent)
		topWindow = topWindow->parent;
	switch (ccode)
	{
	case S_CREATE:
		/* Compute the desired height and width */
		char *tHotKey;
		for (item = First(); item; item = item->Next())
		{
			item->woFlags |= WOF_NON_FIELD_REGION;
			item->woAdvancedFlags |= WOAF_HOT_REGION;
			item->InformationSet(screenID, display, eventManager, windowManager, paletteMapTable, this);
			tHotKey = strchr(item->DataGet(), '~');
			if (tHotKey)
				item->hotKey = toupper(tHotKey[1]);
			width = (display->isText) ? item->relative.right - 1 :
				item->relative.right + 1;
			if (width > t_width)
				t_width = width;
			++t_height;
			if (FlagSet(item->mniFlags, MNIF_SEPARATOR))
				seperatorCount++;
		}
		if (display->isText)
		{
			if (FlagSet(woStatus, WOS_GRAPHICS))
				display->RegionConvert(relative);
			woStatus &= ~WOS_GRAPHICS;
			if (FlagSet(woAdvancedFlags, WOAF_TEMPORARY))
				woFlags |= WOF_BORDER;
			else
				woFlags &= ~WOF_BORDER;
			relative.right = relative.left + t_width + 1;
			relative.bottom = relative.top + t_height - 1;
			if (FlagSet(woFlags, WOF_BORDER))
			{
				relative.bottom += 2;
				relative.right += 2;
			}
		}
		else
		{
			height = display->cellHeight;
			width = display->cellWidth;
			if (!FlagSet(woStatus, WOS_GRAPHICS))
				display->RegionConvert(relative);
			woStatus |= WOS_GRAPHICS;
			woFlags |= WOF_BORDER;
			relative.right = relative.left + t_width * width - 2;
			relative.bottom = relative.top + t_height * height - seperatorCount * (height / 2) - 2;
			if (!parent || FlagSet(woAdvancedFlags, WOAF_TEMPORARY))
				relative.bottom += 2;
		}
		/* Continue to S_SIZE */

	case S_SIZE:
		UI_WINDOW_OBJECT::RegionMax(TRUE);
		height = display->cellHeight;
		for (item = First(); item; item = item->Next())
		{
			item->RegionMax(TRUE);
			if (FlagSet(woAdvancedStatus, WOAS_TOO_SMALL))
				item->woAdvancedStatus |= WOAS_TOO_SMALL;
			else
				item->woAdvancedStatus &= ~WOAS_TOO_SMALL;
			if (display->isText)
			{
				if (FlagSet(woAdvancedFlags, WOAF_TEMPORARY))
					item->woFlags &= ~WOF_BORDER;
				else
					item->woFlags |= WOF_BORDER;
				item->true.bottom = item->true.top;
			}
			else
			{
				item->woFlags &= ~WOF_BORDER;
				item->true.bottom = (!FlagSet(item->mniFlags, MNIF_SEPARATOR)) ?
					item->true.top + height - 1 : item->true.top + height / 2;
				if (item->true.bottom >= true.bottom)
					item->true.bottom = true.bottom - 1;
				else if (FlagSet(item->mniFlags, MNIF_SEPARATOR) && !display->isText)
					item->true.bottom--;
			}
			if (item->mniFlags != 0 && item->mniFlags != MNIF_SEPARATOR)
			{
				item->woFlags &= ~WOF_NON_SELECTABLE;
				if ((FlagSet(item->mniFlags, MNIF_RESTORE) && 
					 !FlagSet(topWindow->woAdvancedStatus, WOAS_MINIMIZED | WOAS_MAXIMIZED)) ||
					(FlagSet(item->mniFlags, MNIF_MINIMIZE | MNIF_MAXIMIZE) && 
					 FlagSet(topWindow->woAdvancedStatus, WOAS_MINIMIZED | WOAS_MAXIMIZED)) ||
					(FlagSet(item->mniFlags, MNIF_MOVE) && FlagSet(topWindow->woAdvancedFlags, WOAF_NO_MOVE)) ||
					(FlagSet(item->mniFlags, MNIF_SIZE) && FlagSet(topWindow->woAdvancedFlags, WOAF_NO_SIZE)))
					item->woFlags |= WOF_NON_SELECTABLE;
			}
		}
 		UIW_WINDOW::RegionsCompute();
		break;

	case S_DELETE:
		ccode = UIW_WINDOW::Event(event);
		break;

	case L_ITEM_LEFT:
	case L_ITEM_RIGHT:
		if ((ccode == L_ITEM_LEFT && FlagSet(mnFlags, MNF_SELECT_LEFT)) ||
			(ccode == L_ITEM_RIGHT && FlagSet(mnFlags, MNF_SELECT_RIGHT)))
		{
			UI_EVENT tEvent;
			tEvent.type = L_SELECT;
			eventManager->Put(tEvent, Q_BEGIN);
			eventManager->Put(event, Q_BEGIN);
			tEvent.type = S_DELETE_LEVEL;
			eventManager->Put(tEvent, Q_BEGIN);
		}
		break;

	default:
		ccode = UIW_WINDOW::Event(event);

		/* Unhighlight the remaining items */
		item = (UIW_POP_UP_ITEM *)windowList.current;
		if (!FlagSet(mnFlags, MNF_SELECT_ONE) || !FlagsSet(item->woStatus, WOS_SELECTED))
			break;
		UI_EVENT tEvent;
		tEvent.type = S_DISPLAY_ACTIVE;
		for (tItem = First(); tItem; tItem = tItem->Next())
			if (tItem != item && FlagSet(tItem->woStatus, WOS_SELECTED))
			{
				tItem->woStatus &= ~WOS_SELECTED;
				tEvent.region = tItem->true;
				tItem->Event(tEvent);
			}
		break;
	}

	/* Return the event control code */
	return (ccode);
}

