//	Program name..	Zinc Interface Library
//	Filename......	PROMPT.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <string.h>
#include "ui_win.hpp"

// Constructor & Destructor -------------------------------------------------

UIW_PROMPT::UIW_PROMPT(int left, int top, const char *a_prompt,
	USHORT a_woFlags) :
	UI_WINDOW_OBJECT(left, top, strlen(a_prompt), 1,
		a_woFlags | WOF_NON_SELECTABLE, WOAF_NO_FLAGS)
{
	// Initialize the prompt information.
	windowID[0] = ID_PROMPT;
	prompt = ui_strdup(a_prompt);
	if (strchr(prompt, '~'))
	{
		true.right--;
		relative.right--;
	}
}

// Member functions ---------------------------------------------------------

int UIW_PROMPT::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = event.type;
	switch (ccode)
	{
	case S_CREATE:
		ccode = UI_WINDOW_OBJECT::Event(event);
		char *tHotKey = strchr(prompt, '~');
		if (tHotKey && next)
		{
			UI_WINDOW_OBJECT *object = Next();
			object->hotKey = toupper(tHotKey[1]);
		}
		break;

	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		if (UI_WINDOW_OBJECT::NeedsUpdate(event, ccode))
			UI_WINDOW_OBJECT::Text(prompt, 0, ccode, lastPalette);
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
