//	Program name..	Zinc Interface Library
//	Filename......	SCROLL.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
const int TOTAL_BUTTONS		= 5;
const int TOP_BUTTON		= 0;
const int CENTER_BUTTON		= 1;
const int BOTTOM_BUTTON		= 2;
const int TOP_REGION		= 3;
const int BOTTOM_REGION		= 4;

static int _slideSize[2] = { 1, 16 };

void UIW_SCROLL_BAR::ScrollBarUserFunction(void *data, UI_EVENT &event)
{
	// Compute the scroll values.
	UIW_BUTTON *button = (UIW_BUTTON *)data;
	UIW_SCROLL_BAR *scrollBar = (UIW_SCROLL_BAR *)button->parent;
	int current = scrollBar->current;
	int size = (scrollBar->display->isText) ? _slideSize[0] : _slideSize[1];
	if (button == scrollBar->button[TOP_BUTTON])
		current--;
	else if (button == scrollBar->button[BOTTOM_BUTTON])
		current++;
	else if (button == scrollBar->button[CENTER_BUTTON])
		current = (int)((long)(scrollBar->button[CENTER_BUTTON]->relative.top - scrollBar->button[TOP_BUTTON]->true.bottom) *
			(long)scrollBar->maximum /
			(long)(scrollBar->button[BOTTOM_BUTTON]->true.top - scrollBar->button[TOP_BUTTON]->true.bottom - size));
	else if (scrollBar->next)
	{
		UI_WINDOW_OBJECT *object = scrollBar->Next();
		event.type = E_KEY;
		event.rawCode = (button == scrollBar->button[TOP_REGION]) ?
			WHITE_PGUP : WHITE_PGDN;

		if (object && !FlagSet(object->woStatus, WOS_CURRENT))
		{
			event.type = S_DISPLAY_ACTIVE;
			object->parent->Event(event);
			event.type = L_BEGIN_SELECT;
			event.position.column = object->true.left;
			event.position.line = object->true.top;
//			object->parent->Event(event);
			object->eventManager->Put(event, Q_BEGIN);
		}
		object->Event(event);
		return;
	}

	if (current < 0)
		current = 0;
	else if (current > scrollBar->maximum)
		current = scrollBar->maximum;

	UI_WINDOW_OBJECT *object = scrollBar->Next();

	// Send a scroll message if appropriate.
	if (current != scrollBar->current && object)
	{
		event.type = S_SCROLL_VERTICAL;
		event.scroll.delta = scrollBar->current - current;

		// Make the appropriate object current.
		if (object && !FlagSet(object->woStatus, WOS_CURRENT))
		{
			event.type = S_DISPLAY_ACTIVE;
			object->parent->Event(event);
			event.type = L_BEGIN_SELECT;
			event.position.column = object->true.left;
			event.position.line = object->true.top;
	//		object->parent->Event(event);
  			object->eventManager->Put(event, Q_BEGIN);
		}
		object->Event(event);
	}
}

UIW_SCROLL_BAR::UIW_SCROLL_BAR(int left, int top, int width, int height,
	USHORT a_sbFlags, USHORT a_woFlags) :
	UIW_WINDOW(left, top, width, height, a_woFlags, WOAF_NON_CURRENT,
		NO_HELP_CONTEXT)
{
	char *string[5] = { "\036", "\007", "\037", "", "" };

	// Initialize the slide information.
	windowID[0] = ID_SCROLL_BAR;
	windowID[1] = ID_WINDOW;
	sbFlags = a_sbFlags;
	current = 0;
	showing = maximum = -1;
	if (FlagSet(woFlags, WOF_NON_FIELD_REGION))
		woFlags |= WOF_BORDER;
	else
		woFlags &= ~WOF_BORDER;
	for (int i = 0; i < TOTAL_BUTTONS; i++)
	{
		button[i] = new UIW_BUTTON(0, 0, 0, string[i], BTF_NO_TOGGLE,
			WOF_JUSTIFY_CENTER | WOF_NON_FIELD_REGION,
			UIW_SCROLL_BAR::ScrollBarUserFunction);
		if (i == TOP_BUTTON || i == BOTTOM_BUTTON)
			button[i]->btFlags |= BTF_REPEAT;
		if (i < TOP_REGION)
			button[i]->depth = (button[i]->depth + 1) / 2;
		else
		{
			button[i]->depth = 0;
			button[i]->WindowID(0, ID_SCROLL_BAR);
		}
		button[i]->woAdvancedFlags |= WOAF_NON_CURRENT;
		windowList.Add(0, button[i]);
	}
}

UIW_SCROLL_BAR::Event(const UI_EVENT &event)
{
	static int deltaLine;

	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_SCROLL_BAR);
	int size = (display->isText) ? _slideSize[0] : _slideSize[1];
	switch (ccode)
	{
	case S_CREATE:
	case S_SIZE:
		// Compute the scroll bar position.
		if ((display->isText && FlagSet(woStatus, WOS_GRAPHICS)) ||
			(!display->isText && !FlagSet(woStatus, WOS_GRAPHICS)))
			display->RegionConvert(relative);
		if (display->isText)
			woStatus &= ~WOS_GRAPHICS;
		else
			woStatus |= WOS_GRAPHICS;
		if (!FlagSet(sbFlags, SBF_VERTICAL))
			true.bottom = relative.bottom = relative.top + size - 1;
		if (!FlagSet(sbFlags, SBF_HORIZONTAL))
			true.right = relative.right = relative.left + size - 1;
		UI_WINDOW_OBJECT::RegionMax(FlagSet(sbFlags, SBF_VERTICAL) ? TRUE : FALSE);
		if (FlagSet(woFlags, WOF_NON_FIELD_REGION))
		{
			if (!display->isText)
				true.right += 1;
			if (!display->isText)
				true.bottom += 1;
			if (!FlagSet(sbFlags, SBF_HORIZONTAL) && true.left <= true.right - size + 1)
				true.left = true.right - size + 1;
			else if (!display->isText)
				true.left -= 1;
			if (!FlagSet(sbFlags, SBF_VERTICAL) && true.top <= true.bottom - size + 1)
				true.top = true.bottom - size + 1;
			else if (!display->isText)
				true.top -= 1;
		}

		// Check the scroll bar size.
		if (FlagSet(woAdvancedStatus, WOAS_INVALID_REGION | WOAS_TOO_SMALL))
		{
			woAdvancedStatus |= WOAS_INVALID_REGION;
			break;
		}
		else if (FlagSet(sbFlags, SBF_VERTICAL) && true.bottom - 2 * size < true.top)
			size = (true.bottom - true.top) / 2 + 1;
		else if (FlagSet(sbFlags, SBF_HORIZONTAL) && true.right - 2 * size < true.left)
			size = (true.right - true.left) / 2 + 1;

		// Compute the button positions.
		for (int i = 0; i < TOTAL_BUTTONS; i++)
		{
			((UI_WINDOW_OBJECT *)button[i])->InformationSet(screenID,
				display, eventManager, windowManager, paletteMapTable, this);
			button[i]->true = true;
			button[i]->woAdvancedStatus &= ~WOAS_INVALID_REGION;
			if (display->isText)
				button[i]->woStatus &= ~WOS_GRAPHICS;
			else
				button[i]->woStatus |= WOS_GRAPHICS;
		}
		if (FlagSet(sbFlags, SBF_VERTICAL))
		{
			button[TOP_BUTTON]->true.bottom = true.top + size - 1;
			button[BOTTOM_BUTTON]->true.top = true.bottom - size + 1;
		}
		else
		{
			button[TOP_BUTTON]->true.right = true.left + size - 1;
			button[BOTTOM_BUTTON]->true.left = true.right - size + 1;
		}
		button[CENTER_BUTTON]->woAdvancedStatus |= WOAS_INVALID_REGION;
		break;

	case S_SCROLL_VERTICAL_SET:
		if (current == event.scroll.current &&
			showing == event.scroll.showing &&
			maximum == event.scroll.maximum &&
			!FlagSet(button[CENTER_BUTTON]->woAdvancedStatus, WOAS_INVALID_REGION))
			break;
		current = (event.scroll.current > 0) ? event.scroll.current : 0;
		showing = (event.scroll.showing > 0) ? event.scroll.showing : 0;
		maximum = (event.scroll.maximum > 0) ? event.scroll.maximum : 0;
		// Continue to S_SCROLL_VERTICAL.

	case S_SCROLL_VERTICAL:
		if (ccode == S_SCROLL_VERTICAL && !FlagSet(sbFlags, SBF_VERTICAL))
			break;

		size = (display->isText) ? _slideSize[0] : _slideSize[1];
		if (ccode == S_SCROLL_VERTICAL)
			current -= event.scroll.delta;
		if (current < 0)
			current = 0;
		else if (current > maximum)
			current = maximum;
		button[CENTER_BUTTON]->woAdvancedStatus &= ~WOAS_INVALID_REGION;
		if (button[BOTTOM_BUTTON]->true.top - button[TOP_BUTTON]->true.bottom < size)
			button[CENTER_BUTTON]->woAdvancedStatus |= WOAS_INVALID_REGION;
		else if (display->isText)
		{
			button[CENTER_BUTTON]->true.top = button[TOP_BUTTON]->true.bottom + 1;
			if (maximum)
				button[CENTER_BUTTON]->true.top += (int)((long)(button[BOTTOM_BUTTON]->true.top - button[TOP_BUTTON]->true.bottom - size - 1) *
					(long)current / (long)maximum);
		}
		else
		{
			button[CENTER_BUTTON]->true.top = button[TOP_BUTTON]->true.bottom;
			if (maximum)
				button[CENTER_BUTTON]->true.top += (int)((long)(button[BOTTOM_BUTTON]->true.top - button[TOP_BUTTON]->true.bottom - size + 1) *
					(long)current / (long)maximum);
		}
		button[CENTER_BUTTON]->true.bottom = button[CENTER_BUTTON]->true.top + size - 1;

		// Compute the scroll regions.
		button[TOP_REGION]->true = true;
		button[TOP_REGION]->true.top = button[TOP_BUTTON]->true.bottom + 1;
		button[TOP_REGION]->true.bottom = button[CENTER_BUTTON]->true.top - 1;
		if (button[TOP_REGION]->true.top > button[TOP_REGION]->true.bottom)
			button[TOP_REGION]->woAdvancedStatus |= WOAS_INVALID_REGION;
		else
			button[TOP_REGION]->woAdvancedStatus &= ~WOAS_INVALID_REGION;

		button[BOTTOM_REGION]->true = true;
		button[BOTTOM_REGION]->true.top = button[CENTER_BUTTON]->true.bottom + 1;
		button[BOTTOM_REGION]->true.bottom = button[BOTTOM_BUTTON]->true.top - 1;
		if (button[BOTTOM_REGION]->true.top > button[BOTTOM_REGION]->true.bottom)
			button[BOTTOM_REGION]->woAdvancedStatus |= WOAS_INVALID_REGION;
		else
			button[BOTTOM_REGION]->woAdvancedStatus &= ~WOAS_INVALID_REGION;

		// Redisplay the scroll bar.
		if (ccode == S_SCROLL_VERTICAL)
		{
			UI_EVENT tEvent;
			tEvent.type = S_DISPLAY_ACTIVE;
			tEvent.region.left = button[CENTER_BUTTON]->true.left - 1;
			tEvent.region.top = button[CENTER_BUTTON]->true.top - 1;
			tEvent.region.right = button[CENTER_BUTTON]->true.right + 1;
			tEvent.region.bottom = button[CENTER_BUTTON]->true.bottom + 1;
			UIW_WINDOW::Event(tEvent);
		}
		break;

	case L_BEGIN_SELECT:
	case L_CONTINUE_SELECT:
	case L_END_SELECT:
		if (FlagSet(sbFlags, SBF_CORNER) || FlagSet(woAdvancedStatus, WOAS_TOO_SMALL))
			break;
		else if (ccode == L_BEGIN_SELECT && button[CENTER_BUTTON]->Overlap(event.position) &&
			!FlagSet(button[CENTER_BUTTON]->woStatus, WOS_CURRENT) &&
			!FlagSet(button[CENTER_BUTTON]->woAdvancedStatus, WOAS_INVALID_REGION)) 
		{
			button[CENTER_BUTTON]->woStatus |= WOS_CURRENT;
			button[CENTER_BUTTON]->relative = button[CENTER_BUTTON]->true;
			if (!display->isText)
				display->RectangleXOR(button[CENTER_BUTTON]->relative);
			deltaLine = event.position.line - button[CENTER_BUTTON]->true.top;
		}
		else if (ccode == L_CONTINUE_SELECT && FlagSet(button[CENTER_BUTTON]->woStatus, WOS_CURRENT))
		{
			int deltaY = 0;
			if (FlagSet(sbFlags, SBF_VERTICAL))
			{
				deltaY = event.position.line - button[CENTER_BUTTON]->true.top - deltaLine;
				if (button[CENTER_BUTTON]->true.top + deltaY < button[TOP_BUTTON]->true.bottom)
					deltaY = button[TOP_BUTTON]->true.bottom - button[CENTER_BUTTON]->true.top;
				else if (button[CENTER_BUTTON]->true.bottom + deltaY > button[BOTTOM_BUTTON]->true.top)
					deltaY = button[BOTTOM_BUTTON]->true.top - button[CENTER_BUTTON]->true.bottom;
			}
			UI_REGION region = button[CENTER_BUTTON]->true;
			region.top += deltaY;
			region.bottom += deltaY;
			if (!display->isText)
			{
				display->RectangleXOR(button[CENTER_BUTTON]->relative);
				display->RectangleXOR(region);
			}
			button[CENTER_BUTTON]->relative = region;
		}
		else if (ccode == L_END_SELECT && FlagSet(button[CENTER_BUTTON]->woStatus, WOS_CURRENT))
		{
			if (!display->isText)
				display->RectangleXOR(button[CENTER_BUTTON]->relative);
			UI_EVENT tEvent = event;
			UIW_SCROLL_BAR::ScrollBarUserFunction(button[CENTER_BUTTON], tEvent);
			button[CENTER_BUTTON]->woStatus &= ~WOS_CURRENT;
		}
		else
			UIW_WINDOW::Event(event);
		break;

	case S_CURRENT:
	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		if (display->isText)
			lastPalette = 0;
		// Continue to default.

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the event control code.
	return (ccode);
}

