//	Program name..	Zinc Interface Library
//	Filename......	SYS.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"

UIW_SYSTEM_BUTTON::UIW_SYSTEM_BUTTON(void) :
	UIW_BUTTON(0, 0, 0, 0, BTF_NO_TOGGLE,
		WOF_JUSTIFY_CENTER | WOF_NON_FIELD_REGION,
		UIW_SYSTEM_BUTTON::SystemUserFunction),
	menu(0, 0, MNF_SELECT_ONE, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the system button information.
	windowID[0] = ID_SYSTEM_BUTTON;
	windowID[1] = ID_BUTTON;
	hotKey = HOT_KEY_SYSTEM;
	woAdvancedFlags |= WOAF_NON_CURRENT;
}

// ----- Member functions ---------------------------------------------------

UIW_SYSTEM_BUTTON *UIW_SYSTEM_BUTTON::GENERIC(void)
{
	UIW_SYSTEM_BUTTON *systemButton = new UIW_SYSTEM_BUTTON;

	// Add default system button options.
	*systemButton
		+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0)
		+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0)
		+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0)
		+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0)
		+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0)
		+ new UIW_POP_UP_ITEM
		+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE,
			WOF_NO_FLAGS, 0);

	// Return a pointer to the new system button.
	return (systemButton);
}

int UIW_SYSTEM_BUTTON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = event.type;
	switch (ccode)
	{
	case S_CREATE:
		menu.InformationSet(-screenID, display, eventManager, windowManager,
			paletteMapTable, this);
		if (string)
			delete string;
		string = ui_strdup("\007");
		// Continue to S_SIZE.

	case S_SIZE:
		if (display->isText)
		{
			true.top = true.bottom = parent->true.top;
			true.left = parent->true.left + 1;
			true.right = true.left + 2;
		}
		else
		{
			int height, width;
			UIW_BUTTON::Information(GET_DEFAULT_HEIGHT, &height);
			UIW_BUTTON::Information(GET_DEFAULT_WIDTH, &width);
			UI_WINDOW_OBJECT::RegionMax(TRUE);
			true.left -= 1;
			true.top -= 1;
			true.right = true.left + width + 1;
			true.bottom = true.top + height - 1;
		}
		break;

	case S_DISPLAY_ACTIVE:
		if (ccode == S_DISPLAY_INACTIVE && display->isText)
			break;
		else if (display->isText)
			lastPalette = 0;
		// Continue to default.

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

void UIW_SYSTEM_BUTTON::SystemUserFunction(void *button, UI_EVENT &event)
{
	// Call the member user function.
	((UIW_SYSTEM_BUTTON *)button)->UserFunction(event);
}

void UIW_SYSTEM_BUTTON::UserFunction(UI_EVENT &event)
{
	// Make sure there are elements in the menu.
	woStatus &= ~WOS_SELECTED;
	if (!menu.First())
	{
		event.type = S_DELETE;
		eventManager->Put(event, Q_BEGIN);
		return;
	}

	// Attach the menu to the screen display.
	menu.true.left = true.left;
	menu.true.top = true.bottom + 1;
	menu.true.right = menu.true.bottom = 0x0FFF;
	if (display->isText)
		menu.woStatus &= ~WOS_GRAPHICS;
	else
		menu.woStatus |= WOS_GRAPHICS;
	*windowManager + &menu;
}
