//	Program name..	Zinc Interface Library
//	Filename......	TIMEEXP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ui_gen.hpp"

// ----- Member functions ---------------------------------------------------

void UI_TIME::Export(void)
{
	struct time info;
	info.ti_hour = tHour,
		info.ti_min = tMinute,
		info.ti_sec = tSecond,
		info.ti_hund = tHundredth;
	settime(&info);
}

void UI_TIME::Export(int *packedTime)
{
	*packedTime = (tHour << 11) | (tMinute << 5) | tSecond / 2;
}

void UI_TIME::Export(int *hour, int *minute, int *second, int *hundredth)
{
	if (hour) *hour = tHour;
	if (minute) *minute = tMinute;
	if (second) *second = tSecond;
	if (hundredth) *hundredth = tHundredth;
}

void UI_TIME::Export(char *string, USHORT tmFlags)
{
	// Get the initial separators.
	GetCountryInfo();
	char timeFormat = _countryInfo.co_time;
	if (FlagSet(tmFlags, TMF_TWELVE_HOUR))
		timeFormat = 0;
	else if (FlagSet(tmFlags, TMF_TWENTY_FOUR_HOUR))
		timeFormat = 1;
	char *separator = _countryInfo.co_tmsep;
	USHORT zeroFill = FlagSet(tmFlags, TMF_ZERO_FILL);
	if (FlagSet(tmFlags, TMF_COLON_SEPARATOR))
		separator = ":";
	else if (FlagSet(tmFlags, TMF_NO_SEPARATOR))
	{
		separator = "";
		zeroFill = TRUE;
	}
	char *ptr = string;
	int values[4] = { tHour, tMinute, tSecond, tHundredth };
	int pmFlag = 0;
	if (timeFormat == 0)
	{
		values[0] = tHour % 12;
		if (values[0] == 0)
			values[0] = 12;
		if (tHour >= 12)
			pmFlag = 1;
	}
	int firstValue = 0;
	if (FlagSet(tmFlags, TMF_NO_MINUTES))
		firstValue = 2;
	else if (FlagSet(tmFlags, TMF_NO_HOURS))
		firstValue = 1;
	int lastValue = 1;
	if (FlagSet(tmFlags, TMF_HUNDREDTHS))
		lastValue = 3;
	else if (FlagSet(tmFlags, TMF_SECONDS))
		lastValue = 2;
	for (int i = firstValue; i <= lastValue; i++)
	{
		if (ptr != string)
		{
			if (i == 3)
				*ptr++ = '.';
			else
			{
				strcpy(ptr, separator);
				ptr += strlen(separator);
			}
		}
		ptr += sprintf(ptr, (ptr != string || zeroFill) ? "%02d" : "%d", values[i]);
	}
	if (timeFormat == 0 && firstValue == 0)
	{
		sprintf(ptr, " %s", pmFlag ? pmPtr : amPtr);
		if (FlagSet(tmFlags, TMF_UPPER_CASE))
			strupr(ptr);
		else if (FlagSet(tmFlags, TMF_LOWER_CASE))
			strlwr(ptr);
	}
}
