//	Program name..	Zinc Interface Library
//	Filename......	TIMEIMP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_gen.hpp"

// ----- Member functions ---------------------------------------------------

TMI_RESULT UI_TIME::Import(void)
{
	struct time info;
	gettime(&info);
	return(Import(info.ti_hour, info.ti_min, info.ti_sec, info.ti_hund));
}

TMI_RESULT UI_TIME::Import(int time)
{
	return(Import((time & 0xF800) >> 11, (time & 0x07E0) >> 5, 2 * (time & 0x001F)));
}

TMI_RESULT UI_TIME::Import(int hour, int minute, int second, int hundredth)
{
	if (hour < 0 || hour > 23 || minute < 0 || minute > 59 ||
		second < 0 || second > 59 || hundredth < 0 || hundredth > 99)
		return (TMI_INVALID);
	tHour = hour;
	tMinute = minute;
	tSecond = second;
	tHundredth = hundredth;
	return (TMI_OK);
}

TMI_RESULT UI_TIME::Import(const char *string, USHORT tmFlags)
{
	int values[4] = { 0, 0, 0, 0 };
	int hour = 0;
	int minute = 0;
	int second = 0;
	int hundredth = 0;
	int numValues = 0;
	int maxValues = 2;
	int AmPm = 0;
	int isBlank = TRUE;

	if (FlagSet(tmFlags, TMF_HUNDREDTHS))
		maxValues += 2;
	else if (FlagSet(tmFlags, TMF_SECONDS))
		maxValues++;
	if (FlagSet(tmFlags, TMF_NO_MINUTES))
		maxValues -= 2;
	else if (FlagSet(tmFlags, TMF_NO_HOURS))
		maxValues--;
	GetCountryInfo();
	while (*string)
	{
		if (isalpha(*string))
		{
			int which = LookupAmPm(string);
			if (which < 0 || AmPm)
				return (TMI_INVALID);
			AmPm = which;
			while (*string && !isdigit(*string))
				string++;
			isBlank = FALSE;
		}
		else if (isdigit(*string))
		{
			char digits[3];
			int  numDigits = 0;
			while (numDigits < 2 && isdigit(*string))
				digits[numDigits++] = *string++;
			digits[numDigits] = '\0';
			int value = atoi(digits);
			if (numValues >= maxValues) return TMI_INVALID;
			values[numValues++] = value;
			isBlank = FALSE;
		}
		else
			string++;			// Ignore spaces and punctuation.
	}
	if (FlagSet(tmFlags, TMF_NO_MINUTES))
	{
		second = values[0];
		hundredth = values[1];
	}
	else if (FlagSet(tmFlags, TMF_NO_HOURS))
	{
		minute = values[0];
		second = values[1];
		hundredth = values[2];
	}
	else
	{
		hour = values[0];
		minute = values[1];
		second = values[2];
		hundredth = values[3];
	}
	if (AmPm == 2)
	{
		if (hour >= 1 && hour <= 11)
			hour = hour + 12;
	}
	else if (AmPm == 1)
	{
		if (hour == 12)
			hour = 0;
	}
	if (isBlank)
	{
		if (FlagSet(tmFlags, TMF_SYSTEM))
		{
			Import();			// Import from system time.
			return (TMI_OK);
		}
		else
		{
			Import(0, 0, 0, 0);
			return (TMI_INVALID);
		}
	}
	return (Import(hour, minute, second, hundredth));
}

static void NormalizeAmPmString(const char *src, char *dest)
{
	while (*src)
	{
		if (isalpha(*src))
			*dest++ = toupper(*src);
		else if (isdigit(*src))
			break;
		src++;
	}
	*dest = '\0';
}

int UI_TIME::LookupAmPm(const char *token)
{
	char normalizedAm[20];
	char normalizedPm[20];
	char normalizedToken[20];

	// Allow single character (if unambiguous).
	if (*(token + 1) == '\0' && toupper(*amPtr) != toupper(*pmPtr))
	{
		if (toupper(*token) == toupper(*amPtr))
			return (1);
		else if (toupper(*token) == toupper(*pmPtr))
			return (2);
		else
			return (-1);
	}
	// Or require full string match (ignoring punctuation).
	NormalizeAmPmString(amPtr, normalizedAm);
	NormalizeAmPmString(pmPtr, normalizedPm);
	NormalizeAmPmString(token, normalizedToken);
	if (strcmp(normalizedToken, normalizedAm) == 0)
		return (1);
	if (strcmp(normalizedToken, normalizedPm) == 0)
		return (2);
	return (-1);
}
