//	Program name..	Zinc Interface Library
//	Filename......	UNDO.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include "ui_win.hpp"

char * UI_EDIT_INFO::pasteBuffer = 0;
short UI_EDIT_INFO::pasteLength = 0;
short UI_EDIT_INFO::numEditObjects = 0;

class UNDO_OBJECT : public UI_UNDO_RECORD
{
public:
	UI_UNDO_LIST undoRecords;
	UI_UNDO_RECORD *current;
	static  long  totalBytes;
	static  short totalUndos;

	UNDO_OBJECT(void);
	void Add(UI_UNDO_RECORD *record, USHORT a_size);
	void Subtract(UI_UNDO_RECORD *record);
};

static short maxObjects = 32767;
static long  maxBytes = 2147483647L;
static short maxUndos = 32767;
static long  maxBytesPerObject = 2147483647L;
static short maxUndosPerObject = 32767;

long  UNDO_OBJECT::totalBytes = 0L;
short UNDO_OBJECT::totalUndos = 0;

UI_UNDO_LIST undoList;

static void (*oldNewHandler)();

void cdecl UndoFreeStoreException(void)
{
	UNDO_OBJECT *tail = (UNDO_OBJECT *) undoList.tail;
	long totalBytesSave = tail->totalBytes;
	if (tail)
	{
		long desiredBytes = tail->totalBytes / 2;
		/* Delete records from Least Recently Used object(s). */
		while (	tail->totalBytes > desiredBytes )
		{
			while (tail && !tail->undoRecords.tail)
				tail = (UNDO_OBJECT *) tail->previous;
			if (!tail)
				break;
			tail->Subtract(tail->undoRecords.tail);
		}
	}
	if (tail->totalBytes < totalBytesSave)
	{
		sound(30);
		delay(700);
		nosound();
		return;
	}
	if (oldNewHandler)
		(*oldNewHandler)();
	else {
		printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nFree store exception!\n");
		abort();
	}
}

UI_EDIT_INFO::UI_EDIT_INFO(void) 
{
	undoHandle = 0;
	numEditObjects++;
}

UI_EDIT_INFO::~UI_EDIT_INFO(void)
{
	if (undoHandle)
		UndoDestroy(undoHandle);
	numEditObjects--;
	if (numEditObjects == 0 && pasteBuffer)
	{
		delete pasteBuffer;
		pasteBuffer = 0;
	}
}

UNDO_OBJECT::UNDO_OBJECT(void)
{
	current = 0;
}

void UNDO_OBJECT::Add(UI_UNDO_RECORD *record, USHORT a_size)
{
	totalBytes += a_size;
	totalUndos++;
	undoRecords.Add(record, a_size);
}

void UNDO_OBJECT::Subtract(UI_UNDO_RECORD *record)
{
	totalBytes -= record->size;
	totalUndos--;
	if (current == record)
		current = (UNDO_OBJECT *) current->next;
	undoRecords.Subtract(record);
}

void UndoAdd(UI_UNDO_HANDLE handle, UI_UNDO_RECORD *undo, USHORT a_size)
{
	if (!handle)
		return;

	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;

	/* Delete any redo records hanging around. */
	while (object->undoRecords.head != object->current)
		object->Subtract(object->undoRecords.head);

	/* Delete records at tail of queue if we need to. */
	while ( object->undoRecords.count >= maxUndosPerObject ||
		object->undoRecords.totalSize + a_size >= maxBytesPerObject )
		object->Subtract(object->undoRecords.tail);

	/* Delete records from Least Recently Used object(s) if we need to. */
	UNDO_OBJECT *tail = (UNDO_OBJECT *) undoList.tail;
	while (	object->totalUndos >= maxUndos ||
		object->totalBytes + a_size >= maxBytes)
	{
		while (tail && !tail->undoRecords.tail)
			tail = (UNDO_OBJECT *) tail->previous;
		if (!tail)
			break;
		object->Subtract(tail->undoRecords.tail);
	}
	object->Add(undo, a_size);
	object->current = object->undoRecords.head;
}

UI_UNDO_HANDLE UndoCreate(void)
{
	extern void (*_new_handler)();

	if (undoList.count < maxObjects)
	{
		if (undoList.count == 0)
		{
			oldNewHandler = _new_handler;
			_new_handler  = UndoFreeStoreException;
		}
		UNDO_OBJECT *object = new UNDO_OBJECT;
		undoList.Add(object, sizeof(UNDO_OBJECT));
		return (UI_UNDO_HANDLE) object;
	}
	else
		return 0;
}

UI_UNDO_RECORD *UndoCurrent(UI_UNDO_HANDLE handle)
{
	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;
	if (object && object->current)
		return object->current;
	else
		return 0;
}

void UndoDestroy(UI_UNDO_HANDLE handle)
{
	if (!handle)
		return;

	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;

	object->totalBytes -= object->undoRecords.totalSize;
	object->totalUndos -= object->undoRecords.count;
	undoList.Subtract(object);
}

UI_UNDO_RECORD *UndoRedoCurrent(UI_UNDO_HANDLE handle)
{
	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;
	if (object && object->current)
		return (UI_UNDO_RECORD *) object->current->previous;
	else
		return object->undoRecords.tail;
}

void UndoRedoPop(UI_UNDO_HANDLE handle)
{
	if (!handle)
		return;

	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;
	if (object->current)
	{
		if (object->current != object->undoRecords.head)
			object->current = (UI_UNDO_RECORD *) object->current->previous;
	}
	else
		object->current = object->undoRecords.tail;
}

void UndoRedoPush(UI_UNDO_HANDLE handle)
{
	if (!handle)
		return;

	UNDO_OBJECT *object = (UNDO_OBJECT *) handle;
	if (object->current)
		object->current = (UI_UNDO_RECORD *) object->current->next;
}

void UI_EDIT_INFO::UndoStrategy(int a_maxObjects, long a_maxBytes,
	int a_maxUndos, long a_maxBytesPerObject, int a_maxUndosPerObject)
{
	if (a_maxObjects != -1)
		maxObjects = a_maxObjects;
	if (a_maxBytes != -1)
		maxBytes = a_maxBytes;
	if (a_maxUndos != -1)
		maxUndos = a_maxUndos;
	if (a_maxBytesPerObject != -1)
		maxBytesPerObject = a_maxBytesPerObject;
	if (a_maxUndosPerObject != -1)
		maxUndosPerObject = a_maxUndosPerObject;
}
