//	Program name..	Zinc Interface Library
//	Filename......	UNDOLIST.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdlib.h>
#include "ui_win.hpp"

UI_UNDO_LIST::~UI_UNDO_LIST(void)
{
	while (head)
		Subtract(head);
}

void UI_UNDO_LIST::Add(UI_UNDO_RECORD *element, USHORT a_size)
{
	/***
	* Add the element to the head of the list.
	* NOTE:  We assume that the previous and next pointers are null, which is
	* guaranteed by the constructor.
	***/
	if (element)
	{
		if (!head)
			head = tail = element;
		else
		{
			element->next = head;
			head->previous = element;
			head = element;
		}
		element->size = a_size;
		totalSize += element->size;
		count++;
	}
}

void UI_UNDO_LIST::MoveFront(UI_UNDO_RECORD *element)
{
	if (element)
	{
		Unlink(element);
		Add(element, element->size);
	}
}

void UI_UNDO_LIST::Subtract(UI_UNDO_RECORD *element)
{
	if (element)
	{
		Unlink(element);
		delete element;
	}
}

void UI_UNDO_LIST::Unlink(UI_UNDO_RECORD *element)
{
	if (element)
	{
		if (!element->previous)			// Deleting first element
			head = (UI_UNDO_RECORD *) element->next;
		else
			element->previous->next = element->next;
		if (!element->next)				// Deleting last element
			tail = (UI_UNDO_RECORD *) element->previous;
		else
			element->next->previous = element->previous;
		element->next = element->previous = 0;
		totalSize -= element->size;
		count--;
	}
}


