//	Program name.. Calendar
//	Filename...... CALENDAR.CPP
//	Version....... 1.0
//
//	COPYRIGHT (C) 1990.  All Rights Reserverd.
//	Zinc Software Incorported.  Pleasant Grove, Utha  USA

#include <string.h>
#include <graphics.h>
#include <ui_win.hpp>

class CALENDAR : public UIW_WINDOW
{
public:
	CALENDAR(int left, int top, int offset);
	virtual ~CALENDAR(void) {}

	virtual int Event(const UI_EVENT &event);

private:
	UI_DATE date;
	UIW_TITLE *title;
	UIW_TEXT *calendarText;
	int year;
	int month;
};

// Calendar ID and logical events.
const int ID_CALENDAR				= 10000;
const int L_PREVIOUS_MONTH			= 10000;
const int L_NEXT_MONTH				= 10001;
const int L_CURRENT_MONTH			= 10002;

// Background palette.
static UI_PALETTE CalendarBackgroundPalette = { '\305', attrib(CYAN, BLACK),
	attrib(MONO_DIM, MONO_BLACK), XHATCH_FILL, attrib(CYAN, CYAN),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_GRAY, GS_GRAY) };
UI_PALETTE *_backgroundPalette = &CalendarBackgroundPalette;


// Pallete map table -
//	{ windowID, logicalValue,
//		{ Text fillChar,
//			Color attrib(colorForeground, colorBackground),
//			Mono attrib(monoForeground, monoBackground),
//			Graphics fillPattern,
//			EGA/VGA attrib(vgaForeground, vgaBackground),
//			B&W attrib(b&wForeground, b&wBackground),
//			GrayScale attrib(grayScaleForeground, grayScaleBackground) } }
static UI_PALETTE_MAP calendarPaletteMapTable[] =
{
	// ID_WINDOW_OBJECT
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, RED), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, WHITE), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_WHITE, GS_BLACK)} },

	// ID_STRING
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK,  RED), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, RED), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE)} },

	// ID_BORDER
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(BLUE, RED), attrib(MONO_HIGH, MONO_BLACK),
		SOLID_FILL, attrib(LIGHTGRAY, BLUE), attrib(BW_WHITE, BW_BLACK),
		attrib(GS_WHITE, GS_GRAY) } },

	// ID_TITLE
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(YELLOW, RED), attrib(MONO_NORMAL, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, LIGHTBLUE), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_BLACK, GS_WHITE) } },

	// End of array
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

// Event map table -
//	{ windowID, logicalValue, event.type, event.rawCode }
static UI_EVENT_MAP myEventMapTable[] =
{
	{ ID_WINDOW_MANAGER,	L_EXIT,				E_KEY, 		SHIFT_F3 },
	{ ID_WINDOW_MANAGER,	L_EXIT,				E_KEY, 		ESCAPE },
	{ ID_WINDOW_MANAGER,	L_EXIT,				E_MOUSE, 	M_LEFT | M_RIGHT },

	{ ID_WINDOW_OBJECT, 	L_SELECT,			E_KEY, 		ENTER },
	{ ID_WINDOW_OBJECT, 	L_SELECT,			E_KEY, 		GRAY_ENTER },
	{ ID_WINDOW_OBJECT, 	L_VIEW,				E_MOUSE, 	0 },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		E_MOUSE, 	M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_SELECT,	E_MOUSE, 	M_LEFT },
	{ ID_WINDOW_OBJECT, 	L_END_SELECT,		E_MOUSE, 	M_LEFT_CHANGE },

	{ ID_CALENDAR,			L_PREVIOUS_MONTH,	E_KEY, 		WHITE_PGUP },
	{ ID_CALENDAR,			L_PREVIOUS_MONTH,	E_KEY, 		GRAY_PGUP },
	{ ID_CALENDAR,			L_NEXT_MONTH,		E_KEY, 		WHITE_PGDN },
	{ ID_CALENDAR,			L_NEXT_MONTH,		E_KEY, 		GRAY_PGDN },

	// End of array.
	{ ID_END, 0, 0, 0 }
};
UI_EVENT_MAP *_eventMapTable = myEventMapTable;

static char dayText[] = " 1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 \
16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31";

CALENDAR::CALENDAR(int centerX, int centerY, int offset) :
	UIW_WINDOW(centerX - 11, centerY - 4, 24, 9,
		WOF_NO_FLAGS, WOAF_NO_SIZE)
{
	// Assign IDs for both a calendar and window.
	windowID[0] = ID_CALENDAR;
	windowID[1] = ID_WINDOW;

	// Get the current year and month.
	date.Export(&year, &month, 0, 0);

	// Create the window with new palette map table
	*this
		+ new UIW_BORDER
		+ (title = new UIW_TITLE("", WOF_JUSTIFY_CENTER))
		+ new UIW_STRING(0, 0, 24, "  S  M  T  W  T  F  S", 23,
			STF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE)
		+ (calendarText = new UIW_TEXT(0 + offset, 1,
			24 - offset, 7 - offset, "", 256, TXF_NO_FLAGS, WOF_VIEW_ONLY |
			WOF_NON_SELECTABLE | (WOF_BORDER * !offset)));
	paletteMapTable = calendarPaletteMapTable;

	// Initialize the current month's calendar.
	UI_EVENT event;
	event.type = L_CURRENT_MONTH;
	Event(event);
}

int CALENDAR::Event(const UI_EVENT &event)
{
	static char text[256];
	static char monthString[20];

	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_CALENDAR);
	switch (ccode)
	{
	case L_NEXT_MONTH:
		month += 2;

		// Continue on to L_PREVIOUS_MONTH
	case L_PREVIOUS_MONTH:
		if (--month > 12)
		{
			month = 1;
			year++;
		}
		if (!month)
		{
			month = 12;
			year--;
		}

		// Continue on to L_CURRENT_MONTH
	case L_CURRENT_MONTH:
		date.Import(year, month, 0);
		date.Export(monthString, 15, DTF_ALPHA_MONTH);
		date.Import(year, month, 1);
		int startingDay = date.DayOfWeek();
		strcpy(text, "                     ");
		strcpy(text + (startingDay - 1) * 3, dayText);
		text[(date.DaysInMonth() + startingDay - 1) * 3] = '\0';

		// Change the window data to reflect new month.
		title->DataSet(monthString);
		calendarText->DataSet(text, 256);

//xx this should not be needed.
		if (windowManager)
			*windowManager + this;
		break;

	default:
		// Call the window event to process other events.
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

main()
{
	// Initialize the display.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and window managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;
	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create the calendar.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	int offset = (display->isText) ? 1 : 0;
	*windowManager + new CALENDAR(centerX, centerY, offset);

	// Process the events.
	int ccode;
	UI_EVENT event;
	do
	{
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}
