//	COMBOBOX.CPP (COMBOBOX) - Combo box example program.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include <ui_win.hpp>

#define COM_PORT1		1
#define COM_PORT2		2
#define STOP_BITS_1		3
#define STOP_BITS_2		4
#define PARITY_NONE		5
#define PARITY_EVEN		6
#define PARITY_ODD		7
#define PARITY_STICKY	8
#define DATA_BITS_7		9
#define DATA_BITS_8    10
#define BAUD_300       11
#define BAUD_1200      12
#define BAUD_2400      13
#define BAUD_9600      14
#define BAUD_19200     15
#define BAUD_38400     16
#define BAUD_115K      17

class EXPORT COMPORT_SETUP : public UIW_WINDOW
{
public:
	COMPORT_SETUP();

	UIW_STRING *currentPort;
	UIW_STRING *currentBaud;
	UIW_STRING *currentParity;
	UIW_STRING *currentDataBits;
	UIW_STRING *currentStopBits;

	UIW_COMBO_BOX *portField;
	UIW_COMBO_BOX *baudField;
	UIW_COMBO_BOX *parityField;
	UIW_COMBO_BOX *dataBitsField;
	UIW_COMBO_BOX *stopBitsField;
	UIW_GROUP *currentSettings;

private:
	UIW_BUTTON *defaultPort;
	UIW_BUTTON *defaultBaud;
	UIW_BUTTON *defaultParity;
	UIW_BUTTON *defaultDataBits;
	UIW_BUTTON *defaultStopBits;

	static EVENT_TYPE ResetDefaults(UI_WINDOW_OBJECT *,     UI_EVENT &,
		EVENT_TYPE);
	static EVENT_TYPE NewSettings(UI_WINDOW_OBJECT *, UI_EVENT &,
		EVENT_TYPE);
};


EVENT_TYPE COMPORT_SETUP::ResetDefaults(UI_WINDOW_OBJECT *object,
	UI_EVENT &event, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	COMPORT_SETUP *parentWindow = (COMPORT_SETUP *)window;

	// Reset current settings.
	parentWindow->currentPort->Information(SET_TEXT, "Com port 1");
	parentWindow->currentStopBits->Information(SET_TEXT, "1 stop bit");
	parentWindow->currentParity->Information(SET_TEXT, "No parity");
	parentWindow->currentDataBits->Information(SET_TEXT, "8 data bits");
	parentWindow->currentBaud->Information(SET_TEXT, "9600 baud");

	// Reset the combo box's default current items.
	UI_EVENT tEvent;
	tEvent = event;
	event.type = S_CREATE;
	tEvent.type = S_REDISPLAY;
	parentWindow->portField->list.SetCurrent(parentWindow->defaultPort);
//	parentWindow->portField->Event(event);
	parentWindow->portField->Event(tEvent);

	parentWindow->baudField->list.SetCurrent(parentWindow->defaultBaud);
//	parentWindow->baudField->Event(event);
	parentWindow->baudField->Event(tEvent);

	parentWindow->parityField->list.SetCurrent(parentWindow->defaultParity);
//	parentWindow->parityField->Event(event);
	parentWindow->parityField->Event(tEvent);

	parentWindow->dataBitsField->list.SetCurrent(parentWindow->defaultDataBits);
//	parentWindow->dataBitsField->Event(event);
	parentWindow->dataBitsField->Event(tEvent);

	parentWindow->stopBitsField->list.SetCurrent(parentWindow->defaultStopBits);
//	parentWindow->stopBitsField->Event(event);
	parentWindow->stopBitsField->Event(tEvent);

	return ccode;
}


EVENT_TYPE COMPORT_SETUP::NewSettings(UI_WINDOW_OBJECT *object,
	UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	COMPORT_SETUP *parentWindow = (COMPORT_SETUP *)window;

	switch (((UIW_BUTTON *)object)->value)
	{
	case COM_PORT1:
		parentWindow->currentPort->Information(SET_TEXT, "Com port 1");
		break;

	case COM_PORT2:
		parentWindow->currentPort->Information(SET_TEXT, "Com port 2");
		break;

	case STOP_BITS_1:
		parentWindow->currentStopBits->Information(SET_TEXT, "1 stop bit");
		break;

	case STOP_BITS_2:
		parentWindow->currentStopBits->Information(SET_TEXT, "2 stop bits");
		break;

	case PARITY_NONE:
		parentWindow->currentParity->Information(SET_TEXT, "No parity");
		break;

	case PARITY_EVEN:
		parentWindow->currentParity->Information(SET_TEXT, "Even parity");
		break;

	case PARITY_ODD:
		parentWindow->currentParity->Information(SET_TEXT, "Odd parity");
		break;

	case PARITY_STICKY:
		parentWindow->currentParity->Information(SET_TEXT, "no parity");
		break;

	case DATA_BITS_7:
		parentWindow->currentDataBits->Information(SET_TEXT, "7 data bits");
		break;

	case DATA_BITS_8:
		parentWindow->currentDataBits->Information(SET_TEXT, "8 data bits");
		break;

	case BAUD_300:
		parentWindow->currentBaud->Information(SET_TEXT, "300 baud");
		break;

	case BAUD_1200:
		parentWindow->currentBaud->Information(SET_TEXT, "1200 baud");
		break;

	case BAUD_2400:
		parentWindow->currentBaud->Information(SET_TEXT, "2400 baud");
		break;

	case BAUD_9600:
		parentWindow->currentBaud->Information(SET_TEXT, "9600 baud");
		break;

	case BAUD_19200:
		parentWindow->currentBaud->Information(SET_TEXT, "19.2 Kbaud");
		break;

	case BAUD_38400:
		parentWindow->currentBaud->Information(SET_TEXT, "38.4 Kbaud");
		break;

	case BAUD_115K:
		parentWindow->currentBaud->Information(SET_TEXT, "115 Kbaud");
		break;
	}
	return ccode;
}

COMPORT_SETUP::COMPORT_SETUP(): UIW_WINDOW(0, 0, 60, 10)
{
	portField = &(*new UIW_COMBO_BOX(15, 1, 20, 5)
		+ (defaultPort = new UIW_BUTTON(0,0,0, "Com port 1", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, COM_PORT1))
		+ new UIW_BUTTON(0,0,0, "Com port 2", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, COM_PORT2));

	baudField = &(*new UIW_COMBO_BOX(15, 2, 20, 5)
		+ new UIW_BUTTON(0,0,0, "300 baud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_300)
		+ new UIW_BUTTON(0,0,0, "1200 baud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_1200)
		+ new UIW_BUTTON(0,0,0, "2400 baud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_2400)
		+ (defaultBaud = new UIW_BUTTON(0,0,0, "9600 baud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_9600))
		+ new UIW_BUTTON(0,0,0, "19.2 Kbaud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_19200)
		+ new UIW_BUTTON(0,0,0, "38.4 Kbaud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_38400)
		+ new UIW_BUTTON(0,0,0, "115 Kbaud", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, BAUD_115K));

	// Set the default baud rate.
	baudField->list.SetCurrent(defaultBaud);

	parityField = &(*new UIW_COMBO_BOX(15, 3, 20, 5)
		+ (defaultParity = new UIW_BUTTON(0,0,0, "No parity", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, PARITY_NONE))
		+ new UIW_BUTTON(0,0,0, "Even parity", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, PARITY_EVEN)
		+ new UIW_BUTTON(0,0,0, "Odd parity", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, PARITY_ODD)
		+ new UIW_BUTTON(0,0,0, "Sticky parity", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, PARITY_STICKY));

	dataBitsField = &(*new UIW_COMBO_BOX(15, 4, 20, 5)
		+ new UIW_BUTTON(0,0,0, "7 data bits", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, DATA_BITS_7)
		+ (defaultDataBits = new UIW_BUTTON(0,0,0, "8 data bits", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, DATA_BITS_8)));

	// Set the default data bits8.
	dataBitsField->list.SetCurrent(defaultDataBits);

	stopBitsField = &(*new UIW_COMBO_BOX(15, 5, 20, 5)
		+ (defaultStopBits = new UIW_BUTTON(0,0,0, "1 stop bit", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, STOP_BITS_1))
		+ new UIW_BUTTON(0,0,0, "2 stop bit", BTF_NO_3D | BTF_NO_TOGGLE,
			WOF_NO_FLAGS, COMPORT_SETUP::NewSettings, STOP_BITS_2));

	currentSettings = new UIW_GROUP(37, 0, 20, 6, "Settings:");
	*currentSettings
		+ (currentPort = new UIW_STRING(1, 1, 15, "Com port 1", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE))
		+ (currentBaud = new UIW_STRING(1, 2, 15, "9600 baud", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE))
		+ (currentParity = new UIW_STRING(1, 3, 15, "No parity", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE))
		+ (currentDataBits = new UIW_STRING(1, 4, 15, "8 data bits", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE))
		+ (currentStopBits = new UIW_STRING(1, 5, 15, "1 stop bit", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE));

	*this
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
		+ new UIW_TITLE("Communications Setup")
		+ new UIW_PROMPT(1, 1, "Port in use:")
		+ portField
		+ new UIW_PROMPT(1, 2, "Baud rate:")
		+ baudField
		+ new UIW_PROMPT(1, 3, "Parity:")
		+ parityField
		+ new UIW_PROMPT(1, 4, "Data bits:")
		+ dataBitsField
		+ new UIW_PROMPT(1, 5, "Stop bits:")
		+ stopBitsField
		+ new UIW_BUTTON(1, 7, 18, "&Default Settings", BTF_NO_TOGGLE, WOF_NO_FLAGS,
			COMPORT_SETUP::ResetDefaults)
		+ currentSettings;
}

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	// Add the window to the window manager.
	*windowManager
		+ new COMPORT_SETUP();

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
