//	DIRECT.CPP (DIRECT) - File directory program.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__ZTC__) | defined(_MSC_VER)
#include <direct.h>
#else
#include <dir.h>
#endif
#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <ui_win.hpp>
#include "direct.hpp"

#define USE_FILE_WINDOW
#include "dir_win.hpp"

EVENT_TYPE FileNameFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode == L_SELECT && event.type == E_KEY)
	{
		char *file = (char *)object->Information(GET_TEXT, NULL);
		if (*file && !strchr(file, '*') && !strchr(file, '?'))
			object->eventManager->Put(UI_EVENT(OPTION_OK));
	}
	return (ccode);
}

static EVENT_TYPE ChangeDrive(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode == L_SELECT)
	{
		event.type = FILE_CHANGE_DRIVE;
		object->Information(GET_TEXT, &event.data);
		object->eventManager->Put(event);
	}
	return (ccode);
}

static EVENT_TYPE ChangeDirectory(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode == L_SELECT)
	{
		event.type = FILE_CHANGE_DIRECTORY;
		object->Information(GET_TEXT, &event.data);
		object->eventManager->Put(event);
	}
	return (ccode);
}

static EVENT_TYPE SelectFile(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;

	if (!initializedTime)
	{
		lastTime.Import();
		initializedTime = TRUE;
	}

	if (ccode == L_SELECT)
	{
		UI_TIME currentTime;
		if (event.type == E_KEY || (currentTime - lastTime <
			object->doubleClickRate))
		{
			event.type = OPTION_OK;
			object->eventManager->Put(event);
		}
		else
		{
			event.type = FILE_SET_NAME;
			object->Information(GET_TEXT, &event.data);
			object->eventManager->Put(event);
			lastTime = currentTime;
		}
	}
	return (ccode);
}

void Center(UIW_WINDOW *window)
{
	// Center the window.
	UI_DISPLAY *display = window->display;
	UI_REGION newRegion = window->relative;
	int width = newRegion.right - newRegion.left + 1;
	int height = newRegion.bottom - newRegion.top + 1;
	newRegion.left = (display->columns / display->cellWidth - width) / 2 + 1;
	newRegion.top = (display->lines / display->cellHeight - height) / 2 + 1;
	newRegion.right = newRegion.left + width - 1;
	newRegion.bottom = newRegion.top + height - 1;
	window->relative = newRegion;
}

FILE_WINDOW::FILE_WINDOW(EVENT_TYPE ccode) :
	UIW_WINDOW("DIR_WIN.DAT~FILE_WINDOW"), option(ccode)
{
	if (FlagSet(woStatus, WOS_READ_ERROR))
	{
		abort();
	}

	Center(this);

	char *title;
	if (option == FILE_NEW)
		title = "New";
	else if (option == FILE_OPEN)
		title = "Open";
	else if (option == FILE_SAVE_AS)
		title = "Save As";
	else if (option == FILE_SAVE_AS)
		title = "Delete";
	else
		title = "Statistics";

	((UIW_TITLE *)Information(GET_STRINGID_OBJECT, "NUMID_TITLE"))->Information(SET_TEXT, title);

	name = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "NAME_FIELD");
	directory = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "DIRECTORY_FIELD");
	drives = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "DRIVE_LIST");
	directories = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "DIRECTORY_LIST");
	files = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "FILE_LIST");

	// Get the available drives.
#ifdef __ZTC__
	unsigned currentDrive;
	unsigned temp;
	dos_getdrive(&currentDrive);
	for (int i = 0; i < 26; i++)
	{
		dos_setdrive(i + 1, &temp);
		dos_getdrive(&temp);
		if (temp - 1 == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	dos_setdrive(currentDrive, &temp);
#endif
#ifdef _MSC_VER
	unsigned currentDrive;
	unsigned temp;
	_dos_getdrive(&currentDrive);
	for (int i = 0; i < 26; i++)
	{
		_dos_setdrive(i + 1, &temp);
		_dos_getdrive(&temp);
		if (temp - 1 == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	_dos_setdrive(currentDrive, &temp);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	int currentDrive = getdisk();
	for (int i = 0; i < 26; i++)
	{
		setdisk(i);
		if (getdisk() == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	setdisk(currentDrive);
#endif

}

EVENT_TYPE FILE_WINDOW::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case OPTION_OK:
		{
		// Get full path name for file.
		char path[128];
		strcpy(path, name->DataGet());

		if (!*path || strchr(path, '*') || strchr(path, '?'))
			break;

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
#ifdef __ZTC__
		struct FIND fileBlock, *fBlock;
		fBlock = findfirst(path, FA_DIREC);
		int found = fBlock ? 1 : 0;
		if (fBlock)
			fileBlock = *fBlock;
#endif
#ifdef _MSC_VER
		struct _find_t fileBlock;
		int found = !(_dos_findfirst(path, _A_SUBDIR, &fileBlock));
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		struct ffblk fileBlock;
		int found = !(findfirst(path, &fileBlock, FA_DIREC));
#endif
		// Check for valid file.
		if (((option == FILE_NEW || option == FILE_SAVE_AS) && found)||
			((option == FILE_OPEN || option == FILE_STATS ||
			option == FILE_DELETE) && !found))
		{
			DIALOG_WINDOW dialog("Error!", "ASTERISK", DIF_OK,
				"Invalid file name:\r\n\r\n%s", path);
			dialog.Responce();
			break;
		}

		// Perform the action.
		if (option == FILE_NEW)
		{
			DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
					"Create file option.");
			dialog.Responce();
		}
		else if (option == FILE_OPEN)
		{
			DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
					"Open file option.");
			dialog.Responce();
		}
		else if (option == FILE_SAVE_AS)
		{
			DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
					"Save As option.");
			dialog.Responce();
		}
		else if (option == FILE_DELETE)
		{
			DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
				"Delete option!");
			dialog.Responce();
		}
		else if (option == FILE_STATS)
		{
			char *file = name->DataGet();
			UIW_WINDOW *window = UIW_WINDOW::Generic(0,0,40,7,"Statistics",
				NULL, WOF_NO_FLAGS, WOAF_TEMPORARY);
			*window
				+ new UIW_PROMPT(1, 1, "File name:")
				+ new UIW_PROMPT(20, 1, file)
				+ new UIW_PROMPT(1, 2, "Time create:")
				+ new UIW_PROMPT(1, 3, "Date created:")
				+ new UIW_PROMPT(1, 4, "Size:");
#ifdef __ZTC__
			struct FIND fileBlock, *fBlock;
			fBlock = findfirst(file, FA_DIREC);
			int empty = !fBlock;
			if (empty)
				break;

			UI_DATE date(fileBlock.date);
			char dateString[64];
			DTF_FLAGS dtFlags = DTF_NO_FLAGS;
			date.Export(dateString, dtFlags);

			UI_TIME time(fileBlock.time);
			char timeString[64];
			TMF_FLAGS tmFlags = TMF_ZERO_FILL | TMF_SECONDS;
			time.Export(timeString, tmFlags);

			char sizeString[35];
			ltoa(fileBlock.size, sizeString, 10);

#endif
#ifdef _MSC_VER
			struct _find_t fileBlock;
			int empty = _dos_findfirst(file, _A_SUBDIR, &fileBlock);
			if (empty)
				break;

			UI_DATE date(fileBlock.wr_date);
			char dateString[64];
			DTF_FLAGS dtFlags = DTF_NO_FLAGS;
			date.Export(dateString, dtFlags);

			UI_TIME time(fileBlock.wr_time);
			char timeString[64];
			TMF_FLAGS tmFlags = TMF_ZERO_FILL | TMF_SECONDS;
			time.Export(timeString, tmFlags);

			char sizeString[35];
			ltoa(fileBlock.size, sizeString, 10);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
			struct ffblk fileBlock;
			int empty = findfirst(file, &fileBlock, FA_DIREC);
			if (empty)
				break;

			UI_DATE date(fileBlock.ff_fdate);
			char dateString[64];
			DTF_FLAGS dtFlags = DTF_NO_FLAGS;
			date.Export(dateString, dtFlags);

			UI_TIME time(fileBlock.ff_ftime);
			char timeString[64];
			TMF_FLAGS tmFlags = TMF_ZERO_FILL | TMF_SECONDS;
			time.Export(timeString, tmFlags);

			char sizeString[35];
			ltoa(fileBlock.ff_fsize, sizeString, 10);
#endif					
			*window
				+ new UIW_PROMPT(20, 2, timeString)
				+ new UIW_PROMPT(20, 3, dateString)
				+ new UIW_PROMPT(20, 4, sizeString);
			*windowManager + window;
			break;
		}

		eventManager->Put(UI_EVENT(S_CLOSE), Q_BEGIN);
		}
		break;

	case OPTION_CANCEL:
		eventManager->Put(UI_EVENT(S_CLOSE));
		break;

	case FILE_SET_NAME:
		name->Information(SET_TEXT, event.data);
		break;

	case S_INITIALIZE:
	case FILE_CHANGE_DRIVE:
	case FILE_CHANGE_DIRECTORY:
#ifdef __ZTC__
		{
		unsigned currentDrive;
		unsigned temp;
		dos_getdrive(&currentDrive);
		if (ccode == FILE_CHANGE_DRIVE)
		{
			dos_setdrive(*((char *)event.data) - 'a' + 1, &temp);
			dos_getdrive(&temp);
			if (temp == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);

		// Get the current path.
		char pathName[100];
		if (!getcwd(pathName, 100))
		{
			dos_setdrive(currentDrive, &temp);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		struct FIND *fileBlock;
		fileBlock = findfirst("*.*", FA_DIREC);
		while (fileBlock)
		{
			if (fileBlock->attribute == FA_DIREC &&
				strcmp(".", fileBlock->name) &&
				strcmp("..", fileBlock->name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock->name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			fileBlock = findnext();
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.*";

		fileBlock = findfirst(matchName, FA_DIREC);
		while (fileBlock)
		{	   
			if (fileBlock->attribute != FA_DIREC)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock->name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			fileBlock = findnext();
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
#ifdef _MSC_VER
		{
		unsigned currentDrive;
		unsigned temp;
		_dos_getdrive(&currentDrive);
		if (ccode == FILE_CHANGE_DRIVE)
		{
			_dos_setdrive(*((char *)event.data) - 'a' + 1, &temp);
			_dos_getdrive(&temp);
			if (temp == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);

		// Get the current path.
		char pathName[100];
		if (!getcwd(pathName, 100))
		{
			_dos_setdrive(currentDrive, &temp);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		struct _find_t fileBlock;
		int empty = _dos_findfirst("*.*", _A_SUBDIR, &fileBlock);
		while (!empty)
		{
			if (fileBlock.attrib == _A_SUBDIR &&
				strcmp(".", fileBlock.name) &&
				strcmp("..", fileBlock.name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock.name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			empty = _dos_findnext(&fileBlock);
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.*";

		empty = _dos_findfirst(matchName, _A_SUBDIR, &fileBlock);
		while (!empty)
		{
			if (fileBlock.attrib != _A_SUBDIR)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock.name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			empty = _dos_findnext(&fileBlock);
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		{
		int currentDrive = getdisk();
		if (ccode == FILE_CHANGE_DRIVE)
		{
			setdisk(*((char *)event.data) - 'a');
			if (getdisk() == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);

		// Get the current path.
		char pathName[100];
		if (!getcwd(pathName, 100))
		{
			setdisk(currentDrive);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		struct ffblk fileBlock;
		int empty = findfirst("*.*", &fileBlock, FA_DIREC);
		while (!empty)
		{
			if (fileBlock.ff_attrib == FA_DIREC &&
				strcmp(".", fileBlock.ff_name) &&
				strcmp("..", fileBlock.ff_name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock.ff_name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			empty = findnext(&fileBlock);
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.*";

		empty = findfirst(matchName, &fileBlock, FA_DIREC);
		while (!empty)
		{
			if (fileBlock.ff_attrib != FA_DIREC)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock.ff_name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			empty = findnext(&fileBlock);
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	eventManager->DeviceState(E_MOUSE, DM_VIEW);
	return (ccode);
}

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	// Initialize the default storage.
	UI_STORAGE *storage = new UI_STORAGE("dir_win.dat", UIS_READ);
	UI_WINDOW_OBJECT::defaultStorage = storage;

	// Add the directory window to the window manager.
	*windowManager
		+ new FILE_WINDOW(FILE_STATS);

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
