# DISPLAY example makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak display.exe      (makes the display example program)
#    make -fzortech.mak wdisplay.exe     (makes the Windows display program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: display.exe wdisplay.exe


display.exe: display.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+display.obj,$*, ,$(DOS_LIBS),NUL


wdisplay.exe: display.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+display.obw,$*, ,$(WIN_LIBS),wdisplay.def
	rc -k wdisplay.rc $*.exe
