//	ERROR.CPP (ERROR) - Error window example program.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

EVENT_TYPE DateUserFunction(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != S_NON_CURRENT && ccode != L_SELECT)
		return (ccode);

	// Do specific validation.
	UI_DATE currentDate;
	UI_DATE *date = ((UIW_DATE *)object)->DataGet();

	// Call the default Validate function to check for valid date.
	int valid = object->Validate(TRUE);

	// Call error system if the date entered is later than the system date.
	if (valid == DTI_OK && currentDate < *date)
	{
		valid = DTI_INVALID;
		char dateString[64];
		currentDate.Export(dateString, DTF_NO_FLAGS);
		if (object->errorSystem)
			object->errorSystem->ReportError(object->windowManager, WOS_NO_STATUS,
				"The date must be before %s.", dateString);
	}

	// Return error status.
	if (valid == DTI_OK)
		return (0);
	else
		return (-1);
}


#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

 	// Initialize the error system.
	UI_WINDOW_OBJECT::errorSystem = new UI_ERROR_SYSTEM;

	// Create the error date window.
	UIW_WINDOW *window = new UIW_WINDOW(5, 5, 40, 4);

	// Add the window objects to the window.
	UI_DATE date;
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
		+ new UIW_TITLE("Date Error Window")
		+ new UIW_PROMPT(2, 0, "Enter tomorrow's date for error:")
		+ new UIW_DATE(2, 1, 20, &date, "1-1-1900..1-1-2000", DTF_ALPHA_MONTH |
			DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR, DateUserFunction);

	// Add the window to the window manager.
	*windowManager + window;

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete UI_WINDOW_OBJECT::errorSystem;
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
