//	FILE.CPP (FILEEDIT) - File editor example program.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <fcntl.h>
#ifdef _MSC_VER
#include <sys\types.h>
#endif
#include <sys\stat.h>
#include <io.h>
#include <string.h>
#include <ui_win.hpp>
#include "file.hpp"

DOS_FILE::DOS_FILE(const char *fileName) :
	fileHandle(0)
{
	strcpy(file, fileName);
}

DOS_FILE::~DOS_FILE()
{
	// Close the file if still open.
	if (fileHandle && fileHandle != -1)
		Close();
}

int DOS_FILE::Read(char *buffer, unsigned bufferLength)
{
	// Read from the file. (Open if not yet open)
	if (!fileHandle)
		Open();
	if (fileHandle != -1 && filelength(fileHandle) < bufferLength)
		return(read(fileHandle, buffer, bufferLength));
	else if (fileHandle != -1)
		Close();
	return(-1);
}

int DOS_FILE::Write(char *buffer, unsigned bufferLength)
{
	// If the file has not been read then clear the file if it exists.
	if (!fileHandle)
		Open(O_CREAT | O_TRUNC);
	if (fileHandle != -1)
		return(write(fileHandle, buffer, bufferLength));
	return(-1);
}

int DOS_FILE::Open(int access)
{
	// Open the file for reading and writing.
	if (fileHandle)
		Close();
#if defined (__BCPLUSPLUS__) || defined (__TCPLUSPLUS__)
	fileHandle = open(file, O_RDWR | O_BINARY | access, S_IWRITE | S_IREAD);
#elif defined _MSC_VER
	fileHandle = _open(file, O_RDWR | O_BINARY | access, _S_IWRITE | _S_IREAD);
#elif defined __ZTC__
	fileHandle = open(file, O_RDWR | O_BINARY | access, S_IWRITE | S_IREAD);
#endif

	return(fileHandle);
}

void DOS_FILE::Close()
{
	// Close the file.
	close(fileHandle);
	fileHandle = 0;
}

long DOS_FILE::Position(long offset, int fromWhere)
{
	// Position the file pointer 'offset' bytes from 'fromWhere' in the file.
	// Values for 'fromWhere' include:
	//		SEEK_SET - File beginning.
	//		SEEK_CUR - Current position. (Set as default if no 'fromWhere')
	//		SEEK_END - File end.
	// This returns the position as the number of bytes from the file beginning.
	if (!fileHandle)
		Open();
	return(lseek(fileHandle, offset, fromWhere));
}
