//	FREESTOR.CPP (FREESTOR) - Demonstrate the use of the Free Store Exception Handler.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <ui_win.hpp>
#include "mem_err.hpp"

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	// Set up the Free Store Exception handler.
	MEMORY_ALLOCATION_ERROR_SYSTEM *memErrorSystem =
		new MEMORY_ALLOCATION_ERROR_SYSTEM(display, eventManager, windowManager);
	if (!memErrorSystem->installed)
	{
		delete memErrorSystem;
		delete windowManager;
		delete eventManager;
		delete display;
		printf("Not enough memory to install memory error handler.");
	}

	*windowManager
		+ &(* UIW_WINDOW::Generic(0,0,40,11, "Free Store Tester")
			+ new UIW_TEXT(0,0,0,0,
				"This is a test of the Free Store Exception Handler. "
				"When the new operator fails, a NULL is usually returned. "
				"For this example a \"new handler\" is called instead. This "
				"handler takes control, notifies the user, and does clean up "
				"and exit. It may take a few hundred windows to use up all of "
				"memory. Be patient and watch.", 512,
				WNF_NO_FLAGS, WOF_NON_FIELD_REGION));

	// Now add windows until a Free Store Exception error is found.
	int centerX = display->columns / display->cellWidth / 2;
	int i = 0;

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		ccode = eventManager->Get(event, Q_NO_BLOCK);
		if (!ccode)
			ccode = windowManager->Event(event);
		else
		{
			i++;
			*windowManager
				+ &(*new UIW_WINDOW(centerX - 20, 11, 40, 7,
					WOF_NO_FLAGS, WOAF_NO_FLAGS)
					+ new UIW_BORDER
					+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
					+ new UIW_TITLE("Memory Test Window")
					+ new UIW_INTEGER(17, 2, 5, &i));
		}
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete memErrorSystem;
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
