// MESSAGES.CPP (MESSAGES) - User defined message handling.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
// Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <string.h>
#include <ui_win.hpp>

// User defined event type.
const int U_SET = 12001;

// MY_BUTTON is derived from UIW_BUTTON that understands U_SET event.
class EXPORT MY_BUTTON : public UIW_BUTTON
{
public:
	MY_BUTTON(int left, int top, int width, char *_string, BTF_FLAGS _btFlags,
		WOF_FLAGS _woFlags, USER_FUNCTION _userFunction) : UIW_BUTTON(left, top, width, _string, _btFlags,
		_woFlags, _userFunction) {}
	virtual ~MY_BUTTON() {}

	virtual EVENT_TYPE Event(const UI_EVENT &event);
	static EVENT_TYPE LeaveMessage(UI_WINDOW_OBJECT *object, UI_EVENT &event,
		EVENT_TYPE ccode);
	static EVENT_TYPE UserFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event,
		EVENT_TYPE ccode);
};

// Event function for MY_BUTTON that understands U_SET event.
EVENT_TYPE MY_BUTTON::Event(const UI_EVENT &event)
{
	if(event.type == U_SET)
	{
		Information(SET_TEXT, (char *)event.data, ID_BUTTON);
		delete event.data;

		// Leave message to redisplay button after DataSet.
		UI_EVENT newEvent;
		newEvent.type = S_REDISPLAY;
		newEvent.region = true;
		return(UIW_BUTTON::Event(newEvent));
	}
	else
		return(UIW_BUTTON::Event(event));
}

EVENT_TYPE MY_BUTTON::LeaveMessage(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	// Leave a message to close current window;
	event.type = S_CLOSE;
	object->eventManager->Put(event);

	// Leave a User Defined message for current object to DataSet itself.
	event.type = U_SET;
	event.data = ui_strdup((char *)object->Information(GET_TEXT, NULL, ID_BUTTON));
	object->eventManager->Put(event);

	return ccode;
}

// User Funtion for buttons that will receive message.
EVENT_TYPE MY_BUTTON::UserFunction(UI_WINDOW_OBJECT *object, UI_EVENT &,
	EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	// Create a list of buttons with possible entries in them.
	UIW_VT_LIST *list = new UIW_VT_LIST(0, 0, 0, 0, NULL,
		WNF_NO_WRAP, WOF_NON_FIELD_REGION | WOF_BORDER, WOAF_NO_FLAGS);

	*list	  
		+ new MY_BUTTON(0, 0, 10, "OPTION 1", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 2", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 3", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 4", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 5", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 6", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 7", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 8", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 9", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage)
		+ new MY_BUTTON(0, 0, 10, "OPTION 10", BTF_NO_3D | BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
			LeaveMessage);

	// Create a window with the list in it and add it to window manager.
	UIW_WINDOW *window = new UIW_WINDOW(40, 5, 20, 14, WOF_NO_FLAGS,
		WOAF_NO_MOVE | WOAF_NO_SIZE);

	*window
		+ new UIW_BORDER
		+ new UIW_TITLE("OPTIONS")
		+ list;

	*object->windowManager + window;

	return ccode;
}

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	UIW_WINDOW *mainWindow = UIW_WINDOW::Generic(5, 5, 22, 6, "MAIN");
	*mainWindow
		+ new MY_BUTTON(1, 1, 18, "Press Me", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, MY_BUTTON::UserFunction)
		+ new MY_BUTTON(1, 3, 18, "Press Me Too", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, MY_BUTTON::UserFunction);

	*windowManager
		+ mainWindow;

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
