# MESSAGES example makefile

# Uses Microsoft C++ 7.00 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_M70;C:\C700\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE

#    make -fmicrosft.mak messages.exe     (makes the messages example program)
#    make -fmicrosft.mak wmessage.exe     (makes the Windows messages program)

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
DOS_CPP_OPTS=-c -AL -BATCH
DOS_LINK_OPTS=/NOI /BATCH /STACK:5120 /SEGMENTS:256
WIN_CPP_OPTS=-c -AL -BATCH -Gw -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<


all: messages.exe wmessage.exe


messages.exe: messages.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+messages.obj
$*,NUL,$(DOS_LIBS),NUL
<<


wmessage.exe: messages.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+messages.obw
$*,NUL,$(WIN_LIBS),wmessage.def
<<
	rc -30 -k wmessage.rc $*.exe
