# Makefile for PIANO example program 
# Uses Zinc Interface Library Version 3.00 and Borland C++ 3.00

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#   make -fborland.mak piano.exe    (makes the piano example for DOS)
#   make -fborland.mak wpiano.exe   (makes the piano example for Windows)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
CPP_OPTS=-c -ml -O -w
LINK_OPTS=/c /x
WCPP_OPTS=-c -ml -O -WE -w
WLINK_OPTS=/c /C /Twe /x

## Libraries
C_OBJS=c0l
C_LIBS=zil graphics emu mathl cl
WC_OBJS=c0wl
WC_LIBS=zilw mathwl import cwl


.cpp.obj:
	$(CPP) $(CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WCPP_OPTS) -o$*.obw {$< }

all : piano.exe wpiano.exe

piano.exe: piano.obj sound.obj
	$(LINK) $(LINK_OPTS) @&&!
$(C_OBJS)+piano.obj+sound.obj
$*, ,$(C_LIBS)
!

wpiano.exe: piano.obw sound.obw
	$(LINK) $(WLINK_OPTS) @&&!
$(WC_OBJS)+piano.obw+sound.obw
$*, ,$(WC_LIBS),wpiano.def
!
	rc wpiano.rc $<
