//	PUZZLE.CPP (PUZZLE) - Sample fifteens puzzle using buttons.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


// This sample program illustrates using buttons in a window.

#include <stdlib.h>
#include <time.h>
#include <ui_win.hpp>

class PUZZLE : public UIW_WINDOW
{
public:
	PUZZLE(int left, int top);
	~PUZZLE(void) {}

	static EVENT_TYPE ButtonFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event, EVENT_TYPE ccode);

	UIW_BUTTON *blankButton;
};

PUZZLE::PUZZLE(int left, int top) :
	UIW_WINDOW(left, top, 20, 12, WOF_NO_FLAGS, WOAF_NO_SIZE)
{
	int i, j;
	int count = 16;
	char letter[] = " ";
	UIW_BUTTON *button;
	UI_LIST list;

	// Add border and title to the window.
	*this
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Puzzle", WOF_JUSTIFY_CENTER);

	// Add the buttons to a temporary list.
	blankButton = new UIW_BUTTON(0, 0, 0, letter, BTF_NO_TOGGLE | BTF_NO_3D,
		WOF_JUSTIFY_CENTER, PUZZLE::ButtonFunction);
	list + blankButton;
	for (i = 0; i < 15; i++)
	{
		letter[0] = 'A' + i;
		list + new UIW_BUTTON(0, 0, 3, letter, BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER,
					PUZZLE::ButtonFunction);
	}

	// Randomly pick from the list and add the buttons to the window.
	struct tm *sTime;
	time_t lTime;
	time(&lTime);
	sTime = localtime(&lTime);
	int seed = sTime->tm_sec;
	srand(seed);
	for (i = 1; i <= 16; i += 4)
		for (j = 1; j <= 8; j += 2)
		{
			button = (UIW_BUTTON *)list.Get( rand() / (32767 / count--) );
			list - button;
			button->relative.left = i;
			button->relative.top = j;
			button->relative.right = i + 3;
			button->relative.bottom = j + 1;
			*this + button;
		}
}

EVENT_TYPE PUZZLE::ButtonFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event, EVENT_TYPE ccode)
{
	// Update only on exit from the field.
	if (ccode != L_SELECT)
		return (0);

	UI_REGION region;
	UIW_BUTTON *button = (UIW_BUTTON *)object;
	PUZZLE *puzzle = (PUZZLE *)button->parent;
	UIW_BUTTON *empty = puzzle->blankButton;

	// Calculate distance to blank button.
	int xDistance = abs(empty->true.left - button->true.left);
	int yDistance = abs(empty->true.top - button->true.top);

	// If distance is less than one square away, swap regions.
	if ((abs(xDistance) == puzzle->display->cellWidth * 4 && !yDistance) ||
		(abs(yDistance) == puzzle->display->cellHeight * 2 && !xDistance))
	{
		region.left = empty->relative.left;
		region.top = empty->relative.top;
		region.right = empty->relative.right;
		region.bottom = empty->relative.bottom;

		empty->relative.left = button->relative.left;
		empty->relative.top = button->relative.top;
		empty->relative.right = button->relative.right;
		empty->relative.bottom = button->relative.bottom;

		button->relative.left = region.left;
		button->relative.top = region.top;
		button->relative.right = region.right;
		button->relative.bottom = region.bottom;

		event.type = S_CREATE;
		empty->Event(event);
		button->Event(event);

		// Redisplay the pieces.
		*puzzle + button;
		*puzzle + empty;
	}

	return (0);
}

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

 	// Add the puzzle to the window manager.
	*windowManager + new PUZZLE(0, 0);

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
