//	TTY.HPP (SPY) - Output window.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


// This MUST be greater than the length of the formatted string sent to ttyWindow->Printf() !!!!!
const int MAX_TTY_STRING_LENGTH = 80;

class TTY_ELEMENT : public UIW_STRING
{
	friend class TTY_WINDOW;
public:
	void DataSet(TTY_ELEMENT *element) { UIW_STRING::DataSet(element->DataGet()); }
	void DataSet(char *string) { UIW_STRING::DataSet(string); }
	virtual EVENT_TYPE Event(const UI_EVENT &event);
	TTY_ELEMENT *Next(void) { return (TTY_ELEMENT *)next; }
	TTY_ELEMENT *Previous(void) { return (TTY_ELEMENT *)previous; }

private:
	int height;

	TTY_ELEMENT(int left, int top, int width, int _height, int length);
};

class TTY_WINDOW : public UIW_WINDOW
{
public:
	TTY_WINDOW(void) :
		UIW_WINDOW(0, 0, 0, 0, WOF_NON_FIELD_REGION), numberShowing(0) { }
	~TTY_WINDOW(void) { }

	virtual EVENT_TYPE Event(const UI_EVENT &event);

	TTY_ELEMENT *Current(void) { return (TTY_ELEMENT *)current; }
	TTY_ELEMENT *First(void) { return (TTY_ELEMENT *)first; }
	TTY_ELEMENT *Last(void) { return (TTY_ELEMENT *)last; }

	void Printf(char *format, ...);

private:
	int numberShowing;
};
