## Zinc Interface Library version 3.00 makefile
## DESIGN.EXE, WDESIGN.EXE and GENHELP.EXE
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Borland C++ 2.00

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bccx
LINK=tlinkx
LIBRARIAN=tlib
DOS_CPP_OPTS=-c -ml -O -V -Y -w -H=ZIL.SYM
DOS_LINK_OPTS=/c /x
DOS_LIB_OPTS=/C
WIN_CPP_OPTS=-c -ml -O -Vf -WE -w -H=ZIL.SYM
WIN_LINK_OPTS=/c /C /Twe /x
WIN_LIB_OPTS=/C
WINDLL_CPP_OPTS=-c -ml -O -Vf -WDE -w -H=ZIL.SYM
WINDLL_LINK_OPTS=/c /C /Twd /x
WINDLL_LIB_OPTS=/C
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil cl mathl emu graphics
WIN_OBJS=c0wl
WIN_LIBS=zilw cwinl import mathwl
WINDLL_OBJS=c0dl
WINDLL_LIBS=cwl import mathwl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obw {$< }

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obd {$< }

.rc.res:
	rc -r $<


bin: design.exe wdesign.exe genhelp.exe


genhelp.exe: genhelp.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+$*, $*, , $(DOS_LIBS)


design.exe: d_design.obj \
	d_bitmap.obj d_combo.obj d_config.obj d_ctrl.obj d_dialog.obj \
	d_doserr.obj d_file.obj d_frame.obj d_help.obj d_help1.obj \
	d_hlpbar.obj d_hlpmsg.obj d_image.obj d_image1.obj d_jump.obj \
	d_list.obj d_memerr.obj d_resrc.obj d_util.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+d_design.obj+
d_bitmap.obj+d_combo.obj+d_config.obj+d_ctrl.obj+d_dialog.obj+
d_doserr.obj+d_file.obj+d_frame.obj+d_help.obj+d_help1.obj+
d_hlpbar.obj+d_hlpmsg.obj+d_image.obj+d_image1.obj+d_jump.obj+
d_list.obj+d_memerr.obj+d_resrc.obj+d_util.obj
$*, , $(DOS_LIBS)
!
	@del *.sym


wdesign.exe: wdesign.res d_design.obw \
	d_bitmap.obw d_combo.obw d_config.obw d_ctrl.obw d_dialog.obw \
	d_doserr.obw d_file.obw d_frame.obw d_help.obw d_help1.obw \
	d_hlpbar.obw d_hlpmsg.obw d_image.obw d_image1.obw d_jump.obw \
	d_list.obw d_memerr.obw d_resrc.obw d_util.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+d_design.obw+
d_bitmap.obw+d_combo.obw+d_config.obw+d_ctrl.obw+d_dialog.obw+
d_doserr.obw+d_file.obw+d_frame.obw+d_help.obw+d_help1.obw+
d_hlpbar.obw+d_hlpmsg.obw+d_image.obw+d_image1.obw+d_jump.obw+
d_list.obw+d_memerr.obw+d_resrc.obw+d_util.obw
$*, , $(WIN_LIBS)
$*.def
!
	rc $*.res $*.exe
	@del zil.sym
