//	Zinc Interface Library - COUNTRY.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include <locale.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include "ui_gen.hpp"
#pragma hdrstop

struct DOS2_COUNTRY
{
	int dateFormat;
	char currencySymbol[2];
	char thousandsSeparator[2];
	char decimalSeparator[2];
	char filler[24];
};

struct DOS3_COUNTRY
{
	int dateFormat;
	char currencySymbol[5];
	char thousandsSeparator[2];
	char decimalSeparator[2];
	char dateSeparator[2];
	char timeSeparator[2];
	char currencyStyle;
	char significantDigits;
	char timeFormat;
	long caseMap;
	char dataSeparator[2];
	char filler[10];
};

int UI_INTERNATIONAL::initialized = FALSE;
int UI_INTERNATIONAL::countryCode = 0;

char UI_INTERNATIONAL::decimalSeparator[4] = ".";
char UI_INTERNATIONAL::monDecimalSeparator[4] = ".";
char UI_INTERNATIONAL::thousandsSeparator[4] = ",";
char UI_INTERNATIONAL::monThousandsSeparator[4] = ",";
char UI_INTERNATIONAL::currencySymbol[8] = "$";
char UI_INTERNATIONAL::intCurrencySymbol[8] = "$";
int UI_INTERNATIONAL::posCurrencyPrecedes = TRUE;
int UI_INTERNATIONAL::negCurrencyPrecedes = TRUE;
int UI_INTERNATIONAL::fractionDigits = 2;
int UI_INTERNATIONAL::intFractionDigits = 2;
char UI_INTERNATIONAL::positiveSign[4] = "";
int UI_INTERNATIONAL::posSignPrecedes = TRUE;
int UI_INTERNATIONAL::posSpaceSeparation = 0;
char UI_INTERNATIONAL::negativeSign[4] = "-";
int UI_INTERNATIONAL::negSignPrecedes = 1;
int UI_INTERNATIONAL::negSpaceSeparation = 0;

int UI_INTERNATIONAL::dateFormat = 0;
char UI_INTERNATIONAL::dateSeparator[4] = "/";

int UI_INTERNATIONAL::timeFormat = 0;
char UI_INTERNATIONAL::timeSeparator[4] = ":";

void UI_INTERNATIONAL::Initialize(void)
{
	// Make sure the country information has not already been initialized.
	if (initialized)
		return;
	initialized = TRUE;

	// Get the locale information.  (Probably brain-damaged.)
	struct lconv *conv = localeconv();
	if (*conv->decimal_point)
		strcpy(decimalSeparator, conv->decimal_point);
	if (*conv->mon_decimal_point)
		strcpy(monDecimalSeparator, conv->mon_decimal_point);
	if (*conv->thousands_sep)
		strcpy(thousandsSeparator, conv->thousands_sep);
	if (*conv->mon_thousands_sep)
		strcpy(monThousandsSeparator, conv->mon_thousands_sep);
	if (*conv->int_curr_symbol)
		strcpy(intCurrencySymbol, conv->int_curr_symbol);
	if (conv->p_cs_precedes != CHAR_MAX)
		posCurrencyPrecedes = conv->p_cs_precedes;
#ifdef __ZTC__
	if (conv->n_sc_precedes != CHAR_MAX)
		negCurrencyPrecedes = conv->n_sc_precedes;
#else
	if (conv->n_cs_precedes != CHAR_MAX)
		negCurrencyPrecedes = conv->n_cs_precedes;
#endif
	if (conv->frac_digits != CHAR_MAX)
		fractionDigits = conv->frac_digits;
#ifndef __ZTC__
	if (conv->int_frac_digits != CHAR_MAX)
		intFractionDigits = conv->int_frac_digits;
	if (*conv->positive_sign)
		strcpy(positiveSign, conv->positive_sign);
	if (conv->p_sign_posn != CHAR_MAX)
		posSignPrecedes = conv->p_sign_posn;
#endif
	if (conv->p_sep_by_space != CHAR_MAX)
		posSpaceSeparation = conv->p_sep_by_space;
	if (*conv->negative_sign)
		strcpy(positiveSign, conv->negative_sign);
	if (conv->n_sign_posn != CHAR_MAX)
		negSignPrecedes = conv->n_sign_posn;
	if (conv->n_sep_by_space != CHAR_MAX)
		negSpaceSeparation = conv->n_sep_by_space;

#if defined(_MSC_VER)
	// Override it with the DOS country information
	union _REGS regs;
	struct _SREGS segregs;

	static DOS2_COUNTRY dos2Info;
	static DOS3_COUNTRY dos3Info;

	// Get the proper operating system version.
	if (_osmajor == 2)
	{
		void far* ptr = &dos2Info;
		regs.x.dx = _FP_OFF(ptr);
		segregs.ds = _FP_SEG(ptr);
	}
	else
	{
		void far* ptr = &dos3Info;
		regs.x.dx = _FP_OFF(ptr);
		segregs.ds = _FP_SEG(ptr);
	}

	// Determine the country code.
	regs.x.ax = 0x3800;
	_int86x(0x21, &regs, &regs, &segregs);
	countryCode = (regs.h.al == 0xFF) ? regs.x.bx : regs.h.al;
#else
	extern unsigned char _osmajor;

	// Override it with the DOS country information
	union REGS regs;
	struct SREGS segregs;

	static DOS2_COUNTRY dos2Info;
	static DOS3_COUNTRY dos3Info;

	// Get the proper operating system version.
	if (_osmajor == 2)
		regs.x.dx = (USHORT)&dos2Info;
	else
		regs.x.dx = (USHORT)&dos3Info;

	// Determine the country code.
	regs.x.ax = 0x3800;
	int86(0x21, &regs, &regs);
	countryCode = (regs.h.al == 0xFF) ? regs.x.bx : regs.h.al;
#endif
	if (_osmajor == 2)
	{
		dateFormat = dos2Info.dateFormat;
		strcpy(currencySymbol, dos2Info.currencySymbol);
		strcpy(intCurrencySymbol, dos2Info.currencySymbol);
		strcpy(thousandsSeparator, dos2Info.thousandsSeparator);
		strcpy(monThousandsSeparator, dos2Info.thousandsSeparator);
		strcpy(decimalSeparator, dos2Info.decimalSeparator);
		strcpy(monDecimalSeparator, dos2Info.decimalSeparator);
	}
	else
	{
		dateFormat = dos3Info.dateFormat;
		strcpy(currencySymbol, dos3Info.currencySymbol);
		strcpy(intCurrencySymbol, dos3Info.currencySymbol);
		strcpy(thousandsSeparator, dos3Info.thousandsSeparator);
		strcpy(monThousandsSeparator, dos3Info.thousandsSeparator);
		strcpy(decimalSeparator, dos3Info.decimalSeparator);
		strcpy(monDecimalSeparator, dos3Info.decimalSeparator);
		strcpy(dateSeparator, dos3Info.dateSeparator);
		strcpy(timeSeparator, dos3Info.timeSeparator);
		posSignPrecedes = negSignPrecedes = 1;
		switch (dos3Info.currencyStyle)
		{
		case 0:
			posSpaceSeparation = negSpaceSeparation = 0;
			posCurrencyPrecedes = negCurrencyPrecedes = 1;
			break;

		case 1:
			posSpaceSeparation = negSpaceSeparation = 0;
			posCurrencyPrecedes = negCurrencyPrecedes = 0;
			break;

		case 2:
			posSpaceSeparation = negSpaceSeparation = 1;
			posCurrencyPrecedes = negCurrencyPrecedes = 1;
			break;

		case 3:
			posSpaceSeparation = negSpaceSeparation = 1;
			posCurrencyPrecedes = negCurrencyPrecedes = 0;
			break;
		case 4:
			posSpaceSeparation = negSpaceSeparation = 0;
			posCurrencyPrecedes = negCurrencyPrecedes = 1;
			strcpy(monDecimalSeparator, currencySymbol);
			strcpy(currencySymbol, "");
			break;
		}
		intFractionDigits = fractionDigits = dos3Info.significantDigits;
		timeFormat = dos3Info.timeFormat;
	}
#ifdef _WINDOWS
	char *intlString = "Intl";

	GetProfileString(intlString, "sDecimal", decimalSeparator,
			 decimalSeparator, sizeof(decimalSeparator));
	GetProfileString(intlString, "sDecimal", monDecimalSeparator,
			 monDecimalSeparator, sizeof(monDecimalSeparator));
	GetProfileString(intlString, "sThousand", thousandsSeparator,
			 thousandsSeparator, sizeof(thousandsSeparator));
	GetProfileString(intlString, "sThousand", monThousandsSeparator,
			 monThousandsSeparator, sizeof(monThousandsSeparator));
	GetProfileString(intlString, "sCurrency", currencySymbol,
			 currencySymbol, sizeof(currencySymbol));
	// ???? intCurrencySymbol
	WORD tmpval;
	tmpval = GetProfileInt(intlString, "iCurrency", -1);
	switch (tmpval) {
	case 0:
		posCurrencyPrecedes = 1;
		posSpaceSeparation = 0;
		break;
	case 1:
		posCurrencyPrecedes = FALSE;
		posSpaceSeparation = 0;
		break;
	case 2:
		posCurrencyPrecedes = TRUE;
		posSpaceSeparation = 1;
		break;
	case 3:
		posCurrencyPrecedes = FALSE;
		posSpaceSeparation = 1;
		break;
	}
	// ???? posSignPrecedes = 1;
	// ???? positiveSign
	// ???? negativeSign
	tmpval = GetProfileInt(intlString, "iNegCurr", -1);
	switch (tmpval) {
	case 0:
		negSignPrecedes = 0;
		negCurrencyPrecedes = 1;
		negSpaceSeparation = 0;
		break;
	case 1:
		negSignPrecedes = 1;
		negCurrencyPrecedes = 1;
		negSpaceSeparation = 0;
		break;
	case 2:
		negSignPrecedes = 3;
		negCurrencyPrecedes = 1;
		negSpaceSeparation = 0;
		break;
	case 3:
		negSignPrecedes = 2;
		negCurrencyPrecedes = 1;
		negSpaceSeparation = 0;
		break;
	case 4:
		negSignPrecedes = 0;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 0;
		break;
	case 5:
		negSignPrecedes = 1;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 0;
		break;
	case 6:
		negSignPrecedes = 4;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 0;
		break;
	case 7:
		negSignPrecedes = 2;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 0;
		break;
	case 8:
		negSignPrecedes = 1;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 1;
		break;
	case 9:
		negSignPrecedes = 1;
		negCurrencyPrecedes = 1;
		negSpaceSeparation = 1;
		break;
	case 10:
		negSignPrecedes = 2;
		negCurrencyPrecedes = 0;
		negSpaceSeparation = 1;
		break;
	}
	fractionDigits = GetProfileInt(intlString, "iCurrDigits", fractionDigits);
	// ???? intFractionDigits
	// iDate and sDate should be replaced with sShortDate
	dateFormat = GetProfileInt(intlString, "iDate", dateFormat);
	GetProfileString(intlString, "sDate", dateSeparator, dateSeparator,
			 sizeof(dateSeparator));
	timeFormat = GetProfileInt(intlString, "iTime", timeFormat);
	GetProfileString(intlString, "sTime", timeSeparator, timeSeparator,
			 sizeof(timeSeparator));

#endif
}

char *ui_strdup(const char *srcString)
{
	// strdup using new instead of malloc.
	if (!srcString || srcString[0] == '\0')
		return (NULL);
	char *destString = new char[strlen(srcString) + 1];
	strcpy(destString, srcString);
	return (destString);
}

int ui_strlen(const char *string)
{
	// Return the length of a string.
	return (string ? strlen(string) : 0);
}

void ui_strrepc(char *string, int c, int repc)
{
	if (!string)
		return;

	// Replace a character (c) in a string to a new character (repc).
    while (*string)
	{
		if (*string == c)
			*string = repc;
		string++;
    }
}
