//	Zinc Interface Library Designer - D_FILE.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__ZTC__) | defined(_MSC_VER)
#include <direct.h>
#else
#include <dir.h>
#endif
#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <bios.h>
#include "ui_dsn.hpp"
#pragma hdrstop

EVENT_TYPE FileNameFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	static char path[128];

	if (object->LogicalEvent(event, ID_WINDOW_OBJECT) == L_SELECT)
	{
		char file[128];
		char *fullPath = (char *)object->Information(GET_TEXT, NULL);
		UI_STORAGE::StripFullPath(fullPath, path, file);
		if (*file && !strchr(file, '*') && !strchr(file, '?'))
			object->eventManager->Put(UI_EVENT(OPTION_OK));
		else
		{
			event.type = FILE_CHANGE_PATH;
			strcpy(path, fullPath);
			event.data = path;
			object->eventManager->Put(event);
		}
	}
	return (ccode);
}

static EVENT_TYPE ChangeDrive(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode == L_SELECT)
	{
		event.type = FILE_CHANGE_DRIVE;
		object->Information(GET_TEXT, &event.data);
		object->eventManager->Put(event);
	}
	return (ccode);
}

static EVENT_TYPE ChangeDirectory(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (ccode == L_SELECT)
	{
		event.type = FILE_CHANGE_DIRECTORY;
		object->Information(GET_TEXT, &event.data);
		object->eventManager->Put(event);
	}
	return (ccode);
}

static EVENT_TYPE SelectFile(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;

	if (!initializedTime)
	{
		lastTime.Import();
		lastTime -= 100;
		initializedTime = TRUE;
	}

	if (ccode == L_SELECT)
	{
		UI_TIME currentTime;
		if (event.type == E_KEY || (currentTime - lastTime <
			object->doubleClickRate))
		{
			event.type = OPTION_OK;
			object->eventManager->Put(event);
		}
		else
		{
			event.type = FILE_SET_NAME;
			object->Information(GET_TEXT, &event.data);
			object->eventManager->Put(event);
			lastTime = currentTime;
		}
	}
	return (ccode);
}

FILE_WINDOW::FILE_WINDOW(EVENT_TYPE ccode) :
	UIW_WINDOW(display->isText ? "FILE_WINDOW_TEXT" : "FILE_WINDOW",
		defaultStorage), option(ccode)
{
	Center(this);

	char *title;
	if (option == FILE_NEW)
		title = "New";
	else if (option == FILE_OPEN)
		title = "Open";
	else if (option == FILE_SAVE_AS)
		title = "Save As";
	else
		title = "Delete";
	((UIW_TITLE *)Information(GET_STRINGID_OBJECT, "NUMID_TITLE"))->Information(SET_TEXT, title);

	name = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "NAME_FIELD");
	if (option == FILE_SAVE_AS)
	{
		char filePath[128];
		_storage->StorageName(filePath);
		name->Information(SET_TEXT, filePath);
	}
	char filePath[128];
	_storage->StorageName(filePath);
	directory = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "DIRECTORY_FIELD");
	drives = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "DRIVE_LIST");
	directories = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "DIRECTORY_LIST");
	files = (UIW_VT_LIST *)Information(GET_STRINGID_OBJECT, "FILE_LIST");
	helpBar = (HELP_BAR *)Information(GET_STRINGID_OBJECT, "HELP_BAR");

	// Get the available drives.
#ifdef __ZTC__
	unsigned currentDrive;
	unsigned temp;
	dos_getdrive(&currentDrive);
	for (int i = 0; i < 26; i++)
	{
		dos_setdrive(i + 1, &temp);
		dos_getdrive(&temp);
		if (temp - 1 == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	dos_setdrive(currentDrive, &temp);
#endif
#ifdef _MSC_VER
	unsigned currentDrive;
	unsigned temp;
	_dos_getdrive(&currentDrive);
	for (int i = 0; i < 26; i++)
	{
		_dos_setdrive(i + 1, &temp);
		_dos_getdrive(&temp);
		if (temp - 1 == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	_dos_setdrive(currentDrive, &temp);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	int currentDrive = getdisk();
	int floppyDrives = ((_bios_equiplist() & 0xC0) >> 6) + 1;
	for (int i = 0; i < 26; i++)
	{
		if (i == 1 && floppyDrives < 2)
			continue;
		setdisk(i);
		if (getdisk() == i)
		{
			char drive[5];
			sprintf(drive, "%c:", 'a' + i);
			char *bitmapName = "networkDrive";
			if (i <= 'b' - 'a')
				bitmapName = "softDrive";
			else if (i < 'f' - 'a')
				bitmapName = "hardDrive";
			*drives + new UIW_BUTTON(0, 0, 22, drive, BTF_NO_3D |
				BTF_NO_TOGGLE, WOF_NO_FLAGS, ChangeDrive, 0, bitmapName);
		}
	}
	setdisk(currentDrive);
#endif

}

EVENT_TYPE FILE_WINDOW::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case OPTION_OK:
		{
		// Get full path name for file.
		char path[128];
		strcpy(path, name->DataGet());

		if (!*path || strchr(path, '*') || strchr(path, '?'))
			break;

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		if (!strchr(path, '.'))
			UI_STORAGE::ChangeExtension(path, ".DAT");

		// Check for valid file.
		if (((option == FILE_NEW || option == FILE_SAVE_AS) && !UI_STORAGE::ValidName(path, TRUE)) ||
			((option == FILE_OPEN || option == FILE_DELETE) && !UI_STORAGE::ValidName(path, FALSE)))
		{
			DIALOG_WINDOW dialog("Error!", "ASTERISK", DIF_OK,
				"Invalid file name:\r\n\r\n%s", path);
			dialog.Responce();
			break;
		}

		if (option == FILE_NEW || option == FILE_SAVE_AS)
		{
			// Test if file already exists.
			UI_STORAGE tempStorage(path, UIS_READ);
			if (!tempStorage.storageError)
			{
				// Warn user before overwriting file.
				char *title;
				if (option == FILE_NEW)
					title = "New";
				else
					title = "Save As";
				DIALOG_WINDOW dialog(title, "QUESTION", DIF_YES | DIF_NO,
					"File %s already exists.\r\n\r\nOverwrite it?", path);
				if (dialog.Responce() != DIALOG_YES)
					break;
			}
		}

		// Perform the action.
		if (option == FILE_NEW)
		{
			// Create a new storage file.
			UI_STORAGE *oldStorage = _storage;
			_storage = new UI_STORAGE(path, UIS_READWRITE | UIS_CREATE);
			if (!_storage->storageError)
			{
				delete oldStorage;
				_storage->MkDir("UIW_WINDOW");
				_storage->MkDir("UI_BITMAP");
				_storage->MkDir("UI_ICON");
				_storage->MkDir("UI_HELP");
				_storage->MkDir("UI_HPP");
				_controlWindow->SetTitle();
				_saveNeeded = FALSE;
			}
			else
			{
				DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
						"Error creating file.");
				dialog.Responce();
				delete _storage;
				_storage = oldStorage;
				break;
			}
		}
		else if (option == FILE_OPEN)
		{
			// Open the storage file.
			UI_STORAGE *oldStorage = _storage;
			_storage = new UI_STORAGE(path, UIS_READWRITE);
			if (!_storage->storageError)
			{
				delete oldStorage;
				_controlWindow->SetTitle();
				_saveNeeded = FALSE;
			}
			else
			{
				DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
						"Error reading file.");
				dialog.Responce();
				delete _storage;
				_storage = oldStorage;
				break;
			}
		}
		else if (option == FILE_SAVE_AS)
		{
			SaveFile(path);
			_controlWindow->SetTitle();
		}
		else if (option == FILE_DELETE)
		{
			// Don't delete if file is active.
			char currentPath[128];
			_storage->StorageName(currentPath);
			char designerPath[128];
			UI_WINDOW_OBJECT::defaultStorage->StorageName(designerPath);
			if (!stricmp(path, currentPath) && !stricmp(path, designerPath))
			{
				DIALOG_WINDOW dialog("Error!", "EXCLAMATION", DIF_OK,
					"Can't delete active file!");
				dialog.Responce();
				break;
			}

			// Warn user before deleting file.
			DIALOG_WINDOW dialog("Delete File", "EXCLAMATION", DIF_OK | DIF_CANCEL,
				"%s\r\n\r\nThis file will be deleted", path);
			if (dialog.Responce() == DIALOG_OK)
				remove(path);
			else
				break;
		}
		eventManager->Put(UI_EVENT(S_CLOSE), Q_BEGIN);
		}
		break;

	case OPTION_CANCEL:
		eventManager->Put(UI_EVENT(S_CLOSE));
		break;

	case OPTION_HELP:
		helpSystem->DisplayHelp(windowManager, helpContext);
		break;

	case FILE_SET_NAME:
		name->Information(SET_TEXT, event.data);
		break;

	case S_INITIALIZE:
	case FILE_CHANGE_PATH:
	case FILE_CHANGE_DRIVE:
	case FILE_CHANGE_DIRECTORY:
#ifdef __ZTC__
		{
		unsigned currentDrive;
		unsigned temp;
		dos_getdrive(&currentDrive);
		if (ccode == FILE_CHANGE_DRIVE)
		{
			dos_setdrive(*((char *)event.data) - 'a' + 1, &temp);
			dos_getdrive(&temp);
			if (temp == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);
		else if (ccode == FILE_CHANGE_PATH)
		{
			char path[128];
			char file[128];
		 	UI_STORAGE::StripFullPath((char *)event.data, path, file);
			if (strchr(path, ':') == path + 1)
			{
				dos_setdrive(path[0] - 'A' + 1, &temp);
				dos_getdrive(&temp);
				if (temp - 1 != path[0] - 'A')
					break;
				chdir(path + 2);
			}
			if (*file)
				name->DataSet(file);
			else
				name->DataSet("*.DAT");
		}

		// Get the current path.
		char pathName[128];
		if (!getcwd(pathName, 128))
		{
			dos_setdrive(currentDrive, &temp);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		struct FIND *fileBlock;
		fileBlock = findfirst("*.*", FA_DIREC);
		while (fileBlock)
		{
			if (fileBlock->attribute == FA_DIREC &&
				strcmp(".", fileBlock->name) &&
				strcmp("..", fileBlock->name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock->name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			fileBlock = findnext();
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.DAT";

		fileBlock = findfirst(matchName, FA_DIREC);
		while (fileBlock)
		{
			if (fileBlock->attribute != FA_DIREC)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock->name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			fileBlock = findnext();
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
#ifdef _MSC_VER
		{
		unsigned currentDrive;
		unsigned temp;
		_dos_getdrive(&currentDrive);
		if (ccode == FILE_CHANGE_DRIVE)
		{
			_dos_setdrive(*((char *)event.data) - 'a' + 1, &temp);
			_dos_getdrive(&temp);
			if (temp == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);
		else if (ccode == FILE_CHANGE_PATH)
		{
			char path[128];
			char file[128];
		 	UI_STORAGE::StripFullPath((char *)event.data, path, file);
			if (strchr(path, ':') == path + 1)
			{
				_dos_setdrive(path[0] - 'A' + 1, &temp);
				_dos_getdrive(&temp);
				if (temp - 1 != path[0] - 'A')
					break;
				chdir(path + 2);
			}
			if (*file)
				name->DataSet(file);
			else
				name->DataSet("*.DAT");
		}

		// Get the current path.
		char pathName[128];
		if (!getcwd(pathName, 128))
		{
			_dos_setdrive(currentDrive, &temp);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		struct _find_t fileBlock;
		int empty = _dos_findfirst("*.*", _A_SUBDIR, &fileBlock);
		while (!empty)
		{
			if (fileBlock.attrib == _A_SUBDIR &&
				strcmp(".", fileBlock.name) &&
				strcmp("..", fileBlock.name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock.name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			empty = _dos_findnext(&fileBlock);
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.DAT";

		empty = _dos_findfirst(matchName, _A_SUBDIR, &fileBlock);
		while (!empty)
		{
			if (fileBlock.attrib != _A_SUBDIR)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock.name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			empty = _dos_findnext(&fileBlock);
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		{
		int currentDrive = getdisk();
		if (ccode == FILE_CHANGE_DRIVE)
		{
			setdisk(*((char *)event.data) - 'a');
			if (getdisk() == currentDrive)
				break;
		}
		else if (ccode == FILE_CHANGE_DIRECTORY)
			chdir((char *)event.data);
		else if (ccode == FILE_CHANGE_PATH)
		{
			char path[128];
			char file[128];
		 	UI_STORAGE::StripFullPath((char *)event.data, path, file);
			if (strchr(path, ':') == path + 1)
			{
				setdisk(path[0] - 'A');
				if (getdisk() != path[0] - 'A')
					break;
				chdir(path + 2);
			}
			if (*file)
				name->DataSet(file);
			else
				name->DataSet("*.DAT");
		}

		// Get the current path.
		char pathName[128];
		_dosError = FALSE;
		do
		{
			getcwd(pathName, 128);
		}
		while (_dosError && GetErrorResponce() == DIALOG_RETRY);
	    if (_dosError)
		{
			setdisk(currentDrive);
			break;
		}

		// Display a wait signal.
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		strlwr(pathName);
		directory->Information(SET_TEXT, pathName);

		// Get the files and directories.
		directories->Destroy();
		files->Destroy();

		// Get the current directory.
		int indentation = 0;
		if (strrchr(pathName, ':')[2] != '\0')
			*directories + new UIW_BUTTON(indentation++, 0, 22, "..",
				BTF_NO_3D | BTF_NO_TOGGLE | BTF_DOUBLE_CLICK, WOF_NO_FLAGS,
				ChangeDirectory, 0, "parentDirectory");

		// Get the sub-directories and files.
		int empty;
		struct ffblk fileBlock;
		_dosError = FALSE;
		do
		{
			empty = findfirst("*.*", &fileBlock, FA_DIREC);
		} while (_dosError && GetErrorResponce() == DIALOG_RETRY);
		if (_dosError)
			return S_ERROR;
		while (!empty)
		{
			if (fileBlock.ff_attrib == FA_DIREC &&
				strcmp(".", fileBlock.ff_name) &&
				strcmp("..", fileBlock.ff_name))
				*directories + new UIW_BUTTON(indentation, 0, 22,
					strlwr(fileBlock.ff_name), BTF_NO_3D | BTF_NO_TOGGLE |
					BTF_DOUBLE_CLICK, WOF_NO_FLAGS, ChangeDirectory, 0,
					"childDirectory");
			_dosError = FALSE;
			do
			{
				empty = findnext(&fileBlock);
			} while (_dosError && GetErrorResponce() == DIALOG_RETRY);
			if (_dosError)
				return S_ERROR;
		}
		char *matchName = name->DataGet();
		if (!strchr(matchName, '*') && !strchr(matchName, '?'))
			matchName = "*.DAT";

		_dosError = FALSE;
		do
		{
			empty = findfirst(matchName, &fileBlock, FA_DIREC);
		} while (_dosError && GetErrorResponce() == DIALOG_RETRY);
		if (_dosError)
			return S_ERROR;

		while (!empty)
		{
			if (fileBlock.ff_attrib != FA_DIREC)
				*files + new UIW_STRING(0, 0, 22, strlwr(fileBlock.ff_name),
					-1, STF_NO_FLAGS, WOF_NO_FLAGS, SelectFile);
			_dosError = FALSE;
			do
			{
				empty = findnext(&fileBlock);
			} while (_dosError && GetErrorResponce() == DIALOG_RETRY);
			if (_dosError)
				return S_ERROR;
		}
		if (ccode == S_INITIALIZE)
			ccode = UIW_WINDOW::Event(event);
		else
		{
			directories->Event(UI_EVENT(S_REDISPLAY));
			files->Event(UI_EVENT(S_REDISPLAY));
		}
		}
#endif
		break;

	case S_CREATE:
		ccode = UIW_WINDOW::Event(event);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		helpBar->Update(Current());
		break;
	 }

	// Return the control code.
	eventManager->DeviceState(E_MOUSE, DM_VIEW);
	return (ccode);
}
