//	Zinc Interface Library Designer - D_IMAGE.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
#include <mem.h>
#endif
#include <stdlib.h>
#include <string.h>
#include "ui_dsn.hpp"
#pragma hdrstop

BITMAP_EDITOR::BITMAP_EDITOR(OBJECTID _imageID) :
	UIW_WINDOW("IMAGE_EDITOR", defaultStorage), imageID(_imageID), imageName(NULL),
	bitmapArray(NULL), bitmapWidth(32), bitmapHeight(32)
{
	*this
		+ (colorBitmap = new UIW_BITMAP(4, 1, "colors", ID_COLOR_BITMAP, 24, 24))
		+ (screenBitmap = new UIW_BITMAP(54, 6, NULL, ID_SCREEN_BITMAP, 40, 10))
		+ (leftColor = new UIW_BITMAP(54, 8, NULL, ID_LEFT_BITMAP, 19, 10))
		+ (rightColor = new UIW_BITMAP(57, 8, NULL, ID_RIGHT_BITMAP, 19, 10));

	colorBitmap->leftObject = leftColor;
	colorBitmap->rightObject = rightColor;
	screenBitmap->leftObject = leftColor;
	screenBitmap->rightObject = rightColor;

	LoadImage();
}

EVENT_TYPE BITMAP_EDITOR::Event(const UI_EVENT &event)
{
	// Switch on the type of event.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case OPTION_NEW:
	case OPTION_LOAD:
	case OPTION_SAVE_AS:
	case OPTION_DELETE:
		*windowManager + new IMAGE_WINDOW(ccode, this);
		break;

	case OPTION_EXIT:
		eventManager->Put(UI_EVENT(S_CLOSE));
		break;

	case OPTION_SAVE:
		if (!imageName)
		{
			eventManager->Put(UI_EVENT(OPTION_SAVE_AS));
			break;
		}
		if (imageID == ID_BITMAP_IMAGE)
			_storage->ChDir("~UI_BITMAP");
		else
			_storage->ChDir("~UI_ICON");
		{
			UI_STORAGE_OBJECT sObject(*_storage, imageName, imageID,
				UIS_READWRITE | UIS_CREATE);
			if (!sObject.objectError)
			{
				sObject.Store((USHORT)bitmapWidth);
				sObject.Store((USHORT)bitmapHeight);
				sObject.Store(bitmapArray, bitmapWidth, bitmapHeight);
				_saveNeeded = TRUE;
			}
		}
		break;

	case IMAGE_PENCIL:
	case IMAGE_BRUSH:
	case IMAGE_LINE:
	case IMAGE_RECTANGLE:
	case IMAGE_FILL_RECTANGLE:
	case IMAGE_ELLIPSE:
	case IMAGE_FILL_ELLIPSE:
	case IMAGE_FILL:
		editBitmap->Event(event);
		break;


	default:
		ccode = UIW_WINDOW::Event(event);
	}
	return ccode;
}

void BITMAP_EDITOR::LoadImage(void)
{
	if (bitmapArray)
	{
		delete bitmapArray;
		*this - editBitmap;
		delete editBitmap;
		*this - viewBitmap;
		delete viewBitmap;
		bitmapArray = NULL;
	}
	if (imageName)
	{
		if (imageID == ID_BITMAP_IMAGE)
			_storage->ChDir("~UI_BITMAP");
		else
			_storage->ChDir("~UI_ICON");
		UI_STORAGE_OBJECT sObject(*_storage, imageName, imageID, UIS_READ);
		if (!sObject.objectError)
		{
			USHORT value;
			sObject.Load(&value); bitmapWidth = value;
			sObject.Load(&value); bitmapHeight = value;
			bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
			sObject.Load(bitmapArray, bitmapWidth, bitmapHeight);
		}
	}
	if (!bitmapArray)
	{
		bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
		memset(bitmapArray, 15, bitmapWidth * bitmapHeight);
	}
	int pixelSize = Min(192 / bitmapWidth, 192 / bitmapHeight);
	editBitmap = new UIW_BITMAP(19, 1, NULL, ID_EDIT_BITMAP, pixelSize, pixelSize);
	viewBitmap = new UIW_BITMAP(54, 1, NULL, ID_VIEW_BITMAP, 1, 1);
	editBitmap->Information(SET_BITMAP_WIDTH, &bitmapWidth);
	editBitmap->Information(SET_BITMAP_HEIGHT, &bitmapHeight);
	editBitmap->Information(SET_BITMAP_ARRAY, bitmapArray);
	viewBitmap->Information(SET_BITMAP_WIDTH, &bitmapWidth);
	viewBitmap->Information(SET_BITMAP_HEIGHT, &bitmapHeight);
	viewBitmap->Information(SET_BITMAP_ARRAY, bitmapArray);
	editBitmap->viewObject = viewBitmap;
	viewBitmap->editObject = editBitmap;
	viewBitmap->screenObject = screenBitmap;
	*this
		+ editBitmap
		+ viewBitmap;
}


