//	Zinc Interface Library Designer - D_IMAGE1.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
#include <mem.h>
#endif
#include <string.h>
#include "ui_dsn.hpp"
#pragma hdrstop

EVENT_TYPE ImageNameFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (object->LogicalEvent(event, ID_WINDOW_OBJECT) == L_SELECT)
		object->eventManager->Put(UI_EVENT(OPTION_OK));
	return (ccode);
}

static EVENT_TYPE ImageSelect(UI_WINDOW_OBJECT *object,	UI_EVENT &event,
	EVENT_TYPE ccode)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;

	if (!initializedTime)
	{
		lastTime.Import();
		lastTime -= 100;
		initializedTime = TRUE;
	}

	if (ccode == L_SELECT)
	{
		UI_TIME currentTime;
		if (event.type == E_KEY || (currentTime - lastTime <
			object->doubleClickRate))
		{
			event.type = OPTION_OK;
			object->eventManager->Put(event);
		}
		else
		{
			event.type = IMAGE_SELECT;
			object->Information(GET_TEXT, &event.data);
			object->eventManager->Put(event);
			lastTime = currentTime;
		}
	}
	return (ccode);
}

EVENT_TYPE TypeSelect(UI_WINDOW_OBJECT *object, UI_EVENT &event, EVENT_TYPE ccode)
{
	if (ccode == L_SELECT)
	{
		event.type = IMAGE_LIST;
		event.rawCode = ((UIW_BUTTON *)object)->value;
		UI_WINDOW_OBJECT *imageEditor = object->windowManager->Get("IMAGE_WINDOW");
		if (imageEditor)
			imageEditor->Event(event);
	}
	return (ccode);
}

IMAGE_WINDOW::IMAGE_WINDOW(USER_EVENT _mode, BITMAP_EDITOR *_editor) :
	UIW_WINDOW("IMAGE_WINDOW", defaultStorage), editor(_editor), mode(_mode),
		imageID(_editor->imageID)
{
	char *title;
	if (mode == OPTION_NEW)
		title = "New";
	else if (mode == OPTION_LOAD)
		title = "Load";
	else if (mode == OPTION_SAVE_AS)
		title = "Save As";
	else if (mode == OPTION_DELETE)
		title = "Delete";
	((UIW_TITLE *)Information(GET_STRINGID_OBJECT, "NUMID_TITLE"))->Information(SET_TEXT, title);

	typeField = (UIW_COMBO_BOX *)Information(GET_STRINGID_OBJECT, "TYPE_COMBO");
	nameField = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "NAME_FIELD");
	widthField = (UIW_INTEGER *)Information(GET_STRINGID_OBJECT, "WIDTH_FIELD");
	heightField = (UIW_INTEGER *)Information(GET_STRINGID_OBJECT, "HEIGHT_FIELD");
	imageMatrix = (UIW_HZ_LIST *)Information(GET_STRINGID_OBJECT, "IMAGE_LIST");
	helpBar = (HELP_BAR *)Information(GET_STRINGID_OBJECT, "HELP_BAR");

	if (imageID == ID_ICON_IMAGE)
		typeField->UIW_WINDOW::Get("ICON_OPTION")->woStatus |= WOS_SELECTED | WOS_CURRENT;

	if (mode == OPTION_SAVE_AS && (editor->bitmapWidth != 32 ||
		editor->bitmapHeight != 32))
	{
	 	typeField->woFlags |= WOF_NON_SELECTABLE;
	}

	char *name = (mode == OPTION_SAVE_AS) ? editor->imageName : NULL;
	nameField->DataSet(name);

	UI_EVENT tEvent;
	tEvent.type = IMAGE_LIST;
	tEvent.rawCode = imageID;
	eventManager->Put(tEvent);
}


EVENT_TYPE IMAGE_WINDOW::Event(const UI_EVENT &event)
{
	// Switch on the type of event.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case IMAGE_SELECT:
		nameField->Information(SET_TEXT, event.data);
		break;

	case IMAGE_LIST:
		{
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		imageID = event.rawCode;
		editor->imageID = event.rawCode;
		imageMatrix->Destroy();
		if (imageID == ID_BITMAP_IMAGE)
		{
			if (mode == OPTION_NEW)
			{
				widthField->woFlags &= ~WOF_NON_SELECTABLE;
				heightField->woFlags &= ~WOF_NON_SELECTABLE;
			}
			else
			{
				widthField->woFlags |= WOF_NON_SELECTABLE;
				heightField->woFlags |= WOF_NON_SELECTABLE;
			}
			widthField->DataSet(&editor->bitmapWidth);
			heightField->DataSet(&editor->bitmapWidth);
			_storage->ChDir("~UI_BITMAP");
		}
		else
		{
			widthField->woFlags |= WOF_NON_SELECTABLE;
			heightField->woFlags |= WOF_NON_SELECTABLE;
			int widthHeight = 32;
			widthField->DataSet(&widthHeight);
			heightField->DataSet(&widthHeight);
			_storage->ChDir("~UI_ICON");
		}
		char *objectName = _storage->FindFirstObject("*");
		while (objectName)
		{
			if (objectName[0] != '.')
			{
				UIW_BUTTON *button = new UIW_BUTTON(0, 0, 30, objectName,
					BTF_AUTO_SIZE | BTF_NO_3D, WOF_BORDER, ImageSelect);
				if (imageID == ID_BITMAP_IMAGE)
					_storage->ChDir("~UI_BITMAP");
				else
					_storage->ChDir("~UI_ICON");
				if (FlagSet(_config->options, OPTION_MENU_BITMAPS))
				{
					UI_STORAGE_OBJECT sObject(*_storage, objectName, imageID, UIS_READ);
					USHORT bitmapWidth;
					USHORT bitmapHeight;
					sObject.Load(&bitmapWidth);
					sObject.Load(&bitmapHeight);
					UCHAR *bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
					sObject.Load(bitmapArray, bitmapWidth, bitmapHeight);
					button->Information(SET_BITMAP_WIDTH, &bitmapWidth);
					button->Information(SET_BITMAP_HEIGHT, &bitmapHeight);
					button->Information(SET_BITMAP_ARRAY, bitmapArray);
					delete bitmapArray;
				}
				*imageMatrix + button;
			}
			if (imageID == ID_BITMAP_IMAGE)
				_storage->ChDir("~UI_BITMAP");
			else
				_storage->ChDir("~UI_ICON");
			objectName = _storage->FindNextObject();
		}
		if (!imageMatrix->First())
			*imageMatrix + new UIW_STRING(0, 0, 30, "(None)");
		imageMatrix->Event(UI_EVENT(S_REDISPLAY));
		eventManager->DeviceState(E_MOUSE, DM_VIEW);
		}
		break;

	case OPTION_OK:
		{
		// Change to image directory.
		if (imageID == ID_BITMAP_IMAGE)
			_storage->ChDir("~UI_BITMAP");
		else
			_storage->ChDir("~UI_ICON");

		// Get image name;
		char *name = nameField->DataGet();
		if (name && *name == '\0')
			name = NULL;

		// Test for valid name.
		if (name)
		{
			char *title = (char *)Information(GET_TEXT, NULL);
			char *objectName = _storage->FindFirstObject(name);
			if (objectName && (mode == OPTION_NEW || mode == OPTION_SAVE_AS))
			{
				DIALOG_WINDOW dialog(title, "QUESTION", DIF_YES | DIF_NO,
					"Image %s already exists.\r\n\r\nOverwrite it?", name);
				if (dialog.Responce() != DIALOG_YES)
					break;
			}
			else if (!objectName && (mode == OPTION_LOAD || mode == OPTION_DELETE))
			{
				DIALOG_WINDOW dialog(title, "ASTERISK", DIF_OK,
					"%s\r\n\r\n Image not found!", name);
				dialog.Responce();
				break;
			}
		}
		else if (mode != OPTION_NEW)
		{
			errorSystem->Beep();
			break;
		}

		// Perform Action.
		if (mode == OPTION_NEW)
		{
			editor->imageID = imageID;
			ReplaceString(&editor->imageName, name);
			editor->bitmapWidth = widthField->DataGet();
			editor->bitmapHeight = heightField->DataGet();
			editor->LoadImage();
			editor->Event(UI_EVENT(S_REDISPLAY));
		}
		else if (mode == OPTION_LOAD)
		{
			editor->imageID = imageID;
			ReplaceString(&editor->imageName, name);
			editor->LoadImage();
			editor->Event(UI_EVENT(S_REDISPLAY));
		}
		else if (mode == OPTION_SAVE_AS)
		{
			ReplaceString(&editor->imageName, name);
			eventManager->Put(UI_EVENT(OPTION_SAVE));
		}
		else if (mode == OPTION_DELETE)
		{
			DIALOG_WINDOW dialog("Delete", "EXCLAMATION", DIF_OK | DIF_CANCEL,
				"%s\r\n\r\nThis image will be deleted.", name);
			if (dialog.Responce() == DIALOG_OK)
			{
				_storage->ChDir("~UI_BITMAP");
				_storage->DestroyObject(name);
				_saveNeeded = TRUE;
			}
		}
		eventManager->Put(UI_EVENT(S_CLOSE), Q_BEGIN);
		}
		break;

	case OPTION_CANCEL:
		eventManager->Put(UI_EVENT(S_CLOSE));
		break;

	case OPTION_HELP:
		helpSystem->DisplayHelp(windowManager, helpContext);
		break;

	case S_INITIALIZE:
	case S_CREATE:
		ccode = UIW_WINDOW::Event(event);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		helpBar->Update(Current());
		break;
	}
	return ccode;
}
