//	Zinc Interface Library Designer - D_MEMERR.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdlib.h>
#include <string.h>
#include "ui_dsn.hpp"
#pragma hdrstop

#if defined(__ZTC__)
void NewHandler(void)
#endif
#if defined(_MSC_VER)
int NewHandler(size_t size)
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
void NewHandler(void)
#endif
{
	delete _errorMemory;
	_errorSystem->Beep();
	char path[128];
	char file[128];
	_storage->StorageName(path);
	_storage->StripFullPath(path, NULL, file, NULL);
	if (!strcmp(file, "UNTITLED.DAT"))
		strcpy(path, "(Untitled)");
	DIALOG_WINDOW dialog("Memory Error!", NULL, DIF_YES | DIF_NO,
		"Out of memory!\r\n\r\nZinc designer will terminate.\r\n\r\nSave file %s before termination?",
		path);
	if (dialog.Responce() == DIALOG_YES)
	{
		UI_WINDOW_OBJECT *object = UI_WINDOW_OBJECT::windowManager->First();
		while (object)
		{
			UI_WINDOW_OBJECT *tObject = object->Next();
			if (!FlagSet(object->woStatus, WOS_EDIT_MODE))
			{
				*UI_WINDOW_OBJECT::windowManager - object;
				delete object;
			}
			object = tObject;
		}
		SaveFile(NULL, TRUE);
	}

	// Emergency clean up and exit.
	UI_EVENT_MANAGER *eventManager = UI_WINDOW_OBJECT::eventManager;
	UI_DISPLAY *display = UI_WINDOW_OBJECT::display;
	delete UI_WINDOW_OBJECT::windowManager;
	delete eventManager;
	delete display;
#ifndef _WINDOWS
	delete UI_STORAGE::searchPath;
#endif
	exit(0);
}
