//	Zinc Interface Library Designer - D_RESRC.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include "ui_dsn.hpp"
#pragma hdrstop

EVENT_TYPE ResourceNameFunction(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	if (object->LogicalEvent(event, ID_WINDOW_OBJECT) == L_SELECT)
		object->eventManager->Put(UI_EVENT(OPTION_OK));
	return (ccode);
}

static EVENT_TYPE ResourceSelect(UI_WINDOW_OBJECT *object,
	UI_EVENT &event, EVENT_TYPE ccode)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;

	if (!initializedTime)
	{
		lastTime.Import();
		lastTime -= 100;
		initializedTime = TRUE;
	}

	if (ccode == L_SELECT)
	{
		UI_TIME currentTime;
		if (event.type == E_KEY || (currentTime - lastTime <
			object->doubleClickRate))
		{
			event.type = OPTION_OK;
			object->eventManager->Put(event);
		}
		else
		{
			event.type = RESOURCE_SELECT;
			object->Information(GET_TEXT, &event.data);
			object->eventManager->Put(event);
			lastTime = currentTime;
		}
	}
	return (ccode);
}

RESOURCE_WINDOW::RESOURCE_WINDOW(EVENT_TYPE ccode, UI_WINDOW_OBJECT *_resource) :
	UIW_WINDOW(display->isText ? "RESOURCE_WINDOW_TEXT" : "RESOURCE_WINDOW",
		defaultStorage), option(ccode), currentResource(_resource)
{
	Center(this);

	char *title;
	if (option == RESOURCE_LOAD)
		title = "Load Resource";
	else if (option == RESOURCE_STORE_AS)
		title = "Store Resource";
	else
		title = "Delete Resource";

	((UIW_TITLE *)Information(GET_STRINGID_OBJECT, "NUMID_TITLE"))->Information(SET_TEXT, title);
	nameField = (UIW_STRING *)Information(GET_STRINGID_OBJECT, "NAME_FIELD");
	helpBar = (HELP_BAR *)Information(GET_STRINGID_OBJECT, "HELP_BAR");
	if (currentResource)
		nameField->DataSet(currentResource->StringID());
	UIW_HZ_LIST *resourceMatrix = (UIW_HZ_LIST *)Information(GET_STRINGID_OBJECT, "RESOURCE_LIST");

	_storage->ChDir("~UIW_WINDOW");
	char *objectName = _storage->FindFirstObject("*");
	while (objectName)
	{
		if (objectName[0] != '.')
		{
			*resourceMatrix
				+ new UIW_BUTTON(0, 0, 35, objectName,
					BTF_NO_TOGGLE | BTF_NO_3D, WOF_NO_FLAGS, ResourceSelect,
					RESOURCE_LOAD);
		}
		objectName = _storage->FindNextObject();
	}
	if (!resourceMatrix->First())
		*resourceMatrix	+ new UIW_STRING(0, 0, 35, "(None)");
}


EVENT_TYPE RESOURCE_WINDOW::Event(const UI_EVENT &event)
{
	// Switch on the type of event.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case RESOURCE_SELECT:
		nameField->Information(SET_TEXT, event.data);
		break;

	case OPTION_OK:
		{
		char *name = nameField->DataGet();
		if (name && *name == '\0')
		{
			errorSystem->Beep();
			break;
		}
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		_storage->ChDir("~UIW_WINDOW");
		if (option == RESOURCE_LOAD)
		{
			UI_WINDOW_OBJECT *resource = resource = windowManager->Get(name);
			if (!resource || resource->parent || !FlagSet(resource->woStatus, WOS_EDIT_MODE))
			{
				if (_storage->FindFirstObject(name))
				{
					UI_WINDOW_OBJECT::defaultStatus |= WOS_EDIT_MODE;
					resource = new UIW_WINDOW(name, _storage);
					UI_WINDOW_OBJECT::defaultStatus &= ~WOS_EDIT_MODE;
					resource->userFlags = resource->woAdvancedFlags;
					resource->woAdvancedFlags = WOAF_LOCKED;
				}
				else
				{
					DIALOG_WINDOW dialog("Load", "ASTERISK", DIF_OK,
						"%s\r\n\r\nResource not found.", name);
					dialog.Responce();
					eventManager->DeviceState(E_MOUSE, DM_VIEW);
					break;
				}
			}
			UI_EVENT tEvent;
			tEvent.type = RESOURCE_ADD;
			tEvent.data = resource;
			eventManager->Put(tEvent);
		}
		else if (option == RESOURCE_STORE_AS)
		{
			if (_storage->FindFirstObject(name))
			{
				DIALOG_WINDOW dialog("Load", "QUESTION", DIF_YES | DIF_NO,
					"Resource %s already exists.\r\n\r\nOverwrite?", name);
				if (dialog.Responce() != DIALOG_YES)
				{
					eventManager->DeviceState(E_MOUSE, DM_VIEW);
					break;
				}
			}
			currentResource->StringID(name);
			currentResource->woAdvancedFlags = currentResource->userFlags;
			currentResource->Store(currentResource->StringID(), _storage);
			_saveNeeded = TRUE;
			UI_EVENT tEvent;
			tEvent.type = RESOURCE_ADD;
			tEvent.data = currentResource;
		}
		else
		{
			if (_storage->FindFirstObject(name))
			{
				DIALOG_WINDOW dialog("Delete Resource", "EXCLAMATION", DIF_OK | DIF_CANCEL,
					"%s\r\n\r\nThis resource will be deleted.", name);
				if (dialog.Responce() == DIALOG_OK)
				{
					_storage->DestroyObject(name);
					_storage->ChDir("~UI_HPP");
					_storage->DestroyObject(name);
					_storage->ChDir("~UI_CPP");
					_storage->ChDir(name);
					_storage->DestroyObject("OBJECTID");
					_storage->DestroyObject("COMPARE_FUNCTION");
					_storage->DestroyObject("USER_FUNCTION");
					_storage->ChDir("..");
					_storage->RmDir(name);
					_saveNeeded = TRUE;
				}
				else
				{
					eventManager->DeviceState(E_MOUSE, DM_VIEW);
					break;
				}
			}
			else
			{
				DIALOG_WINDOW dialog("Delete", "ASTERISK", DIF_OK,
					"%s\r\n\r\nResource not found.", name);
				dialog.Responce();
				eventManager->DeviceState(E_MOUSE, DM_VIEW);
				break;
			}
		}
		eventManager->Put(UI_EVENT(S_CLOSE), Q_BEGIN);
		eventManager->DeviceState(E_MOUSE, DM_VIEW);
		}
		break;

	case OPTION_CANCEL:
		eventManager->Put(UI_EVENT(S_CLOSE));
		break;

	case OPTION_HELP:
		helpSystem->DisplayHelp(windowManager, helpContext);
		break;

 	case S_INITIALIZE:
	case S_CREATE:
		ccode = UIW_WINDOW::Event(event);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		helpBar->Update(Current());
		break;
	}
	return ccode;
}
