//	Zinc Interface Library - GROUP.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_WINDOW ---------------------------------------------------------

UIW_GROUP::UIW_GROUP(int left, int top, int width, int height, char *_text,
	WNF_FLAGS _wnFlags, WOF_FLAGS _woFlags) :
	UIW_WINDOW(left, top, width, height, _woFlags), text(NULL)
{
	// Initialize the group information.
	wnFlags |= _wnFlags;
	DataSet(_text);
	UIW_GROUP::Information(INITIALIZE_CLASS, NULL);
}

UIW_GROUP::~UIW_GROUP(void)
{
	if (text)
		delete text;
}

char *UIW_GROUP::DataGet(void)
{
	return (text);
}

void UIW_GROUP::DataSet(char *_text)
{
	if (text && text != _text && !FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		delete text;
	if (FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		text = _text;
	else
		text = ui_strdup(_text);

	// Check for a hotkey.
	if (text)
	{
		ui_strrepc(text, '~', '&');
		char *tHotKey = strchr(text, '&');
		hotKey = tHotKey ? tolower(tHotKey[1]) : HOT_KEY_SUB_WINDOW;
	}
	else
		hotKey = HOT_KEY_SUB_WINDOW;

	if (screenID)
	{
#ifdef _WINDOWS
		InvalidateRect(screenID, NULL, TRUE);
		SendMessage(screenID, WM_SETTEXT, 0, (LONG)text);
#endif
	}
}

#ifdef _WINDOWS
static int _groupOffset = -1;
static FARPROC _groupCallback = (FARPROC)DefWindowProc;
static FARPROC _groupJumpInstance = NULL;

long FAR PASCAL _export GroupJumpProcedure(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	UIW_GROUP *object = (UIW_GROUP *)GetWindowLong(hWnd, _groupOffset);
	return (object->Event(UI_EVENT(E_MSWINDOWS, hWnd, wMsg, wParam, lParam)));
}

EVENT_TYPE UIW_GROUP::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_GROUP);
	switch (ccode)
	{
	case S_INITIALIZE:
		if (!_groupJumpInstance)
			_groupJumpInstance = (FARPROC)GroupJumpProcedure;
		UIW_WINDOW::Event(event);
		break;

	case S_CREATE:
		{
		UI_WINDOW_OBJECT::Event(event);
		RegisterObject("UIW_GROUP", "BUTTON", &_groupOffset,
			&_groupJumpInstance, &_groupCallback, text);
		// Compute the list object regions.
		int deltaY = display->cellHeight / 4;
		for (object = First(); object; object = object->Next())
		{
			UI_REGION region = object->relative;
			object->relative.top -= deltaY;
			object->relative.bottom -= deltaY;
			object->Event(event);
			object->relative = region;
		}
		}
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_UP:
	case L_DOWN:
	case L_LEFT:
	case L_RIGHT:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_LEFT || ccode == L_UP) ? L_PREVIOUS : L_NEXT));
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
EVENT_TYPE UIW_GROUP::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_GROUP);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		clipList.Destroy();
		if (display->isText)
			UIW_WINDOW::Event(event);
		else
		{
			// Compute the list object regions.
			UI_WINDOW_OBJECT::Event(event);
			int deltaY = display->cellHeight / 4;
			for (UI_WINDOW_OBJECT *object = First(); object; object = object->Next())
			{
				UI_REGION region = object->relative;
				object->relative.top -= deltaY;
				object->relative.bottom -= deltaY;
				object->Event(event);
				object->relative = region;
			}
		}
		break;

	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		{
		ccode = UIW_WINDOW::Event(event);
		int width = (text && text[0]) ?
			display->TextWidth(text, screenID, font) + 2 * display->cellWidth : 0;
		if (display->isText)
			display->Text(screenID, true.left + 1, true.top, text,
				lastPalette, -1, FALSE, FALSE, &clip);
		else
		{
			int polygon[12];
			polygon[10] = true.left + 2 * display->cellWidth;
			polygon[0] = polygon[10] + width;
			polygon[1] = polygon[3] = polygon[9] = polygon[11] = true.top + display->cellHeight / 2;
			polygon[2] = polygon[4] = true.right;
			polygon[5] = polygon[7] = true.bottom;
			polygon[6] = polygon[8] = true.left;
			UI_PALETTE *outline = LogicalPalette(ccode, ID_OUTLINE);
			if (text && text[0])
				display->Text(screenID, polygon[10] + display->cellWidth,
					true.top + display->cellHeight / 4, text, lastPalette, -1,
					FALSE, FALSE, &clip);
			display->Polygon(screenID, 6, polygon, outline, FALSE, FALSE, &clip);
		}
		}
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_UP:
	case L_DOWN:
	case L_LEFT:
	case L_RIGHT:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_LEFT || ccode == L_UP) ? L_PREVIOUS : L_NEXT));
		break;

	case L_SELECT:
		ccode = UIW_WINDOW::Event(UI_EVENT(L_SELECT));
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_GROUP::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_GROUP;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_GROUP;
		windowID[1] = ID_WINDOW;
		if (text)
		{
			ui_strrepc(text, '~', '&');
			char *tHotKey = strchr(text, '&');
			hotKey = tHotKey ? tolower(tHotKey[1]) : HOT_KEY_SUB_WINDOW;
		}
		else
			hotKey = HOT_KEY_SUB_WINDOW;
		// Continue to CHANGED_FLAGS.
	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (request == CHANGED_FLAGS)
			UIW_WINDOW::Information(CHANGED_FLAGS, data, ID_GROUP);
		dwStyle |= BS_GROUPBOX;
		if (screenID && request == CHANGED_FLAGS && objectID == ID_GROUP)
		{
			DestroyWindow(screenID);
			Event(UI_EVENT(S_CREATE));
			SetWindowPos(screenID, previous ? Previous()->screenID : 0,
				0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW);
		}
#endif
		break;

	case GET_TEXT:
		if (!data)
			return (DataGet());
		*(char **)data = DataGet();
		break;

	case SET_TEXT:
		DataSet((char *)data);
		break;

	default:
		data = UIW_WINDOW::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_GROUP::UIW_GROUP(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_WINDOW(0, 0, 7, 1, WOF_NO_FLAGS, WOAF_NO_FLAGS)
{
	// Initialize the group information.
	Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_WINDOW::Information(INITIALIZE_CLASS, NULL);
	UIW_GROUP::Information(INITIALIZE_CLASS, NULL);
}

void UIW_GROUP::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Load the group information.
	UIW_WINDOW::Load(name, directory, file);
	file->Load(&text);
}

void UIW_GROUP::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the group information.
	UIW_WINDOW::Store(name, directory, file);
	file->Store(text);
}
#endif

