//	Zinc Interface Library - G_PROC.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

#ifdef _WINDOWS
class MAKEPROC_ELEMENT : public UI_ELEMENT
{
public:
	HANDLE hInstance;
	FARPROC procInstance;
	char name[32];

	MAKEPROC_ELEMENT(char *_name, FARPROC _procInstance, HANDLE _hInstance) :
		procInstance(_procInstance), hInstance(_hInstance) { strcpy(name, _name); }
	~MAKEPROC_ELEMENT(void)
		{ FreeProcInstance(procInstance); UnregisterClass(name, hInstance); }
	MAKEPROC_ELEMENT *Next(void) { return((MAKEPROC_ELEMENT *)next); }
	MAKEPROC_ELEMENT *Previous(void) { return((MAKEPROC_ELEMENT *)previous); }
};

class MAKEPROC_LIST : public UI_LIST
{
public:
	MAKEPROC_ELEMENT *Current(void) { return((MAKEPROC_ELEMENT *)current); }
	MAKEPROC_ELEMENT *First(void) { return((MAKEPROC_ELEMENT *)first); }
	MAKEPROC_ELEMENT *Last(void) { return((MAKEPROC_ELEMENT *)last); }
};

static MAKEPROC_LIST _makeprocList;

int ZincClassInitialize(HANDLE)
{
	// Clean up the procedure instance list.
	_makeprocList.Destroy();
	return (TRUE);
}

int ZincClassRestore(HANDLE hInstance)
{
	// Clean up the procedure instance list.
	_makeprocList.Destroy();
	return (TRUE);
}

int ZincClassAdd(char *name, FARPROC farproc, HANDLE hInstance)
{
	// Make sure the element does not exist.
	for (MAKEPROC_ELEMENT *element = _makeprocList.First(); element; element = element->Next())
		if (element->hInstance == hInstance &&
			element->procInstance || farproc &&
			!stricmp(element->name, name))
			return (FALSE);

	// Add a procedure element
	_makeprocList.Add(new MAKEPROC_ELEMENT(name, farproc, hInstance));
	return (TRUE);
}
#endif
