//	Zinc Interface Library - KEYBRD.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdlib.h>
#if !defined(_Windows) & !defined(_WINDOWS)
#include <conio.h>
#endif
#include <signal.h>
#ifdef __ZTC__
#include <controlc.h>
#endif
#include "ui_evt.hpp"
#pragma hdrstop

// ----- UID_KEYBOARD -------------------------------------------------------

#ifdef _WINDOWS
UID_KEYBOARD::UID_KEYBOARD(DEVICE_STATE _state) :
	UI_DEVICE(E_KEY, _state)
{
	extern void z_keybrd_dummy(void);	// Bug fix for Zortech & Microsoft linkers.
	z_keybrd_dummy();

	installed = TRUE;
}

UID_KEYBOARD::~UID_KEYBOARD(void)
{
}

void UID_KEYBOARD::Poll(void)
{
}
#else

static int _enhancedBios = 0;		// 0 or 0x10 (keyboard read)
static int _oldBreakState = 0;

#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
static int CtrlCHandler(void)
#endif
#ifdef __ZTC__
static void _far _cdecl CtrlCHandler(void)
#endif
#ifdef _MSC_VER
static void __interrupt __far CtrlCHandler(void)
#endif
{
	if (UID_KEYBOARD::breakHandlerSet == 0)
		exit(1);
	UI_EVENT event;
	event.rawCode = 0;
	event.key.value = 0;
	event.key.shiftState = 0;
	event.type = UID_KEYBOARD::breakHandlerSet;
	UID_KEYBOARD::eventManager->Put(event, Q_END);
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	return 1;
#endif
}

UID_KEYBOARD::UID_KEYBOARD(DEVICE_STATE _state) :
	UI_DEVICE(E_KEY, _state)
{
	union REGS inregs, outregs;

	if (installed)
		return;

	// Initialize the keyboard device.
	installed = TRUE;

	// Check for enhanced keyboard BIOS according to the
	// IBM PS/2 Technical Reference manual, page 2-103
	// stuff a ff.ff pair into the buffer.
	inregs.x.ax = 0x05FF;
	inregs.x.cx = 0xFFFF;
	int86(0x16, &inregs, &outregs);
	if (outregs.h.al == 0x00) {	// success, carry on
		// Read that guy back ...
		inregs.x.ax = 0x1000;
		int86(0x16, &inregs, &outregs);
		if (outregs.x.ax == 0xFFFF)
			_enhancedBios = 0x10;
	}
	// Set break interupt to ignore Control-Break/Control-C.
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	ctrlbrk(CtrlCHandler);
#endif
#ifdef __ZTC__
	_controlc_handler = CtrlCHandler;
	controlc_open();
#endif
#ifdef _MSC_VER
	_dos_setvect(0x23, CtrlCHandler);
#endif
	// Save previous state of Control-Break using INT 21H, 00H.
	inregs.x.ax = 0x3300;
	int86(0x21, &inregs, &outregs);
	_oldBreakState = outregs.h.dl;

	// Set Control-Break ON using INT 21H, 01H.
	inregs.x.ax = 0x3301;
	inregs.h.dl = 0x01;
	int86(0x21, &inregs, &outregs);
}

UID_KEYBOARD::~UID_KEYBOARD(void)
{
	union REGS inregs, outregs;

	if (!installed)
		return;

	// ???? clean up the ctrl-c handler;

	// Set Control-Break status to previous status.
	inregs.x.ax = 0x3301;
	inregs.h.dl = _oldBreakState;
	int86(0x21, &inregs, &outregs);
	installed = FALSE;
}

void UID_KEYBOARD::Poll(void)
{
	union REGS inregs, outregs;

	// Make sure the keyboard is valid.
	if (!installed)
		return;

	// If no keystoke is waiting then check for the ALT key being pressed.
	if (!kbhit())
	{
		// Check for ALT key using INT 16H, 02H.
		inregs.h.ah = 0x02;
		int86(0x16, &inregs, &outregs);
		UCHAR shiftState = outregs.h.al;

		// Put L_ALT_KEY on queue if pressed and released alone.
		if (FlagSet(shiftState, S_ALT) && altState == ALT_NOT_PRESSED)
			altState = ALT_PRESSED_NO_EVENTS;
		else if (!FlagSet(shiftState, S_ALT))
		{
			if (altState == ALT_PRESSED_NO_EVENTS)
			{
				UI_EVENT event;
				event.rawCode = 0;
				event.key.value = 0;
				event.key.shiftState = 0;
				event.type = L_ALT_KEY;
				if (state != D_OFF)
					eventManager->Put(event, Q_END);
			}
			altState = ALT_NOT_PRESSED;
		}
		return;
	}

	// Set the key information and call the event manager.
	if (altState == ALT_PRESSED_NO_EVENTS)
		altState = ALT_PRESSED_EVENTS;

	// Get the key from the keyboard bios using INT 16H, 10H(or 00H if not enhanced).
	UI_EVENT event;
	event.type = E_KEY;
	inregs.h.ah = _enhancedBios;
	int86(0x16, &inregs, &outregs);
	event.rawCode = outregs.x.ax;
	event.key.value = outregs.h.al;

	// Get the shift state using INT 16H, 12H(or 02H if not enhanced).
	inregs.h.ah = 0x02 + _enhancedBios;
	int86(0x16, &inregs, &outregs);
	event.key.shiftState = outregs.h.al;

	// Place event on the queue.
	if (state != D_OFF && eventManager)
		eventManager->Put(event, Q_END);
}
#endif

EVENT_TYPE UID_KEYBOARD::Event(const UI_EVENT &event)
{
	// Switch on the rawCode.
	switch (event.type)
	{
	case D_OFF:
	case D_ON:
		state = event.type;
		break;
	}

	// Return the keyboard state.
	return (state);
}
