## Zinc Interface Library version 3.00 makefile
## ZIL.LIB, ZILW.LIB, ZILWD.DLL, ZILWD.LIB,
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Microsoft C++ 7.00

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
LIBRARIAN=lib
DOS_CPP_OPTS=-c -AL -BATCH -Gs -Fpzil.pch -nologo
DOS_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256 /STACK:5120 /EXE /FAR
DOS_LIB_OPTS=/NOI
WIN_CPP_OPTS=-c -AL -BATCH -Gsw -Fpzilw.pch -nologo -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256
WIN_LIB_OPTS=/NOI
WINDLL_CPP_OPTS=-c -AL -BATCH -Gsw -Fpzilwd.pch -nologo -DWINVER=0x0300 -D__DLL__
WINDLL_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256 /STACK:5120 /FAR /Ld
WINDLL_LIB_OPTS=/NOI
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames
WINDLL_OBJS=
WINDLL_LIBS=libw llibcew oldnames


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) -Yu $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -Yu -Fo$*.obw $<

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -Yu -Fo$*.obd $<

.rc.res:
	rc -r $<


lib: zil.lib zilw.lib


zil.lib: zil.pch txtdsp.obj mscdsp.obj g_mscdsp.obj \
	bignum.obj bignum1.obj bignum2.obj bitmap.obj border.obj \
	button.obj combo.obj country.obj cursor.obj date.obj \
	date1.obj device.obj display.obj error.obj event.obj \
	fmtstr.obj group.obj help.obj hlist.obj icon.obj \
	int.obj keybrd.obj list.obj listblk.obj map1.obj \
	map2.obj max.obj min.obj mouse.obj path.obj \
	plldn.obj plldn1.obj popup.obj popup1.obj prompt.obj \
	real.obj region.obj scroll.obj store.obj store1.obj \
	string.obj sys.obj text.obj time.obj time1.obj title.obj \
	toolbar.obj vlist.obj win.obj win1.obj win2.obj \
	g_bignum.obj g_border.obj g_cursor.obj g_date.obj g_date1.obj \
	g_device.obj g_disp.obj g_event.obj g_hotkey.obj g_jump.obj \
	g_keybrd.obj g_proc.obj g_store.obj g_pnorm.obj g_phelp.obj \
	g_perror.obj g_time.obj g_time1.obj g_win1.obj g_win2.obj
	@del $*
	$(LIBRARIAN) $(DOS_LIB_OPTS) @<<zil.rsp
$* &
+txtdsp+mscdsp.obj+g_mscdsp.obj &
+bignum.obj+bignum1.obj+bignum2.obj+bitmap.obj+border.obj &
+button.obj+combo.obj+country.obj+cursor.obj+date.obj &
+date1.obj+device.obj+display.obj+error.obj+event.obj &
+fmtstr.obj+group.obj+help.obj+hlist.obj+icon.obj &
+int.obj+keybrd.obj+list.obj+listblk.obj+map1.obj &
+map2.obj+max.obj+min.obj+mouse.obj+path.obj &
+plldn.obj+plldn1.obj+popup.obj+popup1.obj+prompt.obj &
+real.obj+region.obj+scroll.obj+store.obj+store1.obj &
+string.obj+sys.obj+text.obj+time.obj+time1.obj+title.obj &
+toolbar.obj+vlist.obj+win.obj+win1.obj+win2.obj &
+g_bignum.obj+g_border.obj+g_cursor.obj+g_date.obj+g_date1.obj &
+g_device.obj+g_disp.obj+g_event.obj+g_hotkey.obj+g_jump.obj &
+g_keybrd.obj+g_proc.obj+g_store.obj+g_pnorm.obj+g_phelp.obj &
+g_perror.obj+g_time.obj+g_time1.obj+g_win1.obj+g_win2.obj
NUL
<<


zilw.lib: zilw.pch windsp.obw g_windsp.obw \
	bignum.obw bignum1.obw bignum2.obw bitmap.obw border.obw \
	button.obw combo.obw country.obw cursor.obw date.obw \
	date1.obw device.obw display.obw error.obw event.obw \
	fmtstr.obw group.obw help.obw hlist.obw icon.obw \
	int.obw keybrd.obw list.obw listblk.obw map1.obw \
	map2.obw max.obw min.obw mouse.obw path.obw \
	plldn.obw plldn1.obw popup.obw popup1.obw prompt.obw \
	real.obw region.obw scroll.obw store.obw store1.obw \
	string.obw sys.obw text.obw time.obw time1.obw title.obw \
	toolbar.obw vlist.obw win.obw win1.obw win2.obw \
	g_bignum.obw g_border.obw g_cursor.obw g_date.obw g_date1.obw \
	g_device.obw g_disp.obw g_event.obw g_hotkey.obw g_jump.obw \
	g_keybrd.obw g_proc.obw g_store.obw g_pnorm.obw g_phelp.obw \
	g_perror.obw g_time.obw g_time1.obw g_win1.obw g_win2.obw
	@del $*
	$(LIBRARIAN) $(WIN_LIB_OPTS) @<<zil.rsp
$* &
+windsp.obw+g_windsp.obw &
+bignum.obw+bignum1.obw+bignum2.obw+bitmap.obw+border.obw &
+button.obw+combo.obw+country.obw+cursor.obw+date.obw &
+date1.obw+device.obw+display.obw+error.obw+event.obw &
+fmtstr.obw+group.obw+help.obw+hlist.obw+icon.obw &
+int.obw+keybrd.obw+list.obw+listblk.obw+map1.obw &
+map2.obw+max.obw+min.obw+mouse.obw+path.obw &
+plldn.obw+plldn1.obw+popup.obw+popup1.obw+prompt.obw &
+real.obw+region.obw+scroll.obw+store.obw+store1.obw &
+string.obw+sys.obw+text.obw+time.obw+time1.obw+title.obw &
+toolbar.obw+vlist.obw+win.obw+win1.obw+win2.obw &
+g_bignum.obw+g_border.obw+g_cursor.obw+g_date.obw+g_date1.obw &
+g_device.obw+g_disp.obw+g_event.obw+g_hotkey.obw+g_jump.obw &
+g_keybrd.obw+g_proc.obw+g_store.obw+g_pnorm.obw+g_phelp.obw &
+g_perror.obw+g_time.obw+g_time1.obw+g_win1.obw+g_win2.obw
NUL
<<


# Microsoft C++ 7.00 pre-release currently can't handle C++ DLL support for Windows.
# The following should work with future versions of Microsoft C++ if the
# "class _export" problem is solved.
#zilwd.dll: zilwd.pch zilwd.res libmain.obd windsp.obd g_windsp.obd \
#	bignum.obd bignum1.obd bignum2.obd bitmap.obd border.obd \
#	button.obd combo.obd country.obd cursor.obd date.obd \
#	date1.obd device.obd display.obd error.obd event.obd \
#	fmtstr.obd group.obd help.obd hlist.obd icon.obd \
#	int.obd keybrd.obd list.obd listblk.obd map1.obd \
#	map2.obd max.obd min.obd mouse.obd path.obd \
#	plldn.obd plldn1.obd popup.obd popup1.obd prompt.obd \
#	real.obd region.obd scroll.obd store.obd store1.obd \
#	string.obd sys.obd text.obd time.obd time1.obd title.obd \
#	toolbar.obd vlist.obd win.obd win1.obd win2.obd \
#	g_bignum.obd g_border.obd g_cursor.obd g_date.obd g_date1.obd \
#	g_device.obd g_disp.obd g_event.obd g_hotkey.obd g_jump.obd \
#	g_keybrd.obd g_proc.obd g_store.obd g_pnorm.obd g_phelp.obd \
#	g_perror.obd g_time.obd g_time1.obd g_win1.obd g_win2.obd
#	@del $*
#	$(LINK) $(WINDLL_LINK_OPTS) @<<zil.rsp
#$(WINDLL_OBJS)+libmain.obd+windsp.obd+g_windsp.obd+
#bignum.obd+bignum1.obd+bignum2.obd+bitmap.obd+border.obd+
#button.obd+combo.obd+country.obd+cursor.obd+date.obd+
#date1.obd+device.obd+display.obd+error.obd+event.obd+
#fmtstr.obd+group.obd+help.obd+hlist.obd+icon.obd+
#int.obd+keybrd.obd+list.obd+listblk.obd+map1.obd+
#map2.obd+max.obd+min.obd+mouse.obd+path.obd+
#plldn.obd+plldn1.obd+popup.obd+popup1.obd+prompt.obd+
#real.obd+region.obd+scroll.obd+store.obd+store1.obd+
#string.obd+sys.obd+text.obd+time.obd+time1.obd+title.obd+
#toolbar.obd+vlist.obd+win.obd+win1.obd+win2.obd+
#g_bignum.obd+g_border.obd+g_cursor.obd+g_date.obd+g_date1.obd+
#g_device.obd+g_disp.obd+g_event.obd+g_hotkey.obd+g_jump.obd+
#g_keybrd.obd+g_proc.obd+g_store.obd+g_pnorm.obd+g_phelp.obd+
#g_perror.obd+g_time.obd+g_time1.obd+g_win1.obd+g_win2.obd
#$*, , $(WINDLL_LIBS)
#$*.def
#<<
#	rc -30 -k $*.res $*.dll
#	implib $*.lib $*.dll


## Build the pre-compiled header files:
zil.pch: ui_gen.hpp ui_dsp.hpp ui_evt.hpp ui_win.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <malloc.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_win.hpp"
<<
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obj


## Build the pre-compiled header files:
zilw.pch: ui_gen.hpp ui_dsp.hpp ui_evt.hpp ui_win.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <malloc.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_win.hpp"
<<
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obw


## Build the pre-compiled header files:
zilwd.pch: ui_gen.hpp ui_dsp.hpp ui_evt.hpp ui_win.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <malloc.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_win.hpp"
<<
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obd
