## Zinc Interface Library version 3.00 makefile
## ZIL.LIB, ZILW.LIB, ZILWD.DLL, ZILWD.LIB,
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Zortech C++ 3.00

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blinkx
LIBRARIAN=zorlibx
DOS_CPP_OPTS=-c -a1 -bx -ml
DOS_LINK_OPTS=/NOI
DOS_LIB_OPTS=/C /N /B
WIN_CPP_OPTS=-c -a1 -bx -ml -W2
WIN_LINK_OPTS=/NOI
WIN_LIB_OPTS=/C /N /B
WINDLL_CPP_OPTS=-c -a1 -bx -mluw -W2 -D__DLL__
WINDLL_LINK_OPTS=/NOI
WINDLL_LIB_OPTS=/C /N /B
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw
WINDLL_OBJS=
WINDLL_LIBS=


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obw $<

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obd $<

.rc.res:
	rc -r $<


lib: zil.lib zilw.lib


zil.lib: txtdsp.obj fgdsp.obj g_fgdsp.obj \
	bignum.obj bignum1.obj bignum2.obj bitmap.obj border.obj \
	button.obj combo.obj country.obj cursor.obj date.obj \
	date1.obj device.obj display.obj error.obj event.obj \
	fmtstr.obj group.obj help.obj hlist.obj icon.obj \
	int.obj keybrd.obj list.obj listblk.obj map1.obj \
	map2.obj max.obj min.obj mouse.obj path.obj \
	plldn.obj plldn1.obj popup.obj popup1.obj prompt.obj \
	real.obj region.obj scroll.obj store.obj store1.obj \
	string.obj sys.obj text.obj time.obj time1.obj title.obj \
	toolbar.obj vlist.obj win.obj win1.obj win2.obj \
	g_bignum.obj g_border.obj g_cursor.obj g_date.obj g_date1.obj \
	g_device.obj g_disp.obj g_event.obj g_hotkey.obj g_jump.obj \
	g_keybrd.obj g_proc.obj g_store.obj g_pnorm.obj g_phelp.obj \
	g_perror.obj g_time.obj g_time1.obj g_win1.obj g_win2.obj
	@del $*
	@echo $*>zil.rsp
	@echo +txtdsp.obj+fgdsp.obj+g_fgdsp.obj &>>zil.rsp
	@echo +bignum.obj+bignum1.obj+bignum2.obj+bitmap.obj+border.obj &>>zil.rsp
	@echo +button.obj+combo.obj+country.obj+cursor.obj+date.obj &>>zil.rsp
	@echo +date1.obj+device.obj+display.obj+error.obj+event.obj &>>zil.rsp
	@echo +fmtstr.obj+group.obj+help.obj+hlist.obj+icon.obj &>>zil.rsp
	@echo +int.obj+keybrd.obj+list.obj+listblk.obj+map1.obj &>>zil.rsp
	@echo +map2.obj+max.obj+min.obj+mouse.obj+path.obj &>>zil.rsp
	@echo +plldn.obj+plldn1.obj+popup.obj+popup1.obj+prompt.obj &>>zil.rsp
	@echo +real.obj+region.obj+scroll.obj+store.obj+store1.obj &>>zil.rsp
	@echo +string.obj+sys.obj+text.obj+time.obj+time1.obj+title.obj &>>zil.rsp
	@echo +toolbar.obj+vlist.obj+win.obj+win1.obj+win2.obj &>>zil.rsp
	@echo +g_bignum.obj+g_border.obj+g_cursor.obj+g_date.obj+g_date1.obj &>>zil.rsp
	@echo +g_device.obj+g_disp.obj+g_event.obj+g_hotkey.obj+g_jump.obj &>>zil.rsp
	@echo +g_keybrd.obj+g_proc.obj+g_store.obj+g_pnorm.obj+g_phelp.obj &>>zil.rsp
	@echo +g_perror.obj+g_time.obj+g_time1.obj+g_win1.obj+g_win2.obj>>zil.rsp
	$(LIBRARIAN) $(DOS_LIB_OPTS) @zil.rsp
	@del zil.rsp


zilw.lib: windsp.obw g_windsp.obw \
	bignum.obw bignum1.obw bignum2.obw bitmap.obw border.obw \
	button.obw combo.obw country.obw cursor.obw date.obw \
	date1.obw device.obw display.obw error.obw event.obw \
	fmtstr.obw group.obw help.obw hlist.obw icon.obw \
	int.obw keybrd.obw list.obw listblk.obw map1.obw \
	map2.obw max.obw min.obw mouse.obw path.obw \
	plldn.obw plldn1.obw popup.obw popup1.obw prompt.obw \
	real.obw region.obw scroll.obw store.obw store1.obw \
	string.obw sys.obw text.obw time.obw time1.obw title.obw \
	toolbar.obw vlist.obw win.obw win1.obw win2.obw \
	g_bignum.obw g_border.obw g_cursor.obw g_date.obw g_date1.obw \
	g_device.obw g_disp.obw g_event.obw g_hotkey.obw g_jump.obw \
	g_keybrd.obw g_proc.obw g_store.obw g_pnorm.obw g_phelp.obw \
	g_perror.obw g_time.obw g_time1.obw g_win1.obw g_win2.obw
	@del $*
	@echo $*>zil.rsp
	@echo +windsp.obw+g_windsp.obw &>>zil.rsp
	@echo +bignum.obw+bignum1.obw+bignum2.obw+bitmap.obw+border.obw &>>zil.rsp
	@echo +button.obw+combo.obw+country.obw+cursor.obw+date.obw &>>zil.rsp
	@echo +date1.obw+device.obw+display.obw+error.obw+event.obw &>>zil.rsp
	@echo +fmtstr.obw+group.obw+help.obw+hlist.obw+icon.obw &>>zil.rsp
	@echo +int.obw+keybrd.obw+list.obw+listblk.obw+map1.obw &>>zil.rsp
	@echo +map2.obw+max.obw+min.obw+mouse.obw+path.obw &>>zil.rsp
	@echo +plldn.obw+plldn1.obw+popup.obw+popup1.obw+prompt.obw &>>zil.rsp
	@echo +real.obw+region.obw+scroll.obw+store.obw+store1.obw &>>zil.rsp
	@echo +string.obw+sys.obw+text.obw+time.obw+time1.obw+title.obw &>>zil.rsp
	@echo +toolbar.obw+vlist.obw+win.obw+win1.obw+win2.obw &>>zil.rsp
	@echo +g_bignum.obw+g_border.obw+g_cursor.obw+g_date.obw+g_date1.obw &>>zil.rsp
	@echo +g_device.obw+g_disp.obw+g_event.obw+g_hotkey.obw+g_jump.obw &>>zil.rsp
	@echo +g_keybrd.obw+g_proc.obw+g_store.obw+g_pnorm.obw+g_phelp.obw &>>zil.rsp
	@echo +g_perror.obw+g_time.obw+g_time1.obw+g_win1.obw+g_win2.obw>>zil.rsp
	$(LIBRARIAN) $(WIN_LIB_OPTS) @zil.rsp
	@del zil.rsp


# Zortech C++ 3.00r4 currently can't handle C++ DLL support for Windows.
# The following should work with future versions of Zortech C++ if the
# "class _export" problem is solved.
#zilwd.dll: zilwd.res libmain.obd windsp.obd g_windsp.obd \
#	bignum.obd bignum1.obd bignum2.obd bitmap.obd border.obd \
#	button.obd combo.obd country.obd cursor.obd date.obd \
#	date1.obd device.obd display.obd error.obd event.obd \
#	fmtstr.obd group.obd help.obd hlist.obd icon.obd \
#	int.obd keybrd.obd list.obd listblk.obd map1.obd \
#	map2.obd max.obd min.obd mouse.obd path.obd \
#	plldn.obd plldn1.obd popup.obd popup1.obd prompt.obd \
#	real.obd region.obd scroll.obd store.obd store1.obd \
#	string.obd sys.obd text.obd time.obd time1.obd title.obd \
#	toolbar.obd vlist.obd win.obd win1.obd win2.obd \
#	g_bignum.obd g_border.obd g_cursor.obd g_date.obd g_date1.obd \
#	g_device.obd g_disp.obd g_event.obd g_hotkey.obd g_jump.obd \
#	g_keybrd.obd g_proc.obd g_store.obd g_pnorm.obd g_phelp.obd \
#	g_perror.obd g_time.obd g_time1.obd g_win1.obd g_win2.obd
#	@echo $(WINDLL_OBJS)+libmain.obd+windsp.obd+g_windsp.obd+>zil.rsp
#	@echo bignum.obd+bignum1.obd+bignum2.obd+bitmap.obd+border.obd+>>zil.rsp
#	@echo button.obd+combo.obd+country.obd+cursor.obd+date.obd+>>zil.rsp
#	@echo date1.obd+device.obd+display.obd+error.obd+event.obd+>>zil.rsp
#	@echo fmtstr.obd+group.obd+help.obd+hlist.obd+icon.obd+>>zil.rsp
#	@echo int.obd+keybrd.obd+list.obd+listblk.obd+map1.obd+>>zil.rsp
#	@echo map2.obd+max.obd+min.obd+mouse.obd+path.obd+>>zil.rsp
#	@echo plldn.obd+plldn1.obd+popup.obd+popup1.obd+prompt.obd+>>zil.rsp
#	@echo real.obd+region.obd+scroll.obd+store.obd+store1.obd+>>zil.rsp
#	@echo string.obd+sys.obd+text.obd+time.obd+time1.obd+title.obd+>>zil.rsp
#	@echo toolbar.obd+vlist.obd+win.obd+win1.obd+win2.obd+>>zil.rsp
#	@echo g_bignum.obd+g_border.obd+g_cursor.obd+g_date.obd+g_date1.obd+>>zil.rsp
#	@echo g_device.obd+g_disp.obd+g_event.obd+g_hotkey.obd+g_jump.obd+>>zil.rsp
#	@echo g_keybrd.obd+g_proc.obd+g_store.obd+g_pnorm.obd+g_phelp.obd+>>zil.rsp
#	@echo g_perror.obd+g_time.obd+g_time1.obd+g_win1.obd+g_win2.obd>>zil.rsp
#	@echo $*, , $(WINDLL_LIBS)>>zil.rsp
#	@echo $*.def>>zil.rsp
#	$(LINK) $(WINDLL_LINK_OPTS) @zil.rsp
#	rc -k $*.res $*.dll
#	implib $*.lib $*.dll
#	@del zil.rsp
