//	Zinc Interface Library - MAP1.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#pragma hdrstop

// ----- UI_PALETTE_MAP -----------------------------------------------------

#ifdef _WINDOWS
UI_PALETTE *UI_PALETTE_MAP::MapPalette(UI_PALETTE_MAP *mapTable,
	LOGICAL_PALETTE logicalPalette, OBJECTID id1, OBJECTID, OBJECTID,
	OBJECTID, OBJECTID)
{
	// Find the matching palette.
	UI_PALETTE *palette = &mapTable[0].palette;
	palette->fillPattern = PTN_RGB_COLOR;
	switch (id1)
	{
	case ID_BORDER:
	case ID_TITLE:
		palette->colorBackground = GetSysColor(COLOR_ACTIVEBORDER);
		palette->colorForeground = GetSysColor(COLOR_ACTIVECAPTION);
		break;

	case ID_ICON:
		if (logicalPalette == PM_CURRENT)
			palette->colorBackground = GetSysColor(COLOR_ACTIVECAPTION);
		else
			palette->colorBackground = GetSysColor(COLOR_INACTIVECAPTION);
		palette->colorForeground = GetSysColor(COLOR_CAPTIONTEXT);
		break;

	case ID_BUTTON:
	case ID_MAXIMIZE_BUTTON:
	case ID_MINIMIZE_BUTTON:
	case ID_SYSTEM_BUTTON:
	case ID_TOOL_BAR:
		palette->colorBackground = GetSysColor(COLOR_BTNFACE);
		palette->colorForeground = GetSysColor(COLOR_BTNTEXT);
		break;

	case ID_POP_UP_MENU:
	case ID_PULL_DOWN_MENU:
	case ID_POP_UP_ITEM:
	case ID_PULL_DOWN_ITEM:
		palette->colorBackground = GetSysColor(COLOR_MENU);
		palette->colorForeground = GetSysColor(COLOR_MENUTEXT);
		break;

	default:
		if (logicalPalette == PM_SELECTED)
		{
			palette->colorBackground = GetSysColor(COLOR_HIGHLIGHT);
			palette->colorForeground = GetSysColor(COLOR_HIGHLIGHTTEXT);
		}
		else
		{
			palette->colorBackground = GetSysColor(COLOR_WINDOW);
			palette->colorForeground = GetSysColor(COLOR_WINDOWTEXT);
		}
		break;
	}

	// Return the matching palette.
	return (palette);
}
#else
UI_PALETTE *UI_PALETTE_MAP::MapPalette(UI_PALETTE_MAP *mapTable,
	LOGICAL_PALETTE logicalPalette, OBJECTID id1, OBJECTID id2, OBJECTID id3,
	OBJECTID id4, OBJECTID id5)
{
	int level = 10;
	UI_PALETTE *palette = &mapTable[0].palette;
	int id[5] = { id1, id2, id3, id4, id5 };

	// Try to find a matching palette.
	for (UI_PALETTE_MAP *map = mapTable; map->objectID != ID_END; map++)
		if (map->objectID == id1 && FlagsSet(logicalPalette, map->logicalPalette))
			return (&map->palette);
		else
		{
			for (int i = 0; i < 6; i++)
				if (map->objectID == id[i] &&
					map->logicalPalette == PM_ANY && level > 2 * i + 1)
				{
					level = 2 * i + 1;
					palette = &map->palette;
					break;
				}
				else if (map->objectID == id[i] &&
					FlagsSet(logicalPalette, map->logicalPalette) && level > 2 * i)
				{
					level = 2 * i;
					palette = &map->palette;
					break;
				}
		}

	// Return the logical match palette.
	return (palette);
}
#endif

