//	Zinc Interface Library - MAP2.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#pragma hdrstop

// ----- UI_EVENT_MAP -------------------------------------------------------

EVENT_TYPE UI_EVENT_MAP::MapEvent(UI_EVENT_MAP *mapTable,
	const UI_EVENT &event, OBJECTID id1, OBJECTID id2, OBJECTID id3,
	OBJECTID id4, OBJECTID id5)
{
#ifdef _WINDOWS
	// See if the type is already mapped.
	EVENT_TYPE logicalValue = event.type;
	EVENT_TYPE eventType = event.message.message;
	USHORT eventRawCode;
	if (logicalValue != E_MSWINDOWS)
		return (logicalValue);
	else if (eventType >= WM_KEYFIRST && eventType <= WM_KEYLAST)
		eventRawCode = event.key.value;
	else if (eventType >= WM_MOUSEFIRST && eventType <= WM_MOUSELAST)
		eventRawCode = event.message.wParam;
	else
		switch (eventType)
		{
		case WM_ACTIVATE:
		case WM_ACTIVATEAPP:
		case WM_SYSCOMMAND:
		case WM_ENABLE:
		case WM_MENUCHAR:
			eventRawCode = event.message.wParam;
			break;

		default:
			eventRawCode = 0;
			break;
		}
#else
	// See if the type is already mapped.
	EVENT_TYPE logicalValue = event.type;
	EVENT_TYPE eventType = event.type;
	if (logicalValue > E_DEVICE_LAST)
		return (logicalValue);
	USHORT eventRawCode = event.rawCode;
#endif
	int level = 4;
	OBJECTID id[4] = { id2, id3, id4, id5 };

	// Try to find a matching event.
	for (UI_EVENT_MAP *map = mapTable; map->objectID != ID_END; map++)
		if (map->rawCode == eventRawCode && map->eventType == eventType)
		{
			if (map->objectID == id1)
				return (map->logicalValue);
			for (int i = 0; i < 4; i++)
				if (map->objectID == id[i] && level > i)
				{
					level = i;
					logicalValue = map->logicalValue;
					break;
				}
		}

	// Return the logical match value.
	return (logicalValue);
}
