//	Zinc Interface Library - MIN.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_MINIMIZE_BUTTON ------------------------------------------------

UIW_MINIMIZE_BUTTON::UIW_MINIMIZE_BUTTON(void) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_SEND_MESSAGE | BTF_NO_TOGGLE,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION,
	NULL, L_MINIMIZE)
{
	// Initialize the minimize button information.
	UIW_MINIMIZE_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

UIW_MINIMIZE_BUTTON::~UIW_MINIMIZE_BUTTON(void)
{
	// Restore the minimize button information.
	text = NULL;		   	// text is a static string.
	bitmapArray = NULL;		// bitmapArray is a static array.
}

#ifdef _WINDOWS
EVENT_TYPE UIW_MINIMIZE_BUTTON::Event(const UI_EVENT &event)
{
	// Initialize the minimize button.
	if (event.type == S_INITIALIZE)
	{
		UI_WINDOW_OBJECT::Event(event);
		dwStyle = WS_MINIMIZEBOX;
		parent->Information(SET_DWSTYLE, &dwStyle);
	}
	return (event.type);
}
#else
static char *_tNormal = "[]";
static char *_tMinimized = "[]";

static UCHAR _gNormal[37] =
{
	7, 5, 
	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,
	BLACK,		BLACK,		BLACK,		BLACK,		BLACK,		BLACK,		BLACK,
	BACKGROUND,	BLACK,		BLACK,		BLACK,		BLACK,		BLACK,		BACKGROUND,
	BACKGROUND,	BACKGROUND,	BLACK,		BLACK,		BLACK,		BACKGROUND,	BACKGROUND,
	BACKGROUND,	BACKGROUND,	BACKGROUND,	BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND
};

EVENT_TYPE UIW_MINIMIZE_BUTTON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_MINIMIZE_BUTTON);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		if (FlagSet(parent->woStatus, WOS_MINIMIZED))
		{
			woStatus |= WOS_SELECTED;
			value = L_RESTORE;
		}
		else
		{
			woStatus &= ~WOS_SELECTED;
			value = L_MINIMIZE;
		}
		UI_WINDOW_OBJECT::Event(event);
		if (display->isText)
		{
			text = FlagSet(parent->woStatus, WOS_MINIMIZED) ? _tMinimized : _tNormal;
			true.left = true.right - 2;
			true.bottom = true.top;
		}
		else
		{
			text = NULL;
			UCHAR *bitmap = _gNormal;
			bitmapWidth = bitmap[0];
			bitmapHeight = bitmap[1];
			bitmapArray = &bitmap[2];
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
			true.left = ++true.right - (display->cellHeight - display->preSpace - display->postSpace);
		}
		break;

	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		if (display->isText)
		{
			lastPalette = LogicalPalette(ccode);
			UIW_BUTTON::DrawItem(event, ccode);
			woStatus &= ~WOS_REDISPLAY;
			break;
		}
		ccode = UIW_BUTTON::Event(event);
		break;

	case L_BEGIN_SELECT:
		if (!FlagSet(parent->woStatus, WOS_MAXIMIZED))
		{
			UIW_BUTTON::Event(event);
			while (ccode != L_END_SELECT)
			{
				UI_EVENT sEvent;
				eventManager->Get(sEvent);
				ccode = LogicalEvent(sEvent, ID_MINIMIZE_BUTTON);
				UIW_BUTTON::Event(sEvent);
			}
		}
		break;

	case L_CONTINUE_SELECT:
	case L_END_SELECT:
		if (!FlagSet(parent->woStatus, WOS_MAXIMIZED))
			ccode = UIW_BUTTON::Event(event);
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_MINIMIZE_BUTTON::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_MINIMIZE_BUTTON;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_MINIMIZE_BUTTON;
		windowID[1] = ID_BUTTON;
		numberID = NUMID_MINIMIZE;
		strcpy(stringID, "NUMID_MINIMIZE");
		woAdvancedFlags |= WOAF_NON_CURRENT;
		btFlags |= BTF_SEND_MESSAGE | BTF_NO_TOGGLE;
		hotKey = HOT_KEY_MINIMIZE;
		depth = 1;
		break;

	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (parent)
			parent->Information(SET_DWSTYLE, &dwStyle);
#endif
		break;

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_MINIMIZE_BUTTON::UIW_MINIMIZE_BUTTON(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_SEND_MESSAGE,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION,
	NULL, L_MINIMIZE)
{
	// Initialize the minimize button information.
	UIW_MINIMIZE_BUTTON::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::Information(INITIALIZE_CLASS, NULL);
	UIW_MINIMIZE_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

void UIW_MINIMIZE_BUTTON::Load(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
{
}

void UIW_MINIMIZE_BUTTON::Store(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
{
	// Flag the object as being used.
	if (objectTable)
	{
		for (int i = 0; objectTable[i].data; i++)
			if (objectTable[i].value == searchID)
			{
				objectTable[i].flags = TRUE;
				break;
			}
	}
}
#endif

