//	Zinc Interface Library - PLLDN.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_PULL_DOWN_MENU -------------------------------------------------

UIW_PULL_DOWN_MENU::UIW_PULL_DOWN_MENU(int _indentation, WOF_FLAGS _woFlags,
	WOAF_FLAGS _woAdvancedFlags) :
	UIW_WINDOW(0, 0, 0, 0, _woFlags | WOF_SUPPORT_OBJECT, _woAdvancedFlags),
	indentation(_indentation)
{
	// Initialize the pull-down menu information.
	UIW_PULL_DOWN_MENU::Information(INITIALIZE_CLASS, NULL);
}

UIW_PULL_DOWN_MENU::UIW_PULL_DOWN_MENU(int _indentation, UI_ITEM *item) :
	UIW_WINDOW(0, 0, 0, 0, WOF_BORDER | WOF_NON_FIELD_REGION | WOF_SUPPORT_OBJECT, WOAF_NO_FLAGS),
	indentation(_indentation)
{
	// Initialize the pull-down menu information.
	UIW_PULL_DOWN_MENU::Information(INITIALIZE_CLASS, NULL);

	// Add the pull-down menu items.
	for (int i = 0; item[i].text; i++)
		Add(new UIW_PULL_DOWN_ITEM(item[i].text, item[i].flags,
			(USER_FUNCTION)item[i].data, item[i].value));
}

UIW_PULL_DOWN_MENU::~UIW_PULL_DOWN_MENU(void)
{
}

#ifdef _WINDOWS
EVENT_TYPE UIW_PULL_DOWN_MENU::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		{
		if (parent->parent)		// Sub-windows cannot have pull-down menus.
			return (S_UNKNOWN);
		UI_WINDOW_OBJECT::Event(event);
		screenID = CreateMenu();
		parent->Information(SET_MENU, &screenID);
		for (UI_WINDOW_OBJECT *object = First(); object; object = object->Next())
			object->Event(event);
		if (parent->screenID)
			SetMenu(parent->screenID, screenID);
		}
		break;

	case S_ADD_OBJECT:
		UIW_WINDOW::Event(event);
		break;

	case S_SUBTRACT_OBJECT:
		object = (UI_WINDOW_OBJECT *)event.data;
		if (screenID)
			DeleteMenu(screenID, UI_LIST::Index(object), MF_BYPOSITION);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
EVENT_TYPE UIW_PULL_DOWN_MENU::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_PULL_DOWN_MENU);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		UI_WINDOW_OBJECT::Event(event);
		clipList.Destroy();
		// Continue to S_REDISPLAY.
	case S_REDISPLAY:
		{
		int left = 0, top = 0, height = display->cellHeight;
		if (display->isText)
		{
			woFlags &= ~WOF_BORDER;
			true.bottom = true.top;
			relative.right = true.right - true.left + 1;
			relative.bottom = true.bottom - true.top + 1;
		}
		else
		{
			woFlags |= WOF_BORDER;
			true.left--; true.right++;
			height -= (display->preSpace + display->postSpace);
			true.bottom = --true.top + height + 1;
			relative.right = true.right - true.left - 1;
			relative.bottom = true.bottom - true.top - 1;
		}
		for (object = First(); object; object = object->Next())
		{
			int width = object->relative.right - object->relative.left + 1;
			if (left + width > relative.right)
			{
				left = 0;
				top += relative.bottom;
				true.bottom += height;
			}
			object->relative.left = left;
			object->relative.top = top;
			left += width;
			object->relative.right = left - 1;
			object->relative.bottom = top + height - 1;
		}

		// Compute the actual regions.
		UI_REGION region = true;
		if (FlagSet(woFlags, WOF_BORDER))
			--region;
		clipList.Destroy();
		clipList.Add(new UI_REGION_ELEMENT(screenID, region));
		for (object = First(); object; object = object->Next())
			if (ccode == S_REDISPLAY)
				object->Event(UI_EVENT(S_CREATE));
			else
				object->Event(event);
		}
		break;

	case L_UP:
	case L_DOWN:
		ccode = Current()->Event(event);
		break;

	case L_LEFT:
	case L_RIGHT:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_LEFT) ? L_PREVIOUS : L_NEXT));
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_BEGIN_SELECT:
	case L_CONTINUE_SELECT:
	case L_END_SELECT:
		if (!FlagSet(woStatus, WOS_EDIT_MODE))
			ccode = UIW_WINDOW::Event(event);
		break;

	default:
		// Try to find the hotkey menu item.
		if (ccode == E_KEY && !FlagSet(event.key.shiftState, S_ALT))
		{
			for (object = First(); object; object = object->Next())
				if (object->HotKey() == event.key.value && !FlagSet(object->woFlags, WOF_NON_SELECTABLE))
				{
					UIW_WINDOW::Add(object);
					return (object->Event(UI_EVENT(L_SELECT)));
				}
		}
		else
			ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_PULL_DOWN_MENU::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_PULL_DOWN_MENU;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_PULL_DOWN_MENU;
		windowID[1] = ID_MENU;
		windowID[2] = ID_WINDOW;
		font = FNT_SYSTEM_FONT;
		hotKey = HOT_KEY_SUB_WINDOW;
		wnFlags |= WNF_CONTINUE_SELECT;
		break;

	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (parent)
			parent->Information(SET_MENU, &screenID);
#else
		if (screenID && request == CHANGED_FLAGS && objectID == ID_PULL_DOWN_MENU)
			return (parent->Information(request, data));
#endif
		break;

	default:
		data = UIW_WINDOW::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_PULL_DOWN_MENU::UIW_PULL_DOWN_MENU(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_WINDOW(0, 0, 0, 0, WOF_BORDER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION,
	WOAF_NO_FLAGS)
{
	// Initialize the pull-down menu information.
	Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_WINDOW::Information(INITIALIZE_CLASS, NULL);
	UIW_PULL_DOWN_MENU::Information(INITIALIZE_CLASS, NULL);
}

void UIW_PULL_DOWN_MENU::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Read the file information.
	UIW_WINDOW::Load(name, directory, file);
}

void UIW_PULL_DOWN_MENU::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the pull-down menu information.
	UIW_WINDOW::Store(name, directory, file);
}
#endif

