//	Zinc Interface Library - POPUP.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_POP_UP_MENU ----------------------------------------------------

UIW_POP_UP_MENU::UIW_POP_UP_MENU(int left, int top, WNF_FLAGS _wnFlags,
	WOF_FLAGS _woFlags, WOAF_FLAGS _woAdvancedFlags) :
	UIW_WINDOW(left, top, 0, 0, _woFlags, _woAdvancedFlags)
{
	// Initialize the menu information.
	wnFlags = _wnFlags;
	UIW_POP_UP_MENU::Information(INITIALIZE_CLASS, NULL);
}

UIW_POP_UP_MENU::UIW_POP_UP_MENU(int left, int top, WNF_FLAGS _wnFlags, UI_ITEM *item) :
	UIW_WINDOW(left, top, 0, 0, WOF_BORDER)
{
	// Initialize the menu information.
	wnFlags = _wnFlags;
	UIW_POP_UP_MENU::Information(INITIALIZE_CLASS, NULL);

	// Add the pop-up menu items.
	for (int i = 0; item[i].text; i++)
		Add(new UIW_POP_UP_ITEM(item[i].text, item[i].flags, BTF_NO_3D,
			WOF_NO_FLAGS, (USER_FUNCTION)item[i].data, item[i].value));
}

UIW_POP_UP_MENU::~UIW_POP_UP_MENU(void)
{
}

#ifdef _WINDOWS
EVENT_TYPE UIW_POP_UP_MENU::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		screenID = CreatePopupMenu();
		for (object = First(); object; object = object->Next())
			object->Event(event);
		break;

	case S_ADD_OBJECT:
		UIW_WINDOW::Event(event);
		break;

	case S_SUBTRACT_OBJECT:
		object = (UI_WINDOW_OBJECT *)event.data;
		if (screenID)
			DeleteMenu(screenID, UI_LIST::Index(object), MF_BYPOSITION);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
EVENT_TYPE UIW_POP_UP_MENU::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_POP_UP_MENU);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		{
		// Compute the pop-up item positions.
		int width = 0, height = 0, top = 0;
		for (object = First(); object; object = object->Next())
		{
			int tWidth = object->relative.right - object->relative.left + 1;
			if (tWidth > width)
				width = tWidth;
			height += (object->relative.bottom - object->relative.top + 1);
		}
		relative.right = relative.left + width - 1;
		relative.bottom = relative.top + height - 1;
		if (FlagSet(woFlags, WOF_BORDER) &&
			(!display->isText || FlagSet(woAdvancedFlags, WOAF_TEMPORARY)))
		{
			relative.right += 2;
			relative.bottom += 2;
		}
		for (object = First(); object; object = object->Next())
		{
			height = (object->relative.bottom - object->relative.top + 1);
			object->relative.left = 0;
			object->relative.top = top;
			object->relative.right = width - 1;
			top += height;
			object->relative.bottom = top - 1;
		}
		UIW_WINDOW::Event(event);
		}
		break;

	case L_UP:
	case L_DOWN:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_UP) ? L_PREVIOUS : L_NEXT));
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_END_SELECT:
		if (!true.Overlap(event.position) &&
			parent && parent->true.Overlap(event.position))
			break;
		ccode = UIW_WINDOW::Event(event);
		break;

	case L_VIEW:
	case L_BEGIN_SELECT:
		if (FlagSet(woStatus, WOS_EDIT_MODE))
			return (UI_WINDOW_OBJECT::Event(event));
		// Continue to default.
	default:
		// Try to find the hotkey menu item.
		if (ccode == E_KEY && !FlagSet(event.key.shiftState, S_ALT))
		{
			for (object = First(); object; object = object->Next())
				if (object->HotKey() == event.key.value && !FlagSet(object->woFlags, WOF_NON_SELECTABLE))
				{
					UIW_WINDOW::Add(object);
					return (object->Event(UI_EVENT(L_SELECT)));
				}
		}
		else
			ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_POP_UP_MENU::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_POP_UP_MENU;
		windowID[1] = ID_MENU;
		windowID[2] = ID_WINDOW;
		wnFlags |= WNF_CONTINUE_SELECT;
		font = FNT_SYSTEM_FONT;
		break;

	default:
		data = UIW_WINDOW::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_POP_UP_MENU::UIW_POP_UP_MENU(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) : 
	UIW_WINDOW(0, 0, 20, 6, WOF_NO_FLAGS, WOAF_NO_FLAGS)
{
	// Initialize the menu information.
	UIW_POP_UP_MENU::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_WINDOW::Information(INITIALIZE_CLASS, NULL);
	UIW_POP_UP_MENU::Information(INITIALIZE_CLASS, NULL);
}

void UIW_POP_UP_MENU::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Load the pop-up menu information.
	UIW_WINDOW::Load(name, directory, file);
}

void UIW_POP_UP_MENU::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the pop-up menu information.
	UIW_WINDOW::Store(name, directory, file);
}
#endif

